/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import javax.sql.DataSource;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.LoggerConfig;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormConfigBuilder;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.TableNameMapper;

@Experimental
public class SormBuilder {
    private DataSource dataSource;
    private SormConfigBuilder configBuilder = new SormConfigBuilder();

    public Sorm build() {
        return Sorm.create(this.dataSource, this.configBuilder.build());
    }

    public SormBuilder setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public SormBuilder setDataSource(String jdbcUrl, String username, String password) {
        this.dataSource = Sorm.createDriverManagerDataSource(jdbcUrl, username, password);
        return this;
    }

    public SormBuilder setColumnFieldMapper(ColumnFieldMapper fieldNameMapper) {
        this.configBuilder.setColumnFieldMapper(fieldNameMapper);
        return this;
    }

    public SormBuilder setTableNameMapper(TableNameMapper tableNameMapper) {
        this.configBuilder.setTableNameMapper(tableNameMapper);
        return this;
    }

    public SormBuilder setResultSetConverter(ResultSetConverter resultSetConverter) {
        this.configBuilder.setResultSetConverter(resultSetConverter);
        return this;
    }

    public SormBuilder setSqlParametersSetter(SqlParametersSetter sqlParametersSetter) {
        this.configBuilder.setSqlParametersSetter(sqlParametersSetter);
        return this;
    }

    public SormBuilder setMultiRowProcessorType(SormConfigBuilder.MultiRowProcessorType multiRowProcessorType) {
        this.configBuilder.setMultiRowProcessorType(multiRowProcessorType);
        return this;
    }

    public SormBuilder setBatchSize(int size) {
        this.configBuilder.setBatchSize(size);
        return this;
    }

    public SormBuilder setMultiRowSize(int size) {
        this.configBuilder.setMultiRowSize(size);
        return this;
    }

    public SormBuilder setBatchSizeWithMultiRow(int size) {
        this.configBuilder.setBatchSizeWithMultiRow(size);
        return this;
    }

    public SormBuilder setTransactionIsolationLevel(int level) {
        this.configBuilder.setTransactionIsolationLevel(level);
        return this;
    }

    public SormBuilder setOption(String name, Object value) {
        this.configBuilder.setOption(name, value);
        return this;
    }

    public SormBuilder setLoggerOnAll() {
        this.configBuilder.setLoggerOnAll();
        return this;
    }

    public SormBuilder setLoggerOffAll() {
        this.configBuilder.setLoggerOffAll();
        return this;
    }

    public SormBuilder setLoggerOn(LoggerConfig.Category ... categories) {
        this.configBuilder.setLoggerOn(categories);
        return this;
    }

    public SormBuilder setLoggerOff(LoggerConfig.Category ... categories) {
        this.configBuilder.setLoggerOff(categories);
        return this;
    }
}

