/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.OrmColumnAliasPrefix;
import org.nkjmlab.sorm4j.annotation.OrmConstructor;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.internal.mapping.Mapping;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;

public final class ColumnsMapping<T>
extends Mapping<T> {
    private final PojoCreator<T> pojoCreator;
    private final Map<List<String>, int[]> columnTypesMap = new ConcurrentHashMap<List<String>, int[]>();

    public ColumnsMapping(SormOptions options, ResultSetConverter resultSetConverter, Class<T> objectClass, ColumnToAccessorMap columnToAccessorMap) {
        super(options, resultSetConverter, objectClass, columnToAccessorMap);
        SetterPojoCreator setterPojoCreator = new SetterPojoCreator(Try.getOrThrow(() -> objectClass.getDeclaredConstructor(new Class[0]), e -> new SormException(StringUtils.format("The given container class [{}] should have the public default constructor (with no arguments) or {} annotated constructor.", objectClass, OrmConstructor.class.getName()), (Throwable)e)));
        List annotataedConstructors = Arrays.stream(objectClass.getDeclaredConstructors()).filter(c -> c.getAnnotation(OrmConstructor.class) != null).collect(Collectors.toList());
        if (annotataedConstructors.size() > 1) {
            throw new SormException(StringUtils.format("Constructor with parameters annotated by {} should be one or less. ", OrmConstructor.class.getName()));
        }
        this.pojoCreator = annotataedConstructors.isEmpty() ? setterPojoCreator : new ConstructorPojoCreator((Constructor)annotataedConstructors.get(0));
    }

    private int[] getColumnTypes(ResultSet resultSet, List<String> columns) {
        return this.columnTypesMap.computeIfAbsent(columns, k -> Try.getOrThrow(() -> {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int n = metaData.getColumnCount();
            int[] ret = new int[n];
            for (int i = 1; i <= ret.length; ++i) {
                ret[i - 1] = metaData.getColumnType(i);
            }
            return ret;
        }, Try::rethrow));
    }

    public String getFormattedString() {
        return "[" + ColumnsMapping.class.getSimpleName() + "] Columns are mappted to a class" + System.lineSeparator() + super.getColumnToAccessorString();
    }

    List<T> loadPojoList(ResultSet resultSet) throws SQLException {
        return this.pojoCreator.loadPojoList(resultSet, this.createColumns(resultSet));
    }

    T loadPojo(ResultSet resultSet) throws SQLException {
        return this.loadPojo(this.createColumns(resultSet), resultSet);
    }

    T loadPojo(List<String> columns, ResultSet resultSet) throws SQLException {
        return this.pojoCreator.loadPojo(resultSet, columns);
    }

    private List<String> createColumns(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colNum = metaData.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(colNum);
        for (int i = 1; i <= colNum; ++i) {
            columns.add(metaData.getColumnName(i));
        }
        return columns;
    }

    public List<String> createColumnLabels(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colNum = metaData.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(colNum);
        for (int i = 1; i <= colNum; ++i) {
            columns.add(metaData.getColumnLabel(i));
        }
        return columns;
    }

    private final class ConstructorPojoCreator<S>
    extends PojoCreator<S> {
        private final Map<String, Class<?>> parameterTypes;
        private final Map<String, Integer> parameterOrders;
        private final int parametersLength;
        private final Map<List<String>, Class<?>[]> parameterTypesOrderedByColumnMap;
        private final Map<List<String>, int[]> parameterOrderedByColumnMap;

        public ConstructorPojoCreator(Constructor<S> constructor) {
            super(constructor);
            this.parameterTypes = new HashMap();
            this.parameterOrders = new HashMap<String, Integer>();
            this.parameterTypesOrderedByColumnMap = new ConcurrentHashMap<List<String>, Class<?>[]>();
            this.parameterOrderedByColumnMap = new ConcurrentHashMap<List<String>, int[]>();
            String colmunAliasPrefix = Optional.ofNullable(ColumnsMapping.this.getObjectClass().getAnnotation(OrmColumnAliasPrefix.class)).map(a -> a.value()).orElse("");
            String[] parameterNames = constructor.getAnnotation(OrmConstructor.class).value();
            Parameter[] parameters = constructor.getParameters();
            this.parametersLength = parameters.length;
            for (int i = 0; i < this.parametersLength; ++i) {
                Parameter parameter = parameters[i];
                String name = StringUtils.toCanonical(parameterNames[i]);
                this.parameterOrders.put(name, i);
                this.parameterTypes.put(name, parameter.getType());
                if (colmunAliasPrefix == null) continue;
                this.parameterOrders.put(StringUtils.toCanonical(colmunAliasPrefix + name), i);
                this.parameterTypes.put(StringUtils.toCanonical(colmunAliasPrefix + name), parameter.getType());
            }
        }

        private S createPojo(ResultSet resultSet, int[] sqlTypes, Class<?>[] parameterTypes, int[] orders) {
            try {
                Object[] params = new Object[this.parametersLength];
                for (int i = 1; i <= orders.length; ++i) {
                    int order = orders[i - 1];
                    if (order == -1) continue;
                    params[order] = ColumnsMapping.this.resultSetConverter.convertColumnValueTo(ColumnsMapping.this.options, resultSet, i, sqlTypes[i - 1], parameterTypes[i - 1]);
                }
                return (S)this.constructor.newInstance(params);
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                throw new SormException("Constructor with parameters of container class for object-relation mapping is not match with columns.", e);
            }
        }

        private Class<?>[] getParameterTypes(List<String> columns) {
            return this.parameterTypesOrderedByColumnMap.computeIfAbsent(columns, key -> (Class[])columns.stream().map(columnName -> this.parameterTypes.get(StringUtils.toCanonical(columnName))).toArray(Class[]::new));
        }

        private int[] getParameterOrders(List<String> columns) {
            return this.parameterOrderedByColumnMap.computeIfAbsent(columns, key -> columns.stream().mapToInt(columnName -> {
                Integer o = this.parameterOrders.get(StringUtils.toCanonical(columnName));
                return o != null ? o : -1;
            }).toArray());
        }

        @Override
        List<S> loadPojoList(ResultSet resultSet, List<String> columns) throws SQLException {
            int[] columnTypes = ColumnsMapping.this.getColumnTypes(resultSet, columns);
            Class<?>[] parameterTypes = this.getParameterTypes(columns);
            int[] orders = this.getParameterOrders(columns);
            ArrayList<S> ret = new ArrayList<S>();
            while (resultSet.next()) {
                ret.add(this.createPojo(resultSet, columnTypes, parameterTypes, orders));
            }
            return ret;
        }

        @Override
        S loadPojo(ResultSet resultSet, List<String> columns) throws SQLException {
            int[] columnTypes = ColumnsMapping.this.getColumnTypes(resultSet, columns);
            Class<?>[] parameterTypes = this.getParameterTypes(columns);
            int[] orders = this.getParameterOrders(columns);
            return this.createPojo(resultSet, columnTypes, parameterTypes, orders);
        }
    }

    private final class SetterPojoCreator<S>
    extends PojoCreator<S> {
        private final Map<List<String>, Class<?>[]> setterTypesMap;

        public SetterPojoCreator(Constructor<S> constructor) {
            super(constructor);
            this.setterTypesMap = new ConcurrentHashMap<List<String>, Class<?>[]>();
        }

        private Class<?>[] getSetterTypes(List<String> columns) {
            return this.setterTypesMap.computeIfAbsent(columns, k -> (Class[])columns.stream().map(columnName -> {
                Accessor acc = ColumnsMapping.this.columnToAccessorMap.get((String)columnName);
                return acc != null ? acc.getSetterParameterType() : null;
            }).toArray(Class[]::new));
        }

        @Override
        S loadPojo(ResultSet resultSet, List<String> columns) throws SQLException {
            Class<?>[] setterTypes = this.getSetterTypes(columns);
            int[] columnTypes = ColumnsMapping.this.getColumnTypes(resultSet, columns);
            return this.createPojo(resultSet, columns, columnTypes, setterTypes);
        }

        @Override
        public List<S> loadPojoList(ResultSet resultSet, List<String> columns) throws SQLException {
            Class<?>[] setterTypes = this.getSetterTypes(columns);
            int[] columnTypes = ColumnsMapping.this.getColumnTypes(resultSet, columns);
            ArrayList<S> ret = new ArrayList<S>();
            while (resultSet.next()) {
                ret.add(this.createPojo(resultSet, columns, columnTypes, setterTypes));
            }
            return ret;
        }

        private S createPojo(ResultSet resultSet, List<String> columns, int[] sqlTypes, Class<?>[] setterTypes) {
            try {
                Object ret = this.constructor.newInstance(new Object[0]);
                for (int i = 1; i <= columns.size(); ++i) {
                    Class<?> setterType = setterTypes[i - 1];
                    int sqlType = sqlTypes[i - 1];
                    if (setterType == null) continue;
                    String columnName = columns.get(i - 1);
                    Object value = ColumnsMapping.this.resultSetConverter.convertColumnValueTo(ColumnsMapping.this.options, resultSet, i, sqlType, setterType);
                    ColumnsMapping.this.setValue(ret, columnName, value);
                }
                return (S)ret;
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                throw new SormException("Container class for object relation mapping must have the public default constructor (with no arguments).", e);
            }
        }
    }

    private static abstract class PojoCreator<S> {
        protected final Constructor<S> constructor;

        public PojoCreator(Constructor<S> constructor) {
            this.constructor = constructor;
            constructor.setAccessible(true);
        }

        abstract List<S> loadPojoList(ResultSet var1, List<String> var2) throws SQLException;

        abstract S loadPojo(ResultSet var1, List<String> var2) throws SQLException;
    }
}

