/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TableSql {
    private static final Map<String, String> multiRowSqlMap = new ConcurrentHashMap<String, String>();
    private final String insertOrMergePlaceholders;
    private final String selectByPrimaryKeySql;
    private final String selectAllSql;
    private final String insertSql;
    private final String updateSql;
    private final String deleteSql;
    private final String mergeSql;
    private final String existsSql;
    private final String insertSqlPrefix;
    private final String mergeSqlPrefix;

    public TableSql(String insertOrMergePlaceholders, String selectByPrimaryKeySql, String selectAllSql, String insertSql, String updateSql, String deleteSql, String mergeSql, String existsSql, String insertSqlPrefix, String mergeSqlPrefix) {
        this.insertOrMergePlaceholders = insertOrMergePlaceholders;
        this.selectByPrimaryKeySql = selectByPrimaryKeySql;
        this.selectAllSql = selectAllSql;
        this.insertSql = insertSql;
        this.updateSql = updateSql;
        this.deleteSql = deleteSql;
        this.mergeSql = mergeSql;
        this.existsSql = existsSql;
        this.insertSqlPrefix = insertSqlPrefix;
        this.mergeSqlPrefix = mergeSqlPrefix;
    }

    public String getDeleteSql() {
        return this.deleteSql;
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public String getMergeSql() {
        return this.mergeSql;
    }

    public String getMultirowInsertSql(int num) {
        return this.getSqlWithMultirowPlaceholders(this.insertSqlPrefix, num);
    }

    public String getMultirowMergeSql(int num) {
        return this.getSqlWithMultirowPlaceholders(this.mergeSqlPrefix, num);
    }

    private String getSqlWithMultirowPlaceholders(String sqlPrefix, int num) {
        return multiRowSqlMap.computeIfAbsent(sqlPrefix + num, n -> sqlPrefix + String.join((CharSequence)",", Stream.generate(() -> this.insertOrMergePlaceholders).limit(num).collect(Collectors.toList())));
    }

    public String getSelectAllSql() {
        return this.selectAllSql;
    }

    public String getSelectByPrimaryKeySql() {
        return this.selectByPrimaryKeySql;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    public String getExistsSql() {
        return this.existsSql;
    }
}

