/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.multirow;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.nkjmlab.sorm4j.extension.LoggerConfig;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.BatchHelper;
import org.nkjmlab.sorm4j.internal.util.LogPoint;
import org.nkjmlab.sorm4j.internal.util.Try;

public abstract class MultiRowProcessor<T> {
    private final int batchSize;
    private final SqlParametersSetter sqlParametersSetter;
    final TableMapping<T> tableMapping;
    final SormOptions options;
    final LoggerConfig loggerConfig;

    MultiRowProcessor(LoggerConfig loggerConfig, SormOptions options, SqlParametersSetter sqlParametersSetter, TableMapping<T> tableMapping, int batchSize) {
        this.loggerConfig = loggerConfig;
        this.options = options;
        this.sqlParametersSetter = sqlParametersSetter;
        this.tableMapping = tableMapping;
        this.batchSize = batchSize;
    }

    public abstract int[] multiRowInsert(Connection var1, T ... var2);

    public abstract int[] multiRowMerge(Connection var1, T ... var2);

    final void setAutoCommit(Connection connection, boolean autoCommit) {
        Try.runOrThrow(() -> connection.setAutoCommit(autoCommit), Try::rethrow);
    }

    final void commitIfRequired(Connection connection, boolean origAutoCommit) {
        if (origAutoCommit) {
            Try.runOrThrow(() -> connection.commit(), Try::rethrow);
        }
    }

    final void rollbackIfRequired(Connection connection, boolean origAutoCommit) {
        if (!origAutoCommit) {
            Try.runOrThrow(() -> connection.rollback(), Try::rethrow);
        }
    }

    final boolean getAutoCommit(Connection connection) {
        return Try.createSupplierWithThrow(() -> connection.getAutoCommit(), Try::rethrow).get();
    }

    public final int[] batch(SormOptions options, Connection con, String sql, Function<T, Object[]> parameterCreator, T[] objects) {
        return this.execMultiRowProcIfValidObjects(con, objects, nonNullObjects -> {
            int[] result = new int[]{};
            boolean origAutoCommit = this.getAutoCommit(con);
            try {
                int[] nArray;
                block12: {
                    PreparedStatement stmt = con.prepareStatement(sql);
                    try {
                        this.setAutoCommit(con, false);
                        BatchHelper batchHelper = new BatchHelper(this.batchSize, stmt);
                        for (int i = 0; i < objects.length; ++i) {
                            Object obj = objects[i];
                            this.sqlParametersSetter.setParameters(options, stmt, (Object[])parameterCreator.apply(obj));
                            batchHelper.addBatchAndExecuteIfReachedThreshold();
                        }
                        nArray = result = batchHelper.finish();
                        if (stmt == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            this.rollbackIfRequired(con, origAutoCommit);
                            throw Try.rethrow(e);
                        }
                    }
                    stmt.close();
                }
                return nArray;
            }
            finally {
                this.commitIfRequired(con, origAutoCommit);
                this.setAutoCommit(con, origAutoCommit);
            }
        });
    }

    final int[] execMultiRowProcIfValidObjects(Connection con, T[] objects, Function<T[], int[]> exec) {
        if (objects == null || objects.length == 0) {
            return new int[0];
        }
        Optional<LogPoint> dp = this.loggerConfig.createLogPoint(LoggerConfig.Category.MULTI_ROW);
        int[] result = exec.apply(objects);
        dp.ifPresent(lp -> lp.debug(this.getClass(), "{} [{}] objects (req=[{}]) of [{}] are wrote into [{}]  at [{}]", lp.getTagAndElapsedTime(), IntStream.of(result).sum(), objects.length, this.tableMapping.getObjectClass(), this.tableMapping.getTableMetaData().getTableName(), Try.getOrNull(() -> con.getMetaData().getURL())));
        return result;
    }
}

