/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.sql.SelectStringBuilderImpl;

@Experimental
public interface SelectStringBuilder {
    public static Condition and(Object ... conds) {
        return new Condition("and", conds);
    }

    public static String as(String col, String alias) {
        return col + " as " + alias;
    }

    public static Condition cond(String cond) {
        return new Condition(cond);
    }

    public static Condition cond(String left, String op, String right) {
        return new Condition(left, op, right);
    }

    public static SelectStringBuilder create() {
        return new SelectStringBuilderImpl();
    }

    public static Condition or(Object ... conds) {
        return new Condition("or", conds);
    }

    public static OrderBy order(String column, String ascOrDesc) {
        return new OrderBy(column, ascOrDesc);
    }

    public String build();

    public SelectStringBuilder distinct();

    public SelectStringBuilder from(String var1);

    public SelectStringBuilder groupBy(String ... var1);

    public SelectStringBuilder having(Condition var1);

    public SelectStringBuilder having(String var1);

    public SelectStringBuilder limit(int var1);

    public SelectStringBuilder limit(int var1, int var2);

    public SelectStringBuilder orderBy(OrderBy ... var1);

    public SelectStringBuilder orderBy(String var1, String var2);

    public SelectStringBuilder select(String ... var1);

    public String toPrettyString();

    public String toPrettyString(boolean var1);

    public SelectStringBuilder where(Condition var1);

    public SelectStringBuilder where(String var1);

    public static class OrderBy {
        private final String column;
        private final String ascOrDesc;

        public OrderBy(String column, String ascOrDesc) {
            this.column = column;
            this.ascOrDesc = ascOrDesc;
        }

        public String toString() {
            return this.column + " " + this.ascOrDesc;
        }
    }

    public static class Condition {
        private final Object condition;

        public Condition(Object expr) {
            this.condition = expr;
        }

        public Condition(String op, Object ... conds) {
            this("(" + String.join((CharSequence)(" " + op + " "), Arrays.stream(conds).map(c -> c.toString()).collect(Collectors.toList())) + ")");
        }

        public Condition(String left, String op, String right) {
            this.condition = left + op + right;
        }

        public String toString() {
            return this.condition.toString();
        }
    }
}

