/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j;

import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.nkjmlab.sorm4j.ConsumerHandler;
import org.nkjmlab.sorm4j.FunctionHandler;
import org.nkjmlab.sorm4j.Orm;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmTransaction;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.extension.SormBuilder;
import org.nkjmlab.sorm4j.extension.SormConfig;
import org.nkjmlab.sorm4j.extension.SormConfigBuilder;
import org.nkjmlab.sorm4j.internal.mapping.DriverManagerDataSource;
import org.nkjmlab.sorm4j.internal.mapping.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.mapping.SormImpl;

public interface Sorm
extends Orm {
    public static final SormConfig DEFAULT_CONFIG = new SormConfigBuilder().build();

    public static Sorm create(DataSource dataSource) {
        return Sorm.create(dataSource, DEFAULT_CONFIG);
    }

    public static Sorm create(DataSource dataSource, SormConfig config) {
        return new SormImpl(dataSource, config);
    }

    public static Sorm create(String jdbcUrl, String user, String password) {
        return Sorm.create(jdbcUrl, user, password, DEFAULT_CONFIG);
    }

    public static Sorm create(String jdbcUrl, String user, String password, SormConfig config) {
        return Sorm.create(Sorm.createDriverManagerDataSource(jdbcUrl, user, password), config);
    }

    public static DataSource createDriverManagerDataSource(String jdbcUrl, String username, String password) {
        return new DriverManagerDataSource(jdbcUrl, username, password);
    }

    public static OrmConnection toOrmConnection(Connection connection) {
        return Sorm.toOrmConnection(connection, DEFAULT_CONFIG);
    }

    public static OrmConnection toOrmConnection(Connection connection, SormConfig sormConfig) {
        return new OrmConnectionImpl(connection, sormConfig);
    }

    public void accept(ConsumerHandler<OrmConnection> var1);

    @Experimental
    public void acceptWithLogging(ConsumerHandler<OrmConnection> var1);

    @Experimental
    public <R> R applyWithLogging(FunctionHandler<OrmConnection, R> var1);

    public void acceptJdbcConnectionHandler(ConsumerHandler<Connection> var1);

    public void acceptTransactionHandler(ConsumerHandler<OrmTransaction> var1);

    public <R> R apply(FunctionHandler<OrmConnection, R> var1);

    public <R> R applyJdbcConnectionHandler(FunctionHandler<Connection, R> var1);

    public <R> R applyTransactionHandler(FunctionHandler<OrmTransaction, R> var1);

    public SormConfig getConfig();

    public DataSource getDataSource();

    public Connection getJdbcConnection();

    public Map<String, String> getTableMappingStatusMap();

    public OrmConnection openConnection();

    public OrmTransaction openTransaction();

    public static SormBuilder newBuilder() {
        return new SormBuilder();
    }

    public static SormBuilder newBuilder(DataSource dataSource) {
        return new SormBuilder(dataSource);
    }
}

