/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.annotation.OrmColumn;
import org.nkjmlab.sorm4j.annotation.OrmGetter;
import org.nkjmlab.sorm4j.annotation.OrmIgnore;
import org.nkjmlab.sorm4j.annotation.OrmSetter;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.ColumnName;
import org.nkjmlab.sorm4j.extension.FieldName;
import org.nkjmlab.sorm4j.internal.extension.LoggerFactory;
import org.nkjmlab.sorm4j.internal.util.StringUtils;

public class DefaultColumnFieldMapper
implements ColumnFieldMapper {
    private static Map<FieldName, Method> extractedMethodStartWith(Class<?> objectClass, String prefix) {
        Class<OrmIgnore> ignoreAnn = OrmIgnore.class;
        return Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> Objects.isNull(m.getAnnotation(ignoreAnn)) && !Modifier.isStatic(m.getModifiers()) && m.getName().length() > prefix.length() && m.getName().substring(0, prefix.length()).equals(prefix)).collect(Collectors.toMap(m -> new FieldName(m.getName().substring(prefix.length(), prefix.length() + 1).toLowerCase() + m.getName().substring(prefix.length() + 1)), m -> m));
    }

    private static Map<FieldName, Field> getAllFields(Class<?> objectClass) {
        Class<OrmIgnore> ignoreAnn = OrmIgnore.class;
        return Arrays.stream(objectClass.getDeclaredFields()).filter(f -> Objects.isNull(f.getAnnotation(ignoreAnn)) && !Modifier.isStatic(f.getModifiers())).collect(Collectors.toMap(f -> new FieldName((Field)f), f -> {
            f.setAccessible(true);
            return f;
        }));
    }

    private static Map<FieldName, Method> getAllGetters(Class<?> objectClass) {
        Map<FieldName, Method> getters = DefaultColumnFieldMapper.extractedMethodStartWith(objectClass, "get");
        return getters;
    }

    private static Map<FieldName, Method> getAllSetters(Class<?> objectClass) {
        Map<FieldName, Method> setters = DefaultColumnFieldMapper.extractedMethodStartWith(objectClass, "set");
        return setters;
    }

    private static Map<ColumnName, Method> getAnnotatatedSettersMap(Class<?> objectClass) {
        Class<OrmSetter> ann = OrmSetter.class;
        Map<ColumnName, Method> annos = Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann))).collect(Collectors.toMap(m -> new ColumnName(((OrmSetter)m.getAnnotation(ann)).value()), m -> m));
        return annos;
    }

    private static Map<ColumnName, Field> getAnnotatedFieldsMap(Class<?> objectClass) {
        Class<OrmColumn> ann = OrmColumn.class;
        return Arrays.stream(objectClass.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ann))).collect(Collectors.toMap(f -> new ColumnName(((OrmColumn)f.getAnnotation(ann)).value()), f -> {
            f.setAccessible(true);
            return f;
        }));
    }

    private static Map<ColumnName, Method> getAnnotatedGettersMap(Class<?> objectClass) {
        Class<OrmGetter> ann = OrmGetter.class;
        Map<ColumnName, Method> annos = Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann))).collect(Collectors.toMap(m -> new ColumnName(((OrmGetter)m.getAnnotation(ann)).value()), m -> m));
        return annos;
    }

    private static Method isValidGetter(Method getter) {
        if (getter == null) {
            return null;
        }
        if (getter.getParameterCount() != 0) {
            LoggerFactory.getLogger().warn("Getter [{}] should not have parameter but has {} params.", getter, getter.getParameterCount());
            return null;
        }
        if (getter.getReturnType() == Void.TYPE) {
            LoggerFactory.getLogger().warn("Getter [{}] must have return a parameter.", getter);
        }
        return getter;
    }

    private static Method isValidSetter(Method setter) {
        if (setter == null) {
            return null;
        }
        if (setter.getParameterCount() != 1) {
            LoggerFactory.getLogger().warn("Setter [{}] should have a single parameter but has {} params.", setter, setter.getParameterCount());
            return null;
        }
        return setter;
    }

    @Override
    public Map<String, Accessor> createAccessors(Class<?> objectClass) {
        HashSet<FieldName> names = new HashSet<FieldName>();
        names.addAll(DefaultColumnFieldMapper.getAllFields(objectClass).keySet());
        names.addAll(DefaultColumnFieldMapper.getAllGetters(objectClass).keySet());
        names.addAll(DefaultColumnFieldMapper.getAllSetters(objectClass).keySet());
        List<ColumnName> columnNames = new ArrayList(names).stream().flatMap(fieldName -> this.guessColumnNameCandidates((FieldName)fieldName).stream()).collect(Collectors.toList());
        columnNames.addAll(DefaultColumnFieldMapper.getAnnotatedFieldsMap(objectClass).keySet());
        columnNames.addAll(DefaultColumnFieldMapper.getAnnotatedGettersMap(objectClass).keySet());
        columnNames.addAll(DefaultColumnFieldMapper.getAnnotatatedSettersMap(objectClass).keySet());
        return this.createAccessors(objectClass, columnNames);
    }

    @Override
    public Map<String, Accessor> createAccessors(Class<?> objectClass, List<ColumnName> columnNames) {
        Map<FieldName, Field> fields = DefaultColumnFieldMapper.getAllFields(objectClass);
        Map<FieldName, Method> getters = DefaultColumnFieldMapper.getAllGetters(objectClass);
        Map<FieldName, Method> setters = DefaultColumnFieldMapper.getAllSetters(objectClass);
        Map<ColumnName, Field> annotatedFields = DefaultColumnFieldMapper.getAnnotatedFieldsMap(objectClass);
        Map<ColumnName, Method> annotatedGetters = DefaultColumnFieldMapper.getAnnotatedGettersMap(objectClass);
        Map<ColumnName, Method> annotatedSetters = DefaultColumnFieldMapper.getAnnotatatedSettersMap(objectClass);
        ArrayList<FieldName> fieldsList = new ArrayList<FieldName>(fields.keySet());
        HashMap<String, Accessor> ret = new HashMap<String, Accessor>();
        for (ColumnName columnName : columnNames) {
            Field f = annotatedFields.get(columnName);
            Method g = DefaultColumnFieldMapper.isValidGetter(annotatedGetters.get(columnName));
            Method s = DefaultColumnFieldMapper.isValidSetter(annotatedSetters.get(columnName));
            Optional<FieldName> op = fieldsList.stream().filter(fieldName -> this.isMatch(columnName, (FieldName)fieldName)).findFirst();
            if (op.isPresent()) {
                FieldName fieldName2 = op.get();
                f = f != null ? f : fields.get(fieldName2);
                g = g != null ? g : DefaultColumnFieldMapper.isValidGetter(getters.get(fieldName2));
                Method method = s = s != null ? g : DefaultColumnFieldMapper.isValidSetter(setters.get(fieldName2));
            }
            if (f == null && (g == null || s == null)) {
                LoggerFactory.getLogger().debug("Skip matching with ColumnName [{}] to field because could not found corresponding field.", columnName);
                continue;
            }
            ret.put(StringUtils.toCanonical(columnName.getName()), new Accessor(columnName, f, g, s));
        }
        return ret;
    }

    protected boolean isMatch(ColumnName columnName, FieldName fieldName) {
        List<String> candidates = this.guessColumnNameCandidates(fieldName).stream().map(ColumnName::getName).collect(Collectors.toList());
        return StringUtils.containsAsCanonical(candidates, columnName.getName());
    }

    @Override
    public List<ColumnName> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<ColumnName> columnsList = new ArrayList<ColumnName>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                String isAutoIncrement = resultSet.getString(23);
                if (!isAutoIncrement.equals("YES")) continue;
                columnsList.add(new ColumnName(columnName));
            }
            ArrayList<ColumnName> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<ColumnName> getColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<ColumnName> columnsList = new ArrayList<ColumnName>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                int dataType = resultSet.getInt(5);
                String typeName = resultSet.getString(6);
                int ordinalPosition = resultSet.getInt(17);
                String isNullable = resultSet.getString(18);
                String isAutoIncremented = resultSet.getString(23);
                String isGenerated = resultSet.getString(24);
                final class ColumnNameWithMetaData
                extends ColumnName {
                    private final String msg;

                    public ColumnNameWithMetaData(String name, int dataType, String typeName, int ordinalPosition, String isNullable, String isAutoIncremented, String isGenerated) {
                        super(name);
                        this.msg = StringUtils.format("{}. {} [{}({})] [{},{},{}]", String.format("%02d", ordinalPosition), name, typeName, dataType, isNullable, isAutoIncremented, isGenerated);
                    }

                    @Override
                    public String toString() {
                        return this.msg;
                    }
                }
                columnsList.add(new ColumnNameWithMetaData(columnName, dataType, typeName, ordinalPosition, isNullable, isAutoIncremented, isGenerated));
            }
            ArrayList<ColumnName> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<ColumnName> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException {
        ArrayList<ColumnName> primaryKeysList = new ArrayList<ColumnName>();
        try (ResultSet resultSet = metaData.getPrimaryKeys(null, this.getSchemaPattern(metaData), tableName);){
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                primaryKeysList.add(new ColumnName(columnName));
            }
            ArrayList<ColumnName> arrayList = primaryKeysList;
            return arrayList;
        }
    }

    protected String getSchemaPattern(DatabaseMetaData metaData) throws SQLException {
        return "Oracle".equalsIgnoreCase(metaData.getDatabaseProductName()) ? "%" : null;
    }

    protected List<ColumnName> guessColumnNameCandidates(FieldName fieldName) {
        String _fieldName = fieldName.getName();
        return Stream.of(StringUtils.toCanonical(_fieldName)).map(ColumnName::new).collect(Collectors.toList());
    }
}

