/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.IntStream;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.extension.LoggerFactory;
import org.nkjmlab.sorm4j.internal.extension.SormLogger;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;

public final class LoggerConfig {
    private final Set<Category> onCategories = ConcurrentHashMap.newKeySet();
    @Experimental
    private static List<Category> defaultLoggingCategories = new CopyOnWriteArrayList<Category>(List.of(Category.MAPPING));
    @Experimental
    public volatile boolean forceLogging = false;

    public LoggerConfig() {
        defaultLoggingCategories.forEach(c -> this.on((Category)((Object)c)));
    }

    public void on(Category ... categories) {
        Arrays.stream(categories).forEach(name -> this.onCategories.add((Category)((Object)name)));
    }

    public void off(Category ... categories) {
        Arrays.stream(categories).forEach(name -> this.onCategories.remove(name));
    }

    public void onAll() {
        this.on(Category.values());
    }

    public void offAll() {
        this.off(Category.values());
    }

    @Experimental
    public Optional<LogPoint> createLogPoint(Category category, Class<?> clazz) {
        return this.isLogging(category) ? Optional.of(new LogPoint(category.name(), clazz)) : Optional.empty();
    }

    private boolean isLogging(Category category) {
        return this.forceLogging || this.onCategories.contains((Object)category);
    }

    @Experimental
    public static final class LogPoint {
        private final String name;
        private long startTime;
        public final SormLogger logger;

        private LogPoint(String name, Class<?> clazz) {
            this.name = name;
            this.logger = LoggerFactory.getLogger(clazz);
        }

        public String getTagAndElapsedTime() {
            return "[" + this.getTag() + "] [" + String.format("%.3f", (double)(System.nanoTime() - this.startTime) / 1000.0 / 1000.0) + " msec] :";
        }

        public String getTag() {
            return this.name + ":" + this.hashCode() / 10000;
        }

        private String getDbUrl(Connection connection) {
            return Try.getOrDefault(() -> connection.getMetaData().getURL(), "");
        }

        public String createBeforeSqlMessage(Connection connection, String sql, Object[] parameters) {
            String ret = this.createBeforeSqlMessage(connection, ParameterizedSql.parse(sql, parameters));
            return ret;
        }

        public String createBeforeSqlMessage(Connection connection, ParameterizedSql psql) {
            String ret = StringUtils.format("[{}] Execute SQL [{}] to [{}]", this.getTag(), psql.getBindedSql(), this.getDbUrl(connection));
            this.startTime = System.nanoTime();
            return ret;
        }

        public String createBeforeMultiRowMessage(Connection connection, Class<?> clazz, int length, String tableName) {
            String ret = StringUtils.format("[{}] Execute multirow insert with [{}] objects of [{}] into [{}] on [{}]", this.getTag(), length, clazz, tableName, this.getDbUrl(connection));
            this.startTime = System.nanoTime();
            return ret;
        }

        public String createAfterUpdateMessage(int ret) {
            return StringUtils.format("{} Affect [{}] rows", this.getTagAndElapsedTime(), ret);
        }

        public String createAfterQueryMessage(Object ret) {
            return StringUtils.format("{} Read [{}] objects", this.getTagAndElapsedTime(), ret instanceof Collection ? ((Collection)ret).size() : 1);
        }

        public String createAfterMultiRowMessage(int[] result) {
            return StringUtils.format("{} Affect [{}] objects", this.getTagAndElapsedTime(), IntStream.of(result).sum());
        }
    }

    public static enum Category {
        MAPPING,
        EXECUTE_QUERY,
        MULTI_ROW,
        EXECUTE_UPDATE,
        HANDLE_PREPAREDSTATEMENT;

    }
}

