/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.annotation.OrmColumnAliasPrefix;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.ColumnName;
import org.nkjmlab.sorm4j.extension.LoggerConfig;
import org.nkjmlab.sorm4j.extension.MultiRowProcessorType;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.TableName;
import org.nkjmlab.sorm4j.extension.TableNameMapper;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.internal.mapping.ColumnsMapping;
import org.nkjmlab.sorm4j.internal.mapping.SormOptionsImpl;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;
import org.nkjmlab.sorm4j.internal.mapping.TableMetaDataImpl;
import org.nkjmlab.sorm4j.internal.mapping.TableSql;
import org.nkjmlab.sorm4j.internal.mapping.TableSqlFactory;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;

@Experimental
public final class SormConfig {
    private static final TableSqlFactory tableSqlFactory = new TableSqlFactory();
    private final TableNameMapper tableNameMapper;
    private final ColumnFieldMapper columnFieldMapper;
    private final MultiRowProcessorFactory multiRowProcessorFactory;
    private final ResultSetConverter resultSetConverter;
    private final SqlParametersSetter sqlParametersSetter;
    private final SormOptions options;
    private final ConcurrentMap<String, TableMapping<?>> tableMappings;
    private final ConcurrentMap<Class<?>, ColumnsMapping<?>> columnsMappings;
    private final ConcurrentMap<Class<?>, TableName> classNameToValidTableNameMap;
    private final ConcurrentMap<String, TableName> tableNameToValidTableNameMap;
    private final int transactionIsolationLevel;
    private final LoggerConfig loggerConfig;

    public SormConfig(LoggerConfig loggerConfig, Map<String, Object> options, ColumnFieldMapper columnFieldMapper, TableNameMapper tableNameMapper, ResultSetConverter resultSetConverter, SqlParametersSetter sqlParametersSetter, MultiRowProcessorType multiRowProcessorType, int batchSize, int multiRowSize, int batchSizeWithMultiRow, int transactionIsolationLevel) {
        this.loggerConfig = loggerConfig;
        this.options = new SormOptionsImpl(options);
        this.transactionIsolationLevel = transactionIsolationLevel;
        this.tableNameMapper = tableNameMapper;
        this.columnFieldMapper = columnFieldMapper;
        this.multiRowProcessorFactory = MultiRowProcessorFactory.createMultiRowProcessorFactory(loggerConfig, this.options, sqlParametersSetter, multiRowProcessorType, batchSize, multiRowSize, batchSizeWithMultiRow);
        this.resultSetConverter = resultSetConverter;
        this.sqlParametersSetter = sqlParametersSetter;
        this.tableMappings = new ConcurrentHashMap();
        this.columnsMappings = new ConcurrentHashMap();
        this.classNameToValidTableNameMap = new ConcurrentHashMap();
        this.tableNameToValidTableNameMap = new ConcurrentHashMap<String, TableName>();
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public Map<String, String> getTableMappingStatusMap() {
        return this.tableMappings.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((TableMapping)e.getValue()).getFormattedString()));
    }

    public <T> TableMapping<T> getTableMapping(Connection connection, Class<T> objectClass) {
        TableName tableName = this.toTableName(connection, objectClass);
        return this.getTableMapping(connection, tableName, objectClass);
    }

    public <T> TableMapping<T> getTableMapping(Connection connection, String tableName, Class<T> objectClass) {
        return this.getTableMapping(connection, this.toTableName(connection, tableName), objectClass);
    }

    <T> TableMapping<T> getTableMapping(Connection connection, TableName tableName, Class<T> objectClass) {
        String key = tableName.getName() + "-" + objectClass.getName();
        TableMapping ret = this.tableMappings.computeIfAbsent(key, Try.createFunctionWithThrow(_key -> {
            TableMapping m = this.createTableMapping(objectClass, tableName.getName(), connection);
            this.loggerConfig.createLogPoint(LoggerConfig.Category.MAPPING, SormConfig.class).ifPresent(lp -> lp.logger.info("[{}]" + System.lineSeparator() + "{}", lp.getTag(), m.getFormattedString()));
            return m;
        }, Try::rethrow));
        return ret;
    }

    public <T> ColumnsMapping<T> createColumnsMapping(Class<T> objectClass) {
        ColumnToAccessorMap columnToAccessorMap = new ColumnToAccessorMap(objectClass, this.columnFieldMapper.createAccessors(objectClass));
        return new ColumnsMapping<T>(this.options, this.resultSetConverter, objectClass, columnToAccessorMap);
    }

    public <T> TableMapping<T> createTableMapping(Class<T> objectClass, String tableName, Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        List<ColumnName> allColumns = this.columnFieldMapper.getColumns(metaData, tableName);
        List<String> primaryKeys = this.columnFieldMapper.getPrimaryKeys(metaData, tableName).stream().map(c -> c.getName()).collect(Collectors.toList());
        List<String> autoGeneratedColumns = this.columnFieldMapper.getAutoGeneratedColumns(metaData, tableName).stream().map(c -> c.getName()).collect(Collectors.toList());
        List<String> columns = allColumns.stream().map(c -> c.getName()).collect(Collectors.toList());
        String colmunAliasPrefix = Optional.ofNullable(objectClass.getAnnotation(OrmColumnAliasPrefix.class)).map(a -> a.value()).orElse("");
        TableMetaDataImpl tableMetaData = new TableMetaDataImpl(tableName, colmunAliasPrefix, columns, primaryKeys, autoGeneratedColumns);
        TableSql sql = tableSqlFactory.create(tableMetaData);
        Map<String, Accessor> accessors = this.columnFieldMapper.createAccessors(objectClass, allColumns);
        Set<String> keySetWithoutAlias = accessors.keySet();
        if (!StringUtils.equalsAsCanonical(columns, keySetWithoutAlias)) {
            throw new SormException(StringUtils.format("{} does not match any field. Table [{}] contains Columns {} but [{}] contains Fields {}.", columns.stream().filter(e -> !keySetWithoutAlias.contains(StringUtils.toCanonical(e))).sorted().collect(Collectors.toList()), tableName, allColumns.stream().map(c -> c.toString()).sorted().collect(Collectors.toList()), objectClass.getName(), keySetWithoutAlias.stream().sorted().collect(Collectors.toList())));
        }
        ColumnToAccessorMap columnToAccessorMap = new ColumnToAccessorMap(objectClass, accessors);
        return new TableMapping<T>(this.loggerConfig, this.options, this.resultSetConverter, this.sqlParametersSetter, this.multiRowProcessorFactory, objectClass, columnToAccessorMap, tableMetaData, sql);
    }

    public <T> TableMapping<T> getCastedTableMapping(Connection connection, Class<?> objectClass) {
        return this.getTableMapping(connection, objectClass);
    }

    public <T> TableMapping<T> getCastedTableMapping(Connection connection, String tableName, Class<?> objectClass) {
        return this.getTableMapping(connection, tableName, objectClass);
    }

    public <T> ColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        ColumnsMapping ret = this.columnsMappings.computeIfAbsent(objectClass, _k -> {
            ColumnsMapping m = this.createColumnsMapping(objectClass);
            this.loggerConfig.createLogPoint(LoggerConfig.Category.MAPPING, SormConfig.class).ifPresent(lp -> lp.logger.info(System.lineSeparator() + m.getFormattedString(), new Object[0]));
            return m;
        });
        return ret;
    }

    private TableName toTableName(Connection connection, Class<?> objectClass) {
        return this.classNameToValidTableNameMap.computeIfAbsent(objectClass, Try.createFunctionWithThrow(k -> this.tableNameMapper.getTableName(objectClass, connection.getMetaData()), Try::rethrow));
    }

    public String getTableName(Connection connection, Class<?> objectClass) {
        return this.toTableName(connection, objectClass).getName();
    }

    private TableName toTableName(Connection connection, String tableName) {
        return this.tableNameToValidTableNameMap.computeIfAbsent(tableName, Try.createFunctionWithThrow(k -> this.tableNameMapper.getTableName(tableName, connection.getMetaData()), Try::rethrow));
    }

    public ResultSetConverter getResultSetConverter() {
        return this.resultSetConverter;
    }

    public SqlParametersSetter getSqlParametersSetter() {
        return this.sqlParametersSetter;
    }

    public SormOptions getOptions() {
        return this.options;
    }

    public LoggerConfig getLoggerConfig() {
        return this.loggerConfig;
    }

    public String toString() {
        return "SormConfig [tableNameMapper=" + this.tableNameMapper + ", columnFieldMapper=" + this.columnFieldMapper + ", multiRowProcessorFactory=" + this.multiRowProcessorFactory + ", resultSetConverter=" + this.resultSetConverter + ", sqlParametersSetter=" + this.sqlParametersSetter + ", tableMappings=" + this.tableMappings + ", columnsMappings=" + this.columnsMappings + ", classNameToValidTableNameMap=" + this.classNameToValidTableNameMap + ", tableNameToValidTableNameMap=" + this.tableNameToValidTableNameMap + ", options=" + this.options + ", transactionIsolationLevel=" + this.transactionIsolationLevel + "]";
    }
}

