/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.List;

public final class SqlUtils {
    private SqlUtils() {
    }

    public static String quote(String str) {
        return SqlUtils.wrapSingleQuote(SqlUtils.escapeSingleQuote(str));
    }

    private static String escapeSingleQuote(String str) {
        return str.contains("'") ? str.replaceAll("'", "''") : str;
    }

    private static String wrapSingleQuote(String str) {
        return "'" + str + "'";
    }

    public static String literal(Object element) {
        if (element == null) {
            return "null";
        }
        if (element.getClass().isArray()) {
            return "[" + String.join((CharSequence)", ", (CharSequence[])((List)element).stream().map(e -> SqlUtils.literal(e)).toArray(String[]::new)) + "]";
        }
        if (element instanceof List) {
            return String.join((CharSequence)", ", (CharSequence[])((List)element).stream().map(e -> SqlUtils.literal(e)).toArray(String[]::new));
        }
        String str = element.toString();
        if (element instanceof Number || element instanceof Boolean) {
            return str;
        }
        switch (str) {
            case "?": {
                return str;
            }
        }
        return SqlUtils.quote(str);
    }
}

