/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j;

import java.sql.Connection;
import java.util.Map;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.nkjmlab.sorm4j.ConsumerHandler;
import org.nkjmlab.sorm4j.FunctionHandler;
import org.nkjmlab.sorm4j.Orm;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmTransaction;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.MultiRowProcessorType;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormConfig;
import org.nkjmlab.sorm4j.extension.SormContext;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.TableNameMapper;
import org.nkjmlab.sorm4j.extension.logger.LoggerContext;
import org.nkjmlab.sorm4j.extension.logger.SormLogger;
import org.nkjmlab.sorm4j.internal.mapping.DriverManagerDataSource;
import org.nkjmlab.sorm4j.internal.mapping.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.mapping.SormImpl;

public interface Sorm
extends Orm {
    public static final SormContext DEFAULT_CONTEXT = new SormContext(SormConfig.newBuilder().build());

    public static Sorm create(DataSource dataSource) {
        return Sorm.create(dataSource, DEFAULT_CONTEXT);
    }

    public static Sorm create(DataSource dataSource, SormContext context) {
        return new SormImpl(dataSource, context);
    }

    public static Sorm create(String jdbcUrl, String user, String password) {
        return Sorm.create(Sorm.createDriverManagerDataSource(jdbcUrl, user, password));
    }

    public static Sorm create(String jdbcUrl, String user, String password, SormContext context) {
        return Sorm.create(Sorm.createDriverManagerDataSource(jdbcUrl, user, password), context);
    }

    public static DataSource createDriverManagerDataSource(String jdbcUrl, String username, String password) {
        return new DriverManagerDataSource(jdbcUrl, username, password);
    }

    public static OrmConnection toOrmConnection(Connection connection) {
        return Sorm.toOrmConnection(connection, DEFAULT_CONTEXT);
    }

    public static OrmConnection toOrmConnection(Connection connection, SormContext sormContext) {
        return new OrmConnectionImpl(connection, sormContext);
    }

    public void accept(ConsumerHandler<OrmConnection> var1);

    @Experimental
    public void acceptWithLogging(ConsumerHandler<OrmConnection> var1);

    @Experimental
    public <R> R applyWithLogging(FunctionHandler<OrmConnection, R> var1);

    public void acceptJdbcConnectionHandler(ConsumerHandler<Connection> var1);

    public void acceptTransactionHandler(ConsumerHandler<OrmTransaction> var1);

    public <R> R apply(FunctionHandler<OrmConnection, R> var1);

    public <R> R applyJdbcConnectionHandler(FunctionHandler<Connection, R> var1);

    public <R> R applyTransactionHandler(FunctionHandler<OrmTransaction, R> var1);

    public SormContext getContext();

    public DataSource getDataSource();

    public Connection getJdbcConnection();

    public Map<String, String> getTableMappingStatusMap();

    public OrmConnection openConnection();

    public OrmTransaction openTransaction();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(DataSource dataSource) {
        return new Builder(dataSource);
    }

    public static Builder newBuilder(String jdbcUrl, String user, String password) {
        return new Builder(Sorm.createDriverManagerDataSource(jdbcUrl, user, password));
    }

    @Experimental
    public static class Builder {
        private DataSource dataSource;
        private SormConfig.Builder configBuilder = SormConfig.newBuilder();

        public Builder() {
        }

        public Builder(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Sorm build() {
            return new SormImpl(this.dataSource, new SormContext(this.configBuilder.build()));
        }

        public Builder setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder setDataSource(String jdbcUrl, String username, String password) {
            this.dataSource = Sorm.createDriverManagerDataSource(jdbcUrl, username, password);
            return this;
        }

        public Builder setColumnFieldMapper(ColumnFieldMapper fieldNameMapper) {
            this.configBuilder.setColumnFieldMapper(fieldNameMapper);
            return this;
        }

        public Builder setTableNameMapper(TableNameMapper tableNameMapper) {
            this.configBuilder.setTableNameMapper(tableNameMapper);
            return this;
        }

        public Builder setResultSetConverter(ResultSetConverter resultSetConverter) {
            this.configBuilder.setResultSetConverter(resultSetConverter);
            return this;
        }

        public Builder setSqlParametersSetter(SqlParametersSetter sqlParametersSetter) {
            this.configBuilder.setSqlParametersSetter(sqlParametersSetter);
            return this;
        }

        public Builder setMultiRowProcessorType(MultiRowProcessorType multiRowProcessorType) {
            this.configBuilder.setMultiRowProcessorType(multiRowProcessorType);
            return this;
        }

        public Builder setBatchSize(int size) {
            this.configBuilder.setBatchSize(size);
            return this;
        }

        public Builder setMultiRowSize(int size) {
            this.configBuilder.setMultiRowSize(size);
            return this;
        }

        public Builder setBatchSizeWithMultiRow(int size) {
            this.configBuilder.setBatchSizeWithMultiRow(size);
            return this;
        }

        public Builder setTransactionIsolationLevel(int level) {
            this.configBuilder.setTransactionIsolationLevel(level);
            return this;
        }

        public Builder setOption(String name, Object value) {
            this.configBuilder.setOption(name, value);
            return this;
        }

        public Builder setLoggerOnAll() {
            this.configBuilder.setLoggerOnAll();
            return this;
        }

        public Builder setLoggerOffAll() {
            this.configBuilder.setLoggerOffAll();
            return this;
        }

        public Builder setLoggerOn(LoggerContext.Category ... categories) {
            this.configBuilder.setLoggerOn(categories);
            return this;
        }

        public Builder setLoggerOff(LoggerContext.Category ... categories) {
            this.configBuilder.setLoggerOff(categories);
            return this;
        }

        public Builder setLoggerSupplier(Supplier<SormLogger> loggerSupplier) {
            this.configBuilder.setLoggerSupplier(loggerSupplier);
            return this;
        }
    }
}

