/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.OrmTable;
import org.nkjmlab.sorm4j.extension.TableName;
import org.nkjmlab.sorm4j.extension.TableNameMapper;
import org.nkjmlab.sorm4j.internal.util.StringUtils;

public class DefaultTableNameMapper
implements TableNameMapper {
    @Override
    public TableName getTableName(String tableName, DatabaseMetaData metaData) throws SQLException {
        List<String> candidates = List.of(tableName);
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(StringUtils.format("[{}] does not match any existing table in the database. Table Name candidates are {}", tableName, candidates)));
    }

    @Override
    public TableName getTableName(Class<?> objectClass, DatabaseMetaData metaData) throws SQLException {
        List<String> candidates = this.guessTableNameCandidates(objectClass);
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(StringUtils.format("[{}] does not match any existing table in the database. Use [{}] annotation correctly. Table Name candidates are {}", objectClass.getName(), OrmTable.class.getName(), candidates)));
    }

    protected List<String> guessTableNameCandidates(Class<?> objectClass) {
        List<String> annotatedTableName = Optional.ofNullable(objectClass.getAnnotation(OrmTable.class)).map(a -> List.of(a.value())).orElse(Collections.emptyList());
        if (annotatedTableName.size() != 0) {
            return annotatedTableName;
        }
        String className = objectClass.getSimpleName();
        return StringUtils.addPluralSuffix(List.of(StringUtils.toCanonical(className)));
    }

    protected Optional<TableName> convertToExactTableName(DatabaseMetaData metaData, List<String> tableNameCandidates) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet resultSet = metaData.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});){
            while (resultSet.next()) {
                String tableNameOnDb = resultSet.getString(3);
                if (!this.isMatch(tableNameCandidates, tableNameOnDb)) continue;
                return Optional.of(new TableName(tableNameOnDb));
            }
            return Optional.empty();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected boolean isMatch(List<String> candidates, String exactTableName) {
        return StringUtils.containsAsCanonical(candidates, exactTableName);
    }
}

