/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.DefaultColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.DefaultResultSetConverter;
import org.nkjmlab.sorm4j.extension.DefaultSqlParametersSetter;
import org.nkjmlab.sorm4j.extension.DefaultTableNameMapper;
import org.nkjmlab.sorm4j.extension.MultiRowProcessorType;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.TableNameMapper;
import org.nkjmlab.sorm4j.extension.logger.LoggerContext;
import org.nkjmlab.sorm4j.extension.logger.SormLogger;
import org.nkjmlab.sorm4j.internal.mapping.SormOptionsImpl;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessorFactory;

@Experimental
public final class SormConfig {
    private final TableNameMapper tableNameMapper;
    private final ColumnFieldMapper columnFieldMapper;
    private final MultiRowProcessorFactory multiRowProcessorFactory;
    private final ResultSetConverter resultSetConverter;
    private final SqlParametersSetter sqlParametersSetter;
    private final SormOptions options;
    private final int transactionIsolationLevel;
    private final LoggerContext loggerContext;

    public SormConfig(LoggerContext loggerContext, Map<String, Object> options, ColumnFieldMapper columnFieldMapper, TableNameMapper tableNameMapper, ResultSetConverter resultSetConverter, SqlParametersSetter sqlParametersSetter, MultiRowProcessorType multiRowProcessorType, int batchSize, int multiRowSize, int batchSizeWithMultiRow, int transactionIsolationLevel) {
        this.loggerContext = loggerContext;
        this.options = new SormOptionsImpl(options);
        this.transactionIsolationLevel = transactionIsolationLevel;
        this.tableNameMapper = tableNameMapper;
        this.columnFieldMapper = columnFieldMapper;
        this.multiRowProcessorFactory = MultiRowProcessorFactory.createMultiRowProcessorFactory(loggerContext, this.options, sqlParametersSetter, multiRowProcessorType, batchSize, multiRowSize, batchSizeWithMultiRow);
        this.resultSetConverter = resultSetConverter;
        this.sqlParametersSetter = sqlParametersSetter;
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public ResultSetConverter getResultSetConverter() {
        return this.resultSetConverter;
    }

    public SqlParametersSetter getSqlParametersSetter() {
        return this.sqlParametersSetter;
    }

    public SormOptions getOptions() {
        return this.options;
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    public String toString() {
        return "SormConfig [tableNameMapper=" + this.tableNameMapper + ", columnFieldMapper=" + this.columnFieldMapper + ", multiRowProcessorFactory=" + this.multiRowProcessorFactory + ", resultSetConverter=" + this.resultSetConverter + ", sqlParametersSetter=" + this.sqlParametersSetter + ", options=" + this.options + ", transactionIsolationLevel=" + this.transactionIsolationLevel + ", loggerContext=" + this.loggerContext + "]";
    }

    public ColumnFieldMapper getColumnFieldMapper() {
        return this.columnFieldMapper;
    }

    public TableNameMapper getTableNameMapper() {
        return this.tableNameMapper;
    }

    public MultiRowProcessorFactory getMultiRowProcessorFactory() {
        return this.multiRowProcessorFactory;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Experimental
    public static class Builder {
        public static final MultiRowProcessorType DEFAULT_MULTI_ROW_PROCESSOR = MultiRowProcessorType.MULTI_ROW;
        public static final SqlParametersSetter DEFAULT_SQL_PARAMETER_SETTER = new DefaultSqlParametersSetter();
        public static final ResultSetConverter DEFAULT_RESULT_SET_CONVERTER = new DefaultResultSetConverter();
        public static final TableNameMapper DEFAULT_TABLE_NAME_MAPPER = new DefaultTableNameMapper();
        public static final int DEFAULT_TRANSACTION_ISOLATION_LEVEL = 2;
        public static final String DEFAULT_CACHE_NAME = "DEFAULT_CACHE";
        private TableNameMapper tableNameMapper = DEFAULT_TABLE_NAME_MAPPER;
        private ResultSetConverter resultSetConverter = DEFAULT_RESULT_SET_CONVERTER;
        private SqlParametersSetter sqlParametersSetter = DEFAULT_SQL_PARAMETER_SETTER;
        private MultiRowProcessorType multiRowProcessorType = DEFAULT_MULTI_ROW_PROCESSOR;
        private ColumnFieldMapper columnFieldMapper;
        private int batchSize = 32;
        private int multiRowSize = 32;
        private int batchSizeWithMultiRow = 5;
        private int transactionIsolationLevel = 2;
        private Map<String, Object> options = new HashMap<String, Object>();
        private LoggerContext.Builder loggerConfigBuilder = LoggerContext.newBuilder();

        public SormConfig build() {
            LoggerContext loggerContext = this.loggerConfigBuilder.build();
            this.columnFieldMapper = this.columnFieldMapper != null ? this.columnFieldMapper : new DefaultColumnFieldMapper(loggerContext);
            return new SormConfig(loggerContext, this.options, this.columnFieldMapper, this.tableNameMapper, this.resultSetConverter, this.sqlParametersSetter, this.multiRowProcessorType, this.batchSize, this.multiRowSize, this.batchSizeWithMultiRow, this.transactionIsolationLevel);
        }

        public Builder setColumnFieldMapper(ColumnFieldMapper fieldNameMapper) {
            this.columnFieldMapper = fieldNameMapper;
            return this;
        }

        public Builder setTableNameMapper(TableNameMapper tableNameMapper) {
            this.tableNameMapper = tableNameMapper;
            return this;
        }

        public Builder setResultSetConverter(ResultSetConverter resultSetConverter) {
            this.resultSetConverter = resultSetConverter;
            return this;
        }

        public Builder setSqlParametersSetter(SqlParametersSetter sqlParametersSetter) {
            this.sqlParametersSetter = sqlParametersSetter;
            return this;
        }

        public Builder setMultiRowProcessorType(MultiRowProcessorType multiRowProcessorType) {
            this.multiRowProcessorType = multiRowProcessorType;
            return this;
        }

        public Builder setBatchSize(int size) {
            this.batchSize = size;
            return this;
        }

        public Builder setMultiRowSize(int size) {
            this.multiRowSize = size;
            return this;
        }

        public Builder setBatchSizeWithMultiRow(int size) {
            this.batchSizeWithMultiRow = size;
            return this;
        }

        public Builder setTransactionIsolationLevel(int level) {
            this.transactionIsolationLevel = level;
            return this;
        }

        public Builder setOption(String name, Object value) {
            this.options.put(name, value);
            return this;
        }

        public Builder setLoggerOnAll() {
            this.loggerConfigBuilder.onAll();
            return this;
        }

        public Builder setLoggerOffAll() {
            this.loggerConfigBuilder.offAll();
            return this;
        }

        public Builder setLoggerOn(LoggerContext.Category ... categories) {
            this.loggerConfigBuilder.on(categories);
            return this;
        }

        public Builder setLoggerOff(LoggerContext.Category ... categories) {
            this.loggerConfigBuilder.off(categories);
            return this;
        }

        public Builder setLoggerSupplier(Supplier<SormLogger> loggerSupplier) {
            this.loggerConfigBuilder.setLoggerSupplier(loggerSupplier);
            return this;
        }
    }
}

