/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.annotation.OrmColumnAliasPrefix;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.ColumnName;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormConfig;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.TableName;
import org.nkjmlab.sorm4j.extension.logger.LoggerContext;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.internal.mapping.ColumnsMapping;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;
import org.nkjmlab.sorm4j.internal.mapping.TableMetaDataImpl;
import org.nkjmlab.sorm4j.internal.mapping.TableSql;
import org.nkjmlab.sorm4j.internal.mapping.TableSqlFactory;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;

@Experimental
public final class SormContext {
    private static final TableSqlFactory tableSqlFactory = new TableSqlFactory();
    private final ConcurrentMap<String, TableMapping<?>> tableMappings;
    private final ConcurrentMap<Class<?>, ColumnsMapping<?>> columnsMappings;
    private final ConcurrentMap<Class<?>, TableName> classNameToValidTableNameMap;
    private final ConcurrentMap<String, TableName> tableNameToValidTableNameMap;
    private final SormConfig sormConfig;

    public SormContext(SormConfig sormConfig) {
        this.sormConfig = sormConfig;
        this.tableMappings = new ConcurrentHashMap();
        this.columnsMappings = new ConcurrentHashMap();
        this.classNameToValidTableNameMap = new ConcurrentHashMap();
        this.tableNameToValidTableNameMap = new ConcurrentHashMap<String, TableName>();
    }

    public Map<String, String> getTableMappingStatusMap() {
        return this.tableMappings.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((TableMapping)e.getValue()).getFormattedString()));
    }

    public <T> TableMapping<T> getTableMapping(Connection connection, Class<T> objectClass) {
        TableName tableName = this.toTableName(connection, objectClass);
        return this.getTableMapping(connection, tableName, objectClass);
    }

    public <T> TableMapping<T> getTableMapping(Connection connection, String tableName, Class<T> objectClass) {
        return this.getTableMapping(connection, this.toTableName(connection, tableName), objectClass);
    }

    <T> TableMapping<T> getTableMapping(Connection connection, TableName tableName, Class<T> objectClass) {
        String key = String.valueOf(tableName.getName()) + "-" + objectClass.getName();
        TableMapping ret = this.tableMappings.computeIfAbsent(key, Try.createFunctionWithThrow(_key -> {
            TableMapping m = this.createTableMapping(objectClass, tableName.getName(), connection);
            this.sormConfig.getLoggerContext().createLogPoint(LoggerContext.Category.MAPPING).ifPresent(lp -> lp.logMapping(m.getFormattedString()));
            return m;
        }, Try::rethrow));
        return ret;
    }

    public <T> ColumnsMapping<T> createColumnsMapping(Class<T> objectClass) {
        ColumnToAccessorMap columnToAccessorMap = new ColumnToAccessorMap(objectClass, this.sormConfig.getColumnFieldMapper().createAccessors(objectClass));
        return new ColumnsMapping<T>(this.sormConfig.getOptions(), this.sormConfig.getResultSetConverter(), objectClass, columnToAccessorMap);
    }

    public <T> TableMapping<T> createTableMapping(Class<T> objectClass, String tableName, Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        List<ColumnName> allColumns = this.sormConfig.getColumnFieldMapper().getColumns(metaData, tableName);
        List<String> primaryKeys = this.sormConfig.getColumnFieldMapper().getPrimaryKeys(metaData, tableName).stream().map(c -> c.getName()).collect(Collectors.toList());
        List<String> autoGeneratedColumns = this.sormConfig.getColumnFieldMapper().getAutoGeneratedColumns(metaData, tableName).stream().map(c -> c.getName()).collect(Collectors.toList());
        List<String> columns = allColumns.stream().map(c -> c.getName()).collect(Collectors.toList());
        String colmunAliasPrefix = Optional.ofNullable(objectClass.getAnnotation(OrmColumnAliasPrefix.class)).map(a -> a.value()).orElse("");
        TableMetaDataImpl tableMetaData = new TableMetaDataImpl(tableName, colmunAliasPrefix, columns, primaryKeys, autoGeneratedColumns);
        TableSql sql = tableSqlFactory.create(tableMetaData);
        Map<String, Accessor> accessors = this.sormConfig.getColumnFieldMapper().createAccessors(objectClass, allColumns);
        Set<String> keySetWithoutAlias = accessors.keySet();
        if (!StringUtils.equalsAsCanonical(columns, keySetWithoutAlias)) {
            throw new SormException(StringUtils.format("{} does not match any field. Table [{}] contains Columns {} but [{}] contains Fields {}.", columns.stream().filter(e -> !keySetWithoutAlias.contains(StringUtils.toCanonical(e))).sorted().collect(Collectors.toList()), tableName, allColumns.stream().map(c -> c.toString()).sorted().collect(Collectors.toList()), objectClass.getName(), keySetWithoutAlias.stream().sorted().collect(Collectors.toList())));
        }
        ColumnToAccessorMap columnToAccessorMap = new ColumnToAccessorMap(objectClass, accessors);
        return new TableMapping<T>(this.sormConfig.getLoggerContext(), this.sormConfig.getOptions(), this.sormConfig.getResultSetConverter(), this.sormConfig.getSqlParametersSetter(), this.sormConfig.getMultiRowProcessorFactory(), objectClass, columnToAccessorMap, tableMetaData, sql);
    }

    public <T> TableMapping<T> getCastedTableMapping(Connection connection, Class<?> objectClass) {
        return this.getTableMapping(connection, objectClass);
    }

    public <T> TableMapping<T> getCastedTableMapping(Connection connection, String tableName, Class<?> objectClass) {
        return this.getTableMapping(connection, tableName, objectClass);
    }

    public <T> ColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        ColumnsMapping ret = this.columnsMappings.computeIfAbsent(objectClass, _k -> {
            ColumnsMapping m = this.createColumnsMapping(objectClass);
            this.sormConfig.getLoggerContext().createLogPoint(LoggerContext.Category.MAPPING).ifPresent(lp -> lp.logMapping(m.getFormattedString()));
            return m;
        });
        return ret;
    }

    private TableName toTableName(Connection connection, Class<?> objectClass) {
        return this.classNameToValidTableNameMap.computeIfAbsent(objectClass, Try.createFunctionWithThrow(k -> this.sormConfig.getTableNameMapper().getTableName(objectClass, connection.getMetaData()), Try::rethrow));
    }

    public String getTableName(Connection connection, Class<?> objectClass) {
        return this.toTableName(connection, objectClass).getName();
    }

    private TableName toTableName(Connection connection, String tableName) {
        return this.tableNameToValidTableNameMap.computeIfAbsent(tableName, Try.createFunctionWithThrow(k -> this.sormConfig.getTableNameMapper().getTableName(tableName, connection.getMetaData()), Try::rethrow));
    }

    public LoggerContext getLoggerContext() {
        return this.sormConfig.getLoggerContext();
    }

    public int getTransactionIsolationLevel() {
        return this.sormConfig.getTransactionIsolationLevel();
    }

    public SormOptions getOptions() {
        return this.sormConfig.getOptions();
    }

    public ResultSetConverter getResultSetConverter() {
        return this.sormConfig.getResultSetConverter();
    }

    public SqlParametersSetter getSqlParametersSetter() {
        return this.sormConfig.getSqlParametersSetter();
    }

    public String toString() {
        return "SormContext [tableMappings=" + this.tableMappings + ", columnsMappings=" + this.columnsMappings + ", classNameToValidTableNameMap=" + this.classNameToValidTableNameMap + ", tableNameToValidTableNameMap=" + this.tableNameToValidTableNameMap + ", sormConfig=" + this.sormConfig + "]";
    }
}

