/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.logger;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import org.nkjmlab.sorm4j.extension.logger.SormLogger;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;

public abstract class AbstractSormLogger
implements SormLogger {
    @Override
    public void logBeforeSql(String tag, Connection connection, String sql, Object ... parameters) {
        this.logBeforeSql(tag, connection, ParameterizedSql.parse(sql, parameters));
    }

    @Override
    public void logBeforeSql(String tag, Connection connection, ParameterizedSql psql) {
        this.debug(StringUtils.format("[{}] At {}, Execute SQL [{}] to [{}]", tag, this.getCaller(), psql.getBindedSql(), this.getDbUrl(connection)), new Object[0]);
    }

    @Override
    public void logBeforeMultiRow(String tag, Connection connection, Class<?> clazz, int length, String tableName) {
        this.debug(StringUtils.format("[{}] At {}, Execute multirow insert with [{}] objects of [{}] into [{}] on [{}]", tag, this.getCaller(), length, clazz, tableName, this.getDbUrl(connection)), new Object[0]);
    }

    @Override
    public void logAfterQuery(String tag, long elapsedTime, Object ret) {
        this.debug(StringUtils.format("{} Read [{}] objects", this.getTagAndElapsedTime(tag, elapsedTime), ret instanceof Collection ? ((Collection)ret).size() : 1), new Object[0]);
    }

    @Override
    public void logAfterUpdate(String tag, long elapsedTime, int ret) {
        this.debug(StringUtils.format("{} Affect [{}] rows", this.getTagAndElapsedTime(tag, elapsedTime), ret), new Object[0]);
    }

    @Override
    public void logAfterMultiRow(String tag, long elapsedTime, int[] result) {
        this.debug(StringUtils.format("{} Affect [{}] objects", this.getTagAndElapsedTime(tag, elapsedTime), IntStream.of(result).sum()), new Object[0]);
    }

    @Override
    public void logMapping(String tag, String mappingInfo) {
        this.debug("[{}]" + System.lineSeparator() + "{}", tag, mappingInfo);
    }

    private String getTagAndElapsedTime(String tag, long elapsedTime) {
        return "[" + tag + "]" + " [" + String.format("%.3f", (double)elapsedTime / 1000.0 / 1000.0) + " msec] :";
    }

    private String getDbUrl(Connection connection) {
        return Try.getOrDefault(() -> connection.getMetaData().getURL(), "");
    }

    private String getCaller() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        String caller = Arrays.stream(stackTrace).filter(s -> !s.getClassName().startsWith("org.nkjmlab.sorm4j") && !s.getClassName().startsWith("java.")).findFirst().map(se -> String.valueOf(se.getClassName()) + "." + se.getMethodName() + "(" + se.getFileName() + ":" + se.getLineNumber() + ")").orElseGet(() -> "");
        return caller;
    }
}

