/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.logger;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nkjmlab.sorm4j.extension.logger.AbstractSormLogger;
import org.nkjmlab.sorm4j.extension.logger.SormLogger;
import org.nkjmlab.sorm4j.internal.util.StringUtils;

public class JulSormLogger
extends AbstractSormLogger
implements SormLogger {
    private final Logger logger;
    private static Logger defaultLogger = JulSormLogger.getDefaultLogger();

    public JulSormLogger(Logger logger) {
        this.logger = logger;
    }

    private static Logger getDefaultLogger() {
        Logger logger = Logger.getLogger(JulSormLogger.class.getName());
        logger.setLevel(Level.FINE);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINE);
        logger.addHandler(consoleHandler);
        return logger;
    }

    public static SormLogger getLogger() {
        return new JulSormLogger(defaultLogger);
    }

    @Override
    public void trace(String format, Object ... params) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(StringUtils.format(format, params));
        }
    }

    @Override
    public void debug(String format, Object ... params) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(StringUtils.format(format, params));
        }
    }

    @Override
    public void info(String format, Object ... params) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(StringUtils.format(format, params));
        }
    }

    @Override
    public void warn(String format, Object ... params) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(StringUtils.format(format, params));
        }
    }

    @Override
    public void error(String format, Object ... params) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.severe(StringUtils.format(format, params));
        }
    }
}

