/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class ColumnsAndTypes {
    private final List<String> columns;
    private final List<Integer> columnTypes;

    public ColumnsAndTypes(List<String> columns, List<Integer> columnTypes) {
        this.columns = columns;
        this.columnTypes = columnTypes;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<Integer> getColumnTypes() {
        return this.columnTypes;
    }

    static ColumnsAndTypes createColumnsAndTypes(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colNum = metaData.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(colNum);
        ArrayList<Integer> columnTypes = new ArrayList<Integer>(colNum);
        int i = 1;
        while (i <= colNum) {
            columns.add(metaData.getColumnName(i));
            columnTypes.add(metaData.getColumnType(i));
            ++i;
        }
        return new ColumnsAndTypes(columns, columnTypes);
    }
}

