/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nkjmlab.sorm4j.ResultSetTraverser;
import org.nkjmlab.sorm4j.RowMapper;
import org.nkjmlab.sorm4j.internal.mapping.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.sql.result.LazyResultSet;

final class LazyResultSetImpl<T>
implements LazyResultSet<T> {
    private static final Class<? extends Map> MAP_CLASS = LinkedHashMap.class;
    private final Class<T> objectClass;
    private final OrmConnectionImpl ormMapper;
    private final ResultSet resultSet;
    private final PreparedStatement stmt;

    public LazyResultSetImpl(OrmConnectionImpl ormMapper, PreparedStatement stmt, ResultSet resultSet) {
        this(ormMapper, MAP_CLASS, stmt, resultSet);
    }

    public LazyResultSetImpl(OrmConnectionImpl ormMapper, Class<T> objectClass, PreparedStatement stmt, ResultSet resultSet) {
        this.ormMapper = ormMapper;
        this.objectClass = objectClass;
        this.stmt = stmt;
        this.resultSet = resultSet;
    }

    @Override
    public T one() {
        Object ret = Try.getOrThrow(() -> this.objectClass.equals(MAP_CLASS) ? this.ormMapper.loadOneMap(this.resultSet) : this.ormMapper.loadOne(this.objectClass, this.resultSet), Try::rethrow);
        this.close();
        return (T)ret;
    }

    @Override
    public T first() {
        Object ret = Try.getOrThrow(() -> this.objectClass.equals(MAP_CLASS) ? this.ormMapper.loadFirstMap(this.resultSet) : this.ormMapper.loadFirst(this.objectClass, this.resultSet), Try::rethrow);
        this.close();
        return (T)ret;
    }

    @Override
    public List<T> toList() {
        List ret = Try.getOrThrow(() -> this.objectClass.equals(MAP_CLASS) ? Try.getOrThrow(() -> this.ormMapper.traverseAndMapToMapList(this.resultSet), Try::rethrow) : this.ormMapper.loadPojoList(this.objectClass, this.resultSet), Try::rethrow);
        this.close();
        return ret;
    }

    @Override
    public List<T> toList(RowMapper<T> rowMapper) {
        List ret = Try.getOrThrow(() -> ResultSetTraverser.from(rowMapper).traverseAndMap(this.resultSet), Try::rethrow);
        this.close();
        return ret;
    }

    @Override
    public Iterator<T> iterator() {
        return new LazyResultSetIterator<T>(this.ormMapper, this.objectClass, this.stmt, this.resultSet);
    }

    @Override
    public Stream<T> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false).onClose(Try.createRunnable(() -> this.close(), Try::rethrow));
    }

    @Override
    public void close() {
        try {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                }
                catch (SQLException sQLException2) {}
            }
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private final class LazyResultSetIterator<S>
    implements Iterator<S> {
        private final Supplier<S> nextSupplier;

        public LazyResultSetIterator(OrmConnectionImpl ormMapper, Class<S> objectClass, PreparedStatement stmt, ResultSet resultSet) {
            this.nextSupplier = objectClass.equals(MAP_CLASS) ? Try.createSupplierWithThrow(() -> ormMapper.mapRowToMap(resultSet), Try::rethrow) : Try.createSupplierWithThrow(() -> ormMapper.mapRowToObject(objectClass, resultSet), Try::rethrow);
        }

        @Override
        public boolean hasNext() {
            try {
                boolean hasNext = LazyResultSetImpl.this.resultSet.next();
                if (!hasNext) {
                    LazyResultSetImpl.this.close();
                }
                return hasNext;
            }
            catch (SQLException e) {
                LazyResultSetImpl.this.close();
                throw Try.rethrow(e);
            }
        }

        @Override
        public S next() {
            return this.nextSupplier.get();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

