/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.internal.mapping.TableSql;
import org.nkjmlab.sorm4j.sql.TableMetaData;

public class TableSqlFactory {
    public TableSql create(TableMetaData tableMetaData) {
        String tableName = tableMetaData.getTableName();
        List<String> columns = tableMetaData.getColumns();
        List<String> primaryKeys = tableMetaData.getPrimaryKeys();
        List<String> notAutoGeneratedColumns = tableMetaData.getNotAutoGeneratedColumns();
        String insertSqlPrefix = "insert into " + tableName + " (" + TableSqlFactory.toColumList(notAutoGeneratedColumns) + ") values";
        String mergeSqlPrefix = "merge into " + tableName + " (" + TableSqlFactory.toColumList(notAutoGeneratedColumns) + ") values";
        String insertOrMergePlaceholders = " (" + TableSqlFactory.generatePlaceholders(notAutoGeneratedColumns.size()) + ") ";
        String insertSql = String.valueOf(insertSqlPrefix) + insertOrMergePlaceholders;
        String mergeSql = String.valueOf(mergeSqlPrefix) + insertOrMergePlaceholders;
        String selectAllSql = "select " + TableSqlFactory.toColumList(columns) + " from " + tableName;
        String selectByPrimaryKeySql = String.valueOf(selectAllSql) + " " + TableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        String existsSql = "select 1 from " + tableName + TableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys) + " limit 1";
        String updateSql = "update " + tableName + TableSqlFactory.createUpdateSetClause(tableMetaData.getNotPrimaryKeys()) + TableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        String deleteSql = "delete from " + tableName + TableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        return new TableSql(insertOrMergePlaceholders, selectByPrimaryKeySql, selectAllSql, insertSql, updateSql, deleteSql, mergeSql, existsSql, insertSqlPrefix, mergeSqlPrefix);
    }

    private static String toColumList(List<String> columns) {
        return String.join((CharSequence)",", columns);
    }

    private static String createUpdateSetClause(List<String> notPrimaryKeys) {
        return " set " + String.join((CharSequence)",", notPrimaryKeys.stream().map(npk -> String.valueOf(npk) + "=?").collect(Collectors.toList()));
    }

    private static String createWhereClauseIdentifyByPrimaryKeys(List<String> primaryKeys) {
        return " where " + String.join((CharSequence)" and ", primaryKeys.stream().map(pk -> String.valueOf(pk) + "=?").collect(Collectors.toList()));
    }

    private static String generatePlaceholders(int num) {
        return String.join((CharSequence)",", Stream.generate(() -> "?").limit(num).collect(Collectors.toList()));
    }
}

