/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.multirow;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.logger.LoggerContext;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.BatchHelper;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.Try;

final class BatchOfMultiRowInOneStatementProcessor<T>
extends MultiRowProcessor<T> {
    private final int multiRowSize;
    private final int batchSizeWithMultiRow;

    public BatchOfMultiRowInOneStatementProcessor(LoggerContext loggerContext, SormOptions options, SqlParametersSetter sqlParametersSetter, TableMapping<T> tableMapping, int batchSize, int multiRowSize, int batchSizeWithMultiRow) {
        super(loggerContext, options, sqlParametersSetter, tableMapping, batchSize);
        this.multiRowSize = multiRowSize;
        this.batchSizeWithMultiRow = batchSizeWithMultiRow;
    }

    @Override
    @SafeVarargs
    public final int[] multiRowInsert(Connection con, T ... objects) {
        return this.execMultiRowProcIfValidObjects(con, objects, nonNullObjects -> this.procMultiRowOneStatementAndBatch(con, num -> con.prepareStatement(this.tableMapping.getSql().getMultirowInsertSql((int)num)), (stmt, objs) -> this.tableMapping.setPrametersOfMultiRow((PreparedStatement)stmt, objs), (T[])nonNullObjects));
    }

    @Override
    @SafeVarargs
    public final int[] multiRowMerge(Connection con, T ... objects) {
        return this.execMultiRowProcIfValidObjects(con, objects, nonNullObjects -> this.procMultiRowOneStatementAndBatch(con, num -> con.prepareStatement(this.tableMapping.getSql().getMultirowMergeSql((int)num)), (stmt, objs) -> this.tableMapping.setPrametersOfMultiRow((PreparedStatement)stmt, objs), (T[])nonNullObjects));
    }

    private final int[] procMultiRowOneStatementAndBatch(Connection con, Try.ThrowableFunction<Integer, PreparedStatement> multiRowStatementCreator, Try.ThrowableBiConsumer<PreparedStatement, T[]> parametersSetter, T[] objects) {
        List<T[]> objsPartitions = ArrayUtils.split(this.multiRowSize, objects);
        int[] result = new int[objsPartitions.size()];
        boolean origAutoCommit = this.getAutoCommit(con);
        try {
            int[] nArray;
            block26: {
                this.setAutoCommit(con, false);
                Throwable throwable = null;
                Object var9_12 = null;
                try (PreparedStatement stmt = multiRowStatementCreator.apply(this.multiRowSize);){
                    BatchHelper helper = new BatchHelper(this.batchSizeWithMultiRow, stmt);
                    int partitionNum = 0;
                    while (partitionNum < objsPartitions.size() - 1) {
                        T[] objectsInOnePartition = objsPartitions.get(partitionNum);
                        parametersSetter.accept(stmt, objectsInOnePartition);
                        helper.addBatchAndExecuteIfReachedThreshold();
                        ++partitionNum;
                    }
                    int[] firstResult = helper.finish();
                    System.arraycopy(firstResult, 0, result, 0, firstResult.length);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                int lastPartition = objsPartitions.size() - 1;
                T[] objectsInLastPartition = objsPartitions.get(lastPartition);
                Throwable throwable3 = null;
                Object var11_16 = null;
                PreparedStatement lastStmt = multiRowStatementCreator.apply(objectsInLastPartition.length);
                try {
                    parametersSetter.accept(lastStmt, objectsInLastPartition);
                    result[lastPartition] = lastStmt.executeUpdate();
                    nArray = result;
                    if (lastStmt == null) break block26;
                }
                catch (Throwable throwable4) {
                    try {
                        try {
                            if (lastStmt != null) {
                                lastStmt.close();
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable e) {
                        this.rollbackIfRequired(con, origAutoCommit);
                        throw Try.rethrow(e);
                    }
                }
                lastStmt.close();
            }
            return nArray;
        }
        finally {
            this.commitIfRequired(con, origAutoCommit);
            this.setAutoCommit(con, origAutoCommit);
        }
    }
}

