/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.multirow;

import java.util.function.Function;
import org.nkjmlab.sorm4j.extension.MultiRowProcessorType;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.logger.LoggerContext;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.BatchOfMultiRowInOneStatementProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowInOneStatementProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.SimpleBatchProcessor;

public final class MultiRowProcessorFactory {
    private final MultiRowProcessorType multiRowProcessorType;
    private final Function<TableMapping<?>, MultiRowProcessor<?>> multiRowProcessorFactory;

    private MultiRowProcessorFactory(MultiRowProcessorType multiRowProcessorType, Function<TableMapping<?>, MultiRowProcessor<?>> multiRowProcessorFactory) {
        this.multiRowProcessorType = multiRowProcessorType;
        this.multiRowProcessorFactory = multiRowProcessorFactory;
    }

    public MultiRowProcessor<?> getMultiRowProcessor(TableMapping<?> tableMapping) {
        return this.multiRowProcessorFactory.apply(tableMapping);
    }

    public static MultiRowProcessorFactory createMultiRowProcessorFactory(LoggerContext loggerContext, SormOptions options, SqlParametersSetter sqlParametersSetter, MultiRowProcessorType multiRowProcessorType, int batchSize, int multiRowSize, int batchSizeWithMultiRow) {
        switch (multiRowProcessorType) {
            case SIMPLE_BATCH: {
                return new MultiRowProcessorFactory(multiRowProcessorType, t -> new SimpleBatchProcessor(loggerContext, options, sqlParametersSetter, t, batchSize));
            }
            case MULTI_ROW: {
                return new MultiRowProcessorFactory(multiRowProcessorType, t -> new MultiRowInOneStatementProcessor(loggerContext, options, sqlParametersSetter, t, batchSize, multiRowSize));
            }
            case MULTI_ROW_AND_BATCH: {
                return new MultiRowProcessorFactory(multiRowProcessorType, t -> new BatchOfMultiRowInOneStatementProcessor(loggerContext, options, sqlParametersSetter, t, batchSize, multiRowSize, batchSizeWithMultiRow));
            }
        }
        return null;
    }

    public String toString() {
        return "MultiRowProcessorFactory [multiRowProcessorType=" + (Object)((Object)this.multiRowProcessorType) + "]";
    }
}

