/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Try {
    public static <T, S> BiConsumer<T, S> createBiConsumer(ThrowableBiConsumer<T, S> onTry, Consumer<Exception> onCatch) {
        return (t, s) -> {
            try {
                onTry.accept(t, s);
            }
            catch (Exception e) {
                onCatch.accept(e);
            }
        };
    }

    public static <T, S, X extends RuntimeException> BiConsumer<T, S> createBiConsumerWithThrow(ThrowableBiConsumer<T, S> onTry, Function<Exception, ? extends X> ex) throws X {
        return Try.createBiConsumer(onTry, e -> {
            throw (RuntimeException)ex.apply((Exception)e);
        });
    }

    public static <T, R> Consumer<T> createConsumer(ThrowableConsumer<T> onTry, Consumer<Exception> onCatch) {
        return x -> {
            try {
                onTry.accept(x);
            }
            catch (Exception e) {
                onCatch.accept(e);
            }
        };
    }

    public static <T, X extends RuntimeException> Consumer<T> createConsumerWithThrow(ThrowableConsumer<T> onTry, Function<Exception, ? extends X> ex) throws X {
        return Try.createConsumer(onTry, e -> {
            throw (RuntimeException)ex.apply((Exception)e);
        });
    }

    public static <T, R> Function<T, R> createFunction(ThrowableFunction<T, R> onTry, Function<Exception, R> onCatch) {
        return x -> {
            try {
                return onTry.apply(x);
            }
            catch (Exception e) {
                return onCatch.apply(e);
            }
        };
    }

    public static <T, R, X extends RuntimeException> Function<T, R> createFunctionWithThrow(ThrowableFunction<T, R> onTry, Function<Exception, ? extends X> ex) throws X {
        return Try.createFunction(onTry, e -> {
            throw (RuntimeException)ex.apply((Exception)e);
        });
    }

    public static Runnable createRunnable(ThrowableRunnable onTry, Consumer<Exception> onCatch) {
        return () -> {
            try {
                onTry.run();
            }
            catch (Exception e) {
                onCatch.accept(e);
            }
        };
    }

    public static <X extends RuntimeException> Runnable createRunnableWithThrow(ThrowableRunnable onTry, Function<Exception, ? extends X> ex) throws X {
        return Try.createRunnable(onTry, e -> {
            throw (RuntimeException)ex.apply((Exception)e);
        });
    }

    public static <T> Supplier<T> createSupplier(ThrowableSupplier<T> onTry, Function<Exception, T> onCatch) {
        return () -> {
            try {
                return onTry.get();
            }
            catch (Exception e) {
                return onCatch.apply(e);
            }
        };
    }

    public static <T, X extends RuntimeException> Supplier<T> createSupplierWithThrow(ThrowableSupplier<T> onTry, Function<Exception, ? extends X> ex) throws X {
        return Try.createSupplier(onTry, e -> {
            throw (RuntimeException)ex.apply((Exception)e);
        });
    }

    public static <T> T getOrDefault(ThrowableSupplier<T> onTry, T defaultValue) {
        return (T)Try.createSupplier(onTry, e -> defaultValue).get();
    }

    public static <T> T getOrNull(ThrowableSupplier<T> onTry) {
        return (T)Try.createSupplier(onTry, e -> null).get();
    }

    public static <T, X extends RuntimeException> T getOrThrow(ThrowableSupplier<T> onTry, Function<Exception, ? extends X> ex) throws X {
        return (T)Try.createSupplier(onTry, e -> {
            throw (RuntimeException)ex.apply((Exception)e);
        }).get();
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static <T, X extends RuntimeException> void runOrThrow(ThrowableRunnable onTry, Function<Exception, ? extends X> ex) throws X {
        Try.createRunnable(onTry, e -> {
            throw (RuntimeException)ex.apply((Exception)e);
        }).run();
    }

    private Try() {
    }

    public static void runOrElse(ThrowableRunnable onTry, Consumer<Exception> onCatch) {
        Try.createRunnable(onTry, onCatch).run();
    }

    @FunctionalInterface
    public static interface ThrowableBiConsumer<T, S> {
        public void accept(T var1, S var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowableConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowableRunnable {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowableSupplier<T> {
        public T get() throws Exception;
    }
}

