/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.sql.SqlKeyword;

@Experimental
public class SelectSql {
    public static Condition and(Object ... conds) {
        return new Condition("and", conds);
    }

    public static String as(Object src, String alias) {
        return src + SqlKeyword.AS + alias;
    }

    public static String between(String colName, Object beginExp, Object endExp) {
        return SelectSql.wrapSpace(String.valueOf(colName) + SqlKeyword.BETWEEN + SelectSql.literal(beginExp) + SqlKeyword.AND + SelectSql.literal(endExp));
    }

    public static String castAs(String src, String toType) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.CAST) + SelectSql.wrapParentheses(String.valueOf(src) + SqlKeyword.AS + toType));
    }

    public static String column(String tableName, String ... colNames) {
        return Arrays.stream(colNames).map(col -> SelectSql.column(tableName, col)).collect(Collectors.joining(", "));
    }

    public static Condition condition(String cond) {
        return new Condition(cond);
    }

    public static Condition condition(Object left, String op, Object right) {
        return new Condition(left, op, right);
    }

    public static String cond(Object left, String op, Object right) {
        return left + op + right;
    }

    public static String count(String colName) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.COUNT) + SelectSql.wrapParentheses(colName));
    }

    public static String from(String tableName) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.FROM) + tableName);
    }

    public static String groupBy(String ... groups) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.GROUP_BY) + SelectSql.joinCommaAndSpace(groups));
    }

    public static String limit(int limit) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.LIMIT) + limit);
    }

    public static String literal(Object element) {
        if (element == null) {
            return "null";
        }
        if (element.getClass().isArray()) {
            return "[" + String.join((CharSequence)", ", (CharSequence[])((List)element).stream().map(e -> SelectSql.literal(e)).toArray(String[]::new)) + "]";
        }
        if (element instanceof List) {
            return String.join((CharSequence)", ", (CharSequence[])((List)element).stream().map(e -> SelectSql.literal(e)).toArray(String[]::new));
        }
        String str = element.toString();
        if (element instanceof Number || element instanceof Boolean) {
            return str;
        }
        switch (str) {
            case "?": {
                return str;
            }
        }
        return SelectSql.quote(str);
    }

    public static String func(String functionName, String column) {
        return SelectSql.wrapSpace(String.valueOf(functionName) + SelectSql.wrapParentheses(column));
    }

    public static String func(String functionName, String ... columns) {
        return SelectSql.wrapSpace(String.valueOf(functionName) + SelectSql.wrapParentheses(SelectSql.joinCommaAndSpace(columns)));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Condition or(Object ... conds) {
        return new Condition("or", conds);
    }

    public static OrderBy orderBy(String column, String ascOrDesc) {
        return new OrderBy(column, ascOrDesc);
    }

    public static String orderBy(String column) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.ORDER_BY) + column);
    }

    public static String orderByAsc(String column) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.ORDER_BY) + column + SqlKeyword.ASC);
    }

    public static String orderByDesc(String column) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.ORDER_BY) + column + SqlKeyword.DESC);
    }

    public static String quote(String str) {
        return SelectSql.wrapSingleQuote(str.contains("'") ? str.replaceAll("'", "''") : str);
    }

    public static String select(String selectClause) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.SELECT) + selectClause);
    }

    public static String select(String ... selectClauses) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.SELECT) + SelectSql.joinCommaAndSpace(selectClauses));
    }

    public static String selectDistinct(String ... selectClauses) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.SELECT) + SqlKeyword.DISTINCT + SelectSql.joinCommaAndSpace(selectClauses));
    }

    public static String selectStar() {
        return SelectSql.wrapSpace(SelectSql.select(SqlKeyword.STAR));
    }

    public static String selectStarFrom(String tableName) {
        return SelectSql.wrapSpace(String.valueOf(SelectSql.selectStar()) + SelectSql.from(tableName));
    }

    public static String sum(String column) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.SUM) + SelectSql.wrapParentheses(column));
    }

    public static String where(String whereClause) {
        return SelectSql.wrapSpace(String.valueOf(SqlKeyword.WHERE) + whereClause);
    }

    private static String joinCommaAndSpace(String ... elements) {
        return String.join((CharSequence)", ", elements);
    }

    private static String wrapParentheses(String str) {
        return "(" + str + ")";
    }

    private static String wrapSingleQuote(String str) {
        return "'" + str + "'";
    }

    private static String wrapSpace(String str) {
        return " " + str + " ";
    }

    public static class Builder {
        private String columns = "*";
        private boolean distinct;
        private String groupBy;
        private String having;
        private String limit;
        private String orderBy;
        private String table;
        private String where;

        public String build() {
            return this.toPrettyString(false);
        }

        public Builder distinct() {
            this.distinct = true;
            return this;
        }

        public Builder from(String table) {
            this.table = table;
            return this;
        }

        public Builder groupBy(String ... columns) {
            this.groupBy = String.join((CharSequence)",", Arrays.stream(columns).collect(Collectors.toList()));
            return this;
        }

        public Builder having(Condition condition) {
            this.having(condition.toString());
            return this;
        }

        public Builder having(String expr) {
            this.having = expr;
            return this;
        }

        public Builder limit(int limit) {
            return this.limit(limit, 0);
        }

        public Builder limit(int limit, int offset) {
            this.limit = String.valueOf(limit) + (offset > 0 ? " offset " + offset : "");
            return this;
        }

        public Builder orderBy(OrderBy ... orderBys) {
            this.orderBy = String.join((CharSequence)", ", Arrays.stream(orderBys).map(ob -> ob.toString()).collect(Collectors.toList()));
            return this;
        }

        public Builder orderBy(String column, String ascOrDesc) {
            this.orderBy(new OrderBy(column, ascOrDesc));
            return this;
        }

        public Builder select(String ... columns) {
            this.columns = String.join((CharSequence)", ", Arrays.stream(columns).collect(Collectors.toList()));
            return this;
        }

        public String toPrettyString() {
            return this.toPrettyString(true);
        }

        public String toPrettyString(boolean prettyPrint) {
            StringBuilder sql = new StringBuilder("select ");
            if (this.distinct) {
                sql.append("distinct ");
            }
            sql.append(this.columns);
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(String.valueOf(SqlKeyword.FROM) + this.table);
            if (this.where != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(String.valueOf(SqlKeyword.WHERE) + this.where);
            }
            if (this.groupBy != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(String.valueOf(SqlKeyword.GROUP_BY) + this.groupBy);
            }
            if (this.having != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(String.valueOf(SqlKeyword.HAVING) + this.having);
            }
            if (this.orderBy != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(String.valueOf(SqlKeyword.ORDER_BY) + this.orderBy);
            }
            if (this.limit != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(String.valueOf(SqlKeyword.LIMIT) + this.limit);
            }
            return sql.toString();
        }

        public String toString() {
            return this.toPrettyString(false);
        }

        public Builder where(Condition condition) {
            this.where(condition.toString());
            return this;
        }

        public Builder where(String expr) {
            this.where = expr;
            return this;
        }
    }

    public static class Condition {
        private final Object condition;

        private Condition(Object expr) {
            this.condition = expr;
        }

        private Condition(String op, Object ... conds) {
            this("(" + String.join((CharSequence)(" " + op + " "), Arrays.stream(conds).map(c -> c.toString()).collect(Collectors.toList())) + ")");
        }

        private Condition(Object left, String op, Object right) {
            this.condition = left + op + right;
        }

        public String toString() {
            return this.condition.toString();
        }
    }

    public static class OrderBy {
        private final String ascOrDesc;
        private final String column;

        private OrderBy(String column, String ascOrDesc) {
            this.column = column;
            this.ascOrDesc = ascOrDesc;
        }

        public String toString() {
            return String.valueOf(this.column) + " " + this.ascOrDesc;
        }
    }
}

