/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.OrmColumn;
import org.nkjmlab.sorm4j.annotation.OrmColumnAliasPrefix;
import org.nkjmlab.sorm4j.annotation.OrmGetter;
import org.nkjmlab.sorm4j.annotation.OrmIgnore;
import org.nkjmlab.sorm4j.annotation.OrmSetter;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.ColumnName;
import org.nkjmlab.sorm4j.extension.ColumnNameWithMetaData;
import org.nkjmlab.sorm4j.extension.FieldName;
import org.nkjmlab.sorm4j.extension.logger.LoggerContext;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.internal.util.StringUtils;

public class DefaultColumnFieldMapper
implements ColumnFieldMapper {
    private final LoggerContext loggerContext;

    public DefaultColumnFieldMapper() {
        this(LoggerContext.newBuilder().build());
    }

    public DefaultColumnFieldMapper(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    private Map<String, Method> extractedMethodStartWith(Class<?> objectClass, String prefix) {
        Class<OrmIgnore> ignoreAnn = OrmIgnore.class;
        return Arrays.stream(objectClass.getMethods()).filter(m -> Objects.isNull(m.getAnnotation(ignoreAnn)) && !Modifier.isStatic(m.getModifiers()) && m.getName().length() > prefix.length() && m.getName().substring(0, prefix.length()).equals(prefix)).collect(Collectors.toMap(m -> StringCache.toCanonicalCase(m.getName().substring(prefix.length())), m -> m));
    }

    private static Map<String, Field> getAllFields(Class<?> objectClass) {
        Class<OrmIgnore> ignoreAnn = OrmIgnore.class;
        return Arrays.stream(objectClass.getFields()).filter(f -> Objects.isNull(f.getAnnotation(ignoreAnn)) && !Modifier.isStatic(f.getModifiers())).collect(Collectors.toMap(f -> StringCache.toCanonicalCase(f.getName()), f -> f));
    }

    private Map<String, Method> getAllGetters(Class<?> objectClass) {
        return this.extractedMethodStartWith(objectClass, "get").entrySet().stream().filter(e -> Objects.nonNull(this.isValidGetter((Method)e.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Method)e.getValue()));
    }

    private Map<String, Method> getAllSetters(Class<?> objectClass) {
        return this.extractedMethodStartWith(objectClass, "set").entrySet().stream().filter(e -> Objects.nonNull(this.isValidSetter((Method)e.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Method)e.getValue()));
    }

    private Map<String, Method> getAnnotatatedSettersMap(Class<?> objectClass) {
        Class<OrmSetter> ann = OrmSetter.class;
        return Arrays.stream(objectClass.getMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann)) && Objects.nonNull(this.isValidSetter((Method)m))).collect(Collectors.toMap(m -> StringCache.toCanonicalCase(((OrmSetter)m.getAnnotation(ann)).value()), m -> m));
    }

    private Map<String, Field> getAnnotatedFieldsMap(Class<?> objectClass) {
        Class<OrmColumn> ann = OrmColumn.class;
        return Arrays.stream(objectClass.getFields()).filter(f -> Objects.nonNull(f.getAnnotation(ann))).collect(Collectors.toMap(f -> StringCache.toCanonicalCase(((OrmColumn)f.getAnnotation(ann)).value()), f -> f));
    }

    private Map<String, Method> getAnnotatedGettersMap(Class<?> objectClass) {
        Class<OrmGetter> ann = OrmGetter.class;
        return Arrays.stream(objectClass.getMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann)) && Objects.nonNull(this.isValidGetter((Method)m))).collect(Collectors.toMap(m -> StringCache.toCanonicalCase(((OrmGetter)m.getAnnotation(ann)).value()), m -> m));
    }

    private Method isValidGetter(Method getter) {
        if (getter == null) {
            return null;
        }
        if (getter.getName().equals("getClass")) {
            return null;
        }
        if (getter.getParameterCount() != 0) {
            this.loggerContext.getLogger().warn("Getter [{}] should not have parameter but has {} params.", getter, getter.getParameterCount());
            return null;
        }
        if (getter.getReturnType() == Void.TYPE) {
            this.loggerContext.getLogger().warn("Getter [{}] must have return a parameter.", getter);
        }
        return getter;
    }

    private Method isValidSetter(Method setter) {
        if (setter == null) {
            return null;
        }
        if (setter.getParameterCount() != 1) {
            this.loggerContext.getLogger().warn("Setter [{}] should have a single parameter but has {} params.", setter, setter.getParameterCount());
            return null;
        }
        return setter;
    }

    @Override
    public Map<String, Accessor> createAccessors(Class<?> objectClass) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(DefaultColumnFieldMapper.getAllFields(objectClass).keySet());
        names.addAll(this.getAllGetters(objectClass).keySet());
        names.addAll(this.getAllSetters(objectClass).keySet());
        names.addAll(this.getAnnotatedFieldsMap(objectClass).keySet());
        names.addAll(this.getAnnotatedGettersMap(objectClass).keySet());
        names.addAll(this.getAnnotatatedSettersMap(objectClass).keySet());
        return this.createAccessors(objectClass, new ArrayList<String>(names));
    }

    @Override
    public Map<String, Accessor> createAccessors(Class<?> objectClass, List<String> columnNames) {
        Map<String, Field> fields = DefaultColumnFieldMapper.getAllFields(objectClass);
        Map<String, Method> getters = this.getAllGetters(objectClass);
        Map<String, Method> setters = this.getAllSetters(objectClass);
        Map<String, Field> annotatedFields = this.getAnnotatedFieldsMap(objectClass);
        Map<String, Method> annotatedGetters = this.getAnnotatedGettersMap(objectClass);
        Map<String, Method> annotatedSetters = this.getAnnotatatedSettersMap(objectClass);
        HashMap<String, Accessor> ret = new HashMap<String, Accessor>();
        for (String canonicalColName : (String[])columnNames.stream().map(col -> StringCache.toCanonicalCase(col)).toArray(String[]::new)) {
            Method s;
            Field f = Objects.nonNull(annotatedFields.get(canonicalColName)) ? annotatedFields.get(canonicalColName) : fields.get(canonicalColName);
            Method g = Objects.nonNull(annotatedGetters.get(canonicalColName)) ? annotatedGetters.get(canonicalColName) : getters.get(canonicalColName);
            Method method = s = Objects.nonNull(annotatedSetters.get(canonicalColName)) ? annotatedSetters.get(canonicalColName) : setters.get(canonicalColName);
            if (f == null && g == null && s == null) {
                this.loggerContext.getLogger().debug("Skip matching with ColumnName [{}] to field because could not found corresponding field.", canonicalColName);
                continue;
            }
            ret.put(canonicalColName, new Accessor(canonicalColName, f, g, s));
        }
        return ret;
    }

    @Override
    public List<ColumnName> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<ColumnName> columnsList = new ArrayList<ColumnName>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                String isAutoIncrement = resultSet.getString(23);
                if (!isAutoIncrement.equals("YES")) continue;
                columnsList.add(new ColumnName(columnName));
            }
            ArrayList<ColumnName> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<ColumnNameWithMetaData> getColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<ColumnNameWithMetaData> columnsList = new ArrayList<ColumnNameWithMetaData>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                int dataType = resultSet.getInt(5);
                String typeName = resultSet.getString(6);
                int ordinalPosition = resultSet.getInt(17);
                String isNullable = resultSet.getString(18);
                String isAutoIncremented = resultSet.getString(23);
                String isGenerated = resultSet.getString(24);
                columnsList.add(new ColumnNameWithMetaData(columnName, dataType, typeName, ordinalPosition, isNullable, isAutoIncremented, isGenerated));
            }
            ArrayList<ColumnNameWithMetaData> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<ColumnName> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException {
        ArrayList<ColumnName> primaryKeysList = new ArrayList<ColumnName>();
        try (ResultSet resultSet = metaData.getPrimaryKeys(null, this.getSchemaPattern(metaData), tableName);){
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                primaryKeysList.add(new ColumnName(columnName));
            }
            ArrayList<ColumnName> arrayList = primaryKeysList;
            return arrayList;
        }
    }

    protected String getSchemaPattern(DatabaseMetaData metaData) throws SQLException {
        return "Oracle".equalsIgnoreCase(metaData.getDatabaseProductName()) ? "%" : null;
    }

    protected List<ColumnName> guessColumnNameCandidates(FieldName fieldName) {
        String _fieldName = fieldName.getName();
        return Stream.of(StringCache.toCanonicalCase(_fieldName)).map(ColumnName::new).collect(Collectors.toList());
    }

    @Override
    public String getColumnAliasPrefix(Class<?> objectClass) {
        return Optional.ofNullable(objectClass.getAnnotation(OrmColumnAliasPrefix.class)).map(a -> a.value()).orElse("");
    }

    @Override
    public Map<String, Accessor> createAliasAccessors(String prefix, Map<String, Accessor> accessors) {
        if (prefix.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Accessor> ret = new HashMap<String, Accessor>();
        for (String key : accessors.keySet()) {
            String aKey = StringCache.toCanonicalCase(prefix + key);
            if (accessors.containsKey(aKey)) {
                throw new SormException(StringUtils.format("Modify table alias because table alias [{}] and column [{}] is concatenated and it becomes duplicated column", prefix, key));
            }
            ret.put(aKey, accessors.get(key));
        }
        return ret;
    }
}

