/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.nkjmlab.sorm4j.SormException;

public final class Accessor {
    private static final EmptyGetter EMPTY_GETTER = new EmptyGetter();
    private static final EmptySetter EMPTY_SETTER = new EmptySetter();
    private final GetterAccessor getter;
    private final SetterAccessor setter;
    private final String columnName;

    public Accessor(String columnName, Field field, Method getter, Method setter) {
        this.columnName = columnName;
        GetterAccessor getterAccessor = getter != null ? new GetterMethod(getter) : (this.getter = field != null ? new FieldGetter(field) : EMPTY_GETTER);
        this.setter = setter != null ? new SetterMethod(setter) : (field != null ? new FieldSetter(field) : EMPTY_SETTER);
    }

    public Object get(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.getter.get(object);
    }

    public void set(Object object, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setter.set(object, value);
    }

    public final Class<?> getSetterParameterType() {
        return this.setter.getParameterType();
    }

    public String toString() {
        return "Accessor [getterAccessor=" + this.getter + ", setterAccessor=" + this.setter + ", columnName=" + this.columnName + "]";
    }

    public String getFormattedString() {
        return "getter=[" + this.getter + "], setter=[" + this.setter + "]";
    }

    private static final class FieldSetter
    implements SetterAccessor {
        private final Field field;

        public FieldSetter(Field field) {
            this.field = field;
        }

        @Override
        public Class<?> getParameterType() {
            Class<?> type = this.field.getType();
            return type;
        }

        @Override
        public void set(Object object, Object value) throws IllegalArgumentException, IllegalAccessException {
            this.field.set(object, value);
        }

        public String toString() {
            return "field " + this.field.getType().getSimpleName() + " " + this.field.getName();
        }
    }

    private static final class SetterMethod
    implements SetterAccessor {
        private final Method setter;

        public SetterMethod(Method setter) {
            this.setter = setter;
        }

        @Override
        public Class<?> getParameterType() {
            Class<?> type = this.setter.getParameterTypes()[0];
            return type;
        }

        @Override
        public void set(Object object, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setter.invoke(object, value);
        }

        public String toString() {
            return this.setter.getName() + "(" + this.setter.getParameterTypes()[0].getSimpleName() + ")";
        }
    }

    private static final class EmptySetter
    implements SetterAccessor {
        private EmptySetter() {
        }

        @Override
        public void set(Object object, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new SormException("No valid setter for " + object);
        }

        @Override
        public Class<?> getParameterType() {
            throw new SormException("No valid setter");
        }
    }

    private static interface SetterAccessor {
        public void set(Object var1, Object var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public Class<?> getParameterType();
    }

    private static final class FieldGetter
    implements GetterAccessor {
        private final Field field;

        public FieldGetter(Field field) {
            this.field = field;
        }

        @Override
        public Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.get(object);
        }

        public String toString() {
            return "field " + this.field.getType().getSimpleName() + " " + this.field.getName();
        }
    }

    private static final class EmptyGetter
    implements GetterAccessor {
        private EmptyGetter() {
        }

        @Override
        public Object get(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new SormException("No valid getter for " + object);
        }
    }

    private static final class GetterMethod
    implements GetterAccessor {
        private final Method getter;

        public GetterMethod(Method getter) {
            this.getter = getter;
        }

        @Override
        public Object get(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.getter.invoke(object, new Object[0]);
        }

        public String toString() {
            return this.getter.getReturnType().getSimpleName() + " " + this.getter.getName() + "()";
        }
    }

    private static interface GetterAccessor {
        public Object get(Object var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;
    }
}

