/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.OrmConstructor;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.internal.mapping.Mapping;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;

public final class ColumnsMapping<T>
extends Mapping<T> {
    private final PojoCreator<T> pojoCreator;
    private final Map<List<String>, int[]> columnTypesMap = new ConcurrentHashMap<List<String>, int[]>();

    public ColumnsMapping(SormOptions options, ResultSetConverter resultSetConverter, Class<T> objectClass, ColumnToAccessorMap columnToAccessorMap) {
        super(options, resultSetConverter, objectClass, columnToAccessorMap);
        List annotataedConstructors = Arrays.stream(objectClass.getConstructors()).filter(c -> c.getAnnotation(OrmConstructor.class) != null).collect(Collectors.toList());
        if (annotataedConstructors.size() > 1) {
            throw new SormException(StringUtils.format("Constructor with parameters annotated by {} should be one or less. ", OrmConstructor.class.getName()));
        }
        this.pojoCreator = !annotataedConstructors.isEmpty() ? new ConstructorPojoCreator((Constructor)annotataedConstructors.get(0), columnToAccessorMap.getColumnAliasPrefix()) : new SetterPojoCreator(Try.getOrThrow(() -> objectClass.getConstructor(new Class[0]), e -> new SormException(StringUtils.format("The given container class [{}] should have the public default constructor (with no arguments) or the constructor annotated by [{}].", objectClass, OrmConstructor.class.getName()), (Throwable)e)));
    }

    private int[] getColumnTypes(ResultSet resultSet, List<String> columns) {
        return this.columnTypesMap.computeIfAbsent(columns, k -> Try.getOrThrow(() -> {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int n = metaData.getColumnCount();
            int[] ret = new int[n];
            for (int i = 1; i <= ret.length; ++i) {
                ret[i - 1] = metaData.getColumnType(i);
            }
            return ret;
        }, Try::rethrow));
    }

    public String getFormattedString() {
        return "[" + ColumnsMapping.class.getSimpleName() + "] Columns are mappted to a class" + System.lineSeparator() + super.getColumnToAccessorString() + System.lineSeparator() + "  with [" + this.pojoCreator + "]";
    }

    public List<T> loadPojoList(ResultSet resultSet) throws SQLException {
        return this.pojoCreator.loadPojoList(resultSet, this.createColumnLabels(resultSet));
    }

    public T loadPojo(ResultSet resultSet) throws SQLException {
        return this.pojoCreator.loadPojo(resultSet, this.createColumnLabels(resultSet));
    }

    public List<String> createColumnLabels(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colNum = metaData.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(colNum);
        for (int i = 1; i <= colNum; ++i) {
            columns.add(metaData.getColumnLabel(i));
        }
        return columns;
    }

    private final class ConstructorPojoCreator<S>
    extends PojoCreator<S> {
        private final Map<String, ConstructorParameter> constructorParametersMap;
        private final int constructorParametersLength;
        private final Map<List<String>, ConstructorParameter[]> columnAndConstructorParameterMapping;

        public ConstructorPojoCreator(Constructor<S> constructor, String columnAliasPrefix) {
            super(constructor);
            this.constructorParametersMap = new HashMap<String, ConstructorParameter>();
            this.columnAndConstructorParameterMapping = new ConcurrentHashMap<List<String>, ConstructorParameter[]>();
            String[] parameterNames = constructor.getAnnotation(OrmConstructor.class).value();
            Parameter[] parameters = constructor.getParameters();
            this.constructorParametersLength = parameters.length;
            for (int i = 0; i < this.constructorParametersLength; ++i) {
                Parameter parameter = parameters[i];
                String canonicalName = StringCache.toCanonicalCase(parameterNames[i]);
                ConstructorParameter cp = new ConstructorParameter(canonicalName, i, parameter.getType());
                this.constructorParametersMap.put(canonicalName, cp);
                if (columnAliasPrefix == null || columnAliasPrefix.length() == 0) continue;
                this.constructorParametersMap.put(StringCache.toCanonicalCase(columnAliasPrefix + canonicalName), cp);
            }
        }

        private S createPojo(ResultSet resultSet, int[] sqlTypes, ConstructorParameter[] constructorParameters) {
            try {
                Object[] params = new Object[this.constructorParametersLength];
                for (int i = 0; i < constructorParameters.length; ++i) {
                    ConstructorParameter cp = constructorParameters[i];
                    if (cp == null) continue;
                    params[cp.getOrder()] = ColumnsMapping.this.resultSetConverter.convertColumnValueTo(ColumnsMapping.this.options, resultSet, i + 1, sqlTypes[i], constructorParameters[i].getType());
                }
                return (S)this.constructor.newInstance(params);
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                throw new SormException("Constructor with parameters of container class for object-relation mapping is not match with columns.", e);
            }
        }

        private ConstructorParameter[] getCorrespondingParameter(List<String> columns) {
            return this.columnAndConstructorParameterMapping.computeIfAbsent(columns, key -> (ConstructorParameter[])columns.stream().map(col -> this.constructorParametersMap.get(StringCache.toCanonicalCase(col))).toArray(ConstructorParameter[]::new));
        }

        @Override
        List<S> loadPojoList(ResultSet resultSet, List<String> columns) throws SQLException {
            int[] columnTypes = ColumnsMapping.this.getColumnTypes(resultSet, columns);
            ConstructorParameter[] constructorParameters = this.getCorrespondingParameter(columns);
            ArrayList<S> ret = new ArrayList<S>();
            while (resultSet.next()) {
                ret.add(this.createPojo(resultSet, columnTypes, constructorParameters));
            }
            return ret;
        }

        @Override
        S loadPojo(ResultSet resultSet, List<String> columns) throws SQLException {
            int[] columnTypes = ColumnsMapping.this.getColumnTypes(resultSet, columns);
            ConstructorParameter[] constructorParameters = this.getCorrespondingParameter(columns);
            return this.createPojo(resultSet, columnTypes, constructorParameters);
        }

        public String toString() {
            return "ConstructorPojoCreator [constructorParametersMap=" + this.constructorParametersMap + "]";
        }
    }

    private static class ConstructorParameter {
        private final String name;
        private final int order;
        private final Class<?> type;

        public ConstructorParameter(String name, int order, Class<?> type) {
            this.name = name;
            this.order = order;
            this.type = type;
        }

        public int getOrder() {
            return this.order;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String toString() {
            return "ConstructorParameter [name=" + this.name + ", order=" + this.order + ", type=" + this.type + "]";
        }
    }

    private final class SetterPojoCreator<S>
    extends PojoCreator<S> {
        private final Map<List<String>, Class<?>[]> setterTypesMap;

        public SetterPojoCreator(Constructor<S> constructor) {
            super(constructor);
            this.setterTypesMap = new ConcurrentHashMap<List<String>, Class<?>[]>();
        }

        private Class<?>[] getSetterTypes(List<String> columns) {
            return this.setterTypesMap.computeIfAbsent(columns, k -> (Class[])columns.stream().map(columnName -> {
                Accessor acc = ColumnsMapping.this.columnToAccessorMap.get((String)columnName);
                return acc != null ? acc.getSetterParameterType() : null;
            }).toArray(Class[]::new));
        }

        @Override
        S loadPojo(ResultSet resultSet, List<String> columns) throws SQLException {
            Class<?>[] setterTypes = this.getSetterTypes(columns);
            int[] columnTypes = ColumnsMapping.this.getColumnTypes(resultSet, columns);
            return this.createPojo(resultSet, columns, columnTypes, setterTypes);
        }

        @Override
        public List<S> loadPojoList(ResultSet resultSet, List<String> columns) throws SQLException {
            Class<?>[] setterTypes = this.getSetterTypes(columns);
            int[] columnTypes = ColumnsMapping.this.getColumnTypes(resultSet, columns);
            ArrayList<S> ret = new ArrayList<S>();
            while (resultSet.next()) {
                ret.add(this.createPojo(resultSet, columns, columnTypes, setterTypes));
            }
            return ret;
        }

        private S createPojo(ResultSet resultSet, List<String> columns, int[] sqlTypes, Class<?>[] setterTypes) {
            try {
                Object ret = this.constructor.newInstance(new Object[0]);
                for (int i = 1; i <= columns.size(); ++i) {
                    Class<?> setterType = setterTypes[i - 1];
                    int sqlType = sqlTypes[i - 1];
                    if (setterType == null) continue;
                    String columnName = columns.get(i - 1);
                    Object value = ColumnsMapping.this.resultSetConverter.convertColumnValueTo(ColumnsMapping.this.options, resultSet, i, sqlType, setterType);
                    ColumnsMapping.this.setValue(ret, columnName, value);
                }
                return (S)ret;
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                throw new SormException("Container class for object relation mapping must have the public default constructor (with no arguments).", e);
            }
        }
    }

    private static abstract class PojoCreator<S> {
        protected final Constructor<S> constructor;

        public PojoCreator(Constructor<S> constructor) {
            this.constructor = constructor;
        }

        abstract List<S> loadPojoList(ResultSet var1, List<String> var2) throws SQLException;

        abstract S loadPojo(ResultSet var1, List<String> var2) throws SQLException;
    }
}

