/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql.schema;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SqlExecutor;
import org.nkjmlab.sorm4j.annotation.Experimental;

@Experimental
public class TableSchema {
    private final String tableName;
    private final String tableSchema;
    private final List<String> columnNames;
    private final String createTableStatement;
    private final String dropTableStatement;
    private final List<String> createIndexStatements;

    private TableSchema(Builder builder) {
        this.tableName = builder.tableName;
        this.tableSchema = builder.getTableSchema();
        this.createTableStatement = "create table if not exists " + this.tableSchema;
        this.dropTableStatement = "drop table if exists " + this.tableName;
        this.columnNames = builder.getColumunNames();
        this.createIndexStatements = builder.getCreateIndexIfNotExistsStatements();
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getCreateIndexIfNotExistsStatements() {
        return this.createIndexStatements;
    }

    public String getCreateTableIfNotExistsStatement() {
        return this.createTableStatement;
    }

    public String getDropTableIfExistsStatement() {
        return this.dropTableStatement;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String tableName) {
        return new Builder(tableName);
    }

    public void createTableAndIndexesIfNotExists(SqlExecutor sqlExecutor) {
        this.createTableIfNotExists(sqlExecutor);
        this.createIndexesIfNotExists(sqlExecutor);
    }

    public void createTableIfNotExists(SqlExecutor sqlExecutor) {
        sqlExecutor.executeUpdate(this.getCreateTableIfNotExistsStatement(), new Object[0]);
    }

    public void createIndexesIfNotExists(SqlExecutor sqlExecutor) {
        this.getCreateIndexIfNotExistsStatements().forEach(s -> sqlExecutor.executeUpdate((String)s, new Object[0]));
    }

    public void dropTableIfExists(SqlExecutor sqlExecutor) {
        sqlExecutor.executeUpdate(this.getDropTableIfExistsStatement(), new Object[0]);
    }

    public static class Builder {
        private String tableName;
        private final Map<String, String[]> columnDefinitions = new LinkedHashMap<String, String[]>();
        private String[] primaryKeys;
        private final List<String[]> uniqueColumnPairs = new ArrayList<String[]>();
        private final List<String[]> indexColumns = new ArrayList<String[]>();

        private Builder() {
        }

        public Builder(String tableName) {
            this();
            this.tableName = tableName;
        }

        public TableSchema build() {
            return new TableSchema(this);
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder addColumnDefinition(String columnName, String ... dataTypeAndOptions) {
            this.columnDefinitions.put(columnName, dataTypeAndOptions);
            return this;
        }

        public Builder addIndexColumn(String ... indexColumnPair) {
            this.indexColumns.add(indexColumnPair);
            return this;
        }

        public Builder addUniqueConstraint(String ... uniqueColumnPair) {
            this.uniqueColumnPairs.add(uniqueColumnPair);
            return this;
        }

        public Builder setPrimaryKey(String ... attributes) {
            this.primaryKeys = attributes;
            return this;
        }

        private String getTableSchema() {
            return Builder.getTableSchema(this.tableName, this.columnDefinitions, this.primaryKeys, this.uniqueColumnPairs);
        }

        private List<String> getCreateIndexIfNotExistsStatements() {
            return this.indexColumns.stream().map(columns -> Builder.getCreateIndexOnStatement("index_" + this.tableName + "_" + String.join((CharSequence)"_", columns), this.tableName, columns)).collect(Collectors.toList());
        }

        private List<String> getColumunNames() {
            return Builder.getColumunNames(this.columnDefinitions);
        }

        private static String createPrimaryKeyConstraint(String[] primaryKeys) {
            if (primaryKeys == null || primaryKeys.length == 0) {
                return "";
            }
            return ", primary key(" + String.join((CharSequence)", ", primaryKeys) + ")";
        }

        private static String createUniqueConstraint(List<String[]> uniqueColumnPairs) {
            if (uniqueColumnPairs == null || uniqueColumnPairs.size() == 0) {
                return "";
            }
            return ", " + String.join((CharSequence)", ", (CharSequence[])uniqueColumnPairs.stream().map(u -> "unique(" + String.join((CharSequence)", ", u) + ")").toArray(String[]::new));
        }

        private static List<String> getColumunNames(Map<String, String[]> columnDefinitions) {
            return columnDefinitions.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        }

        private static List<String> getColumuns(Map<String, String[]> columnDefinisions) {
            return columnDefinisions.keySet().stream().map(columnName -> columnName + " " + String.join((CharSequence)" ", (CharSequence[])columnDefinisions.get(columnName))).collect(Collectors.toList());
        }

        private static String getCreateIndexOnStatement(String indexName, String tableName, String ... columns) {
            return "create index if not exists " + indexName + " on " + tableName + "(" + String.join((CharSequence)", ", columns) + ")";
        }

        private static String getTableSchema(String tableName, Map<String, String[]> columns, String[] primaryKeys, List<String[]> uniqueColumnPairs) {
            String schema = tableName + "(" + String.join((CharSequence)", ", Builder.getColumuns(columns)) + Builder.createPrimaryKeyConstraint(primaryKeys) + Builder.createUniqueConstraint(uniqueColumnPairs) + ")";
            return schema;
        }
    }
}

