/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.SormLogger;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SqlParameterSetter;
import org.nkjmlab.sorm4j.internal.mapping.AbstractOrmMapper;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.internal.mapping.InsertResultImpl;
import org.nkjmlab.sorm4j.internal.mapping.Mapping;
import org.nkjmlab.sorm4j.internal.mapping.TableMappingSql;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.LogPoint;
import org.nkjmlab.sorm4j.internal.util.LogPointFactory;
import org.nkjmlab.sorm4j.internal.util.LoggerFactory;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.sql.InsertResult;
import org.slf4j.Logger;

public final class TableMapping<T>
extends Mapping<T> {
    private static final Logger log = LoggerFactory.getLogger();
    private final Map<String, Class<?>> setterParameterTypeMap = new ConcurrentHashMap();
    private final SqlParameterSetter sqlParameterSetter;
    private final TableMappingSql sql;
    private final MultiRowProcessor<T> multiRowProcessor;
    private final Map<List<String>, Accessor[]> accessorsMap = new ConcurrentHashMap<List<String>, Accessor[]>();

    public TableMapping(ResultSetConverter resultSetConverter, Class<T> objectClass, ColumnToAccessorMap columnToAccessorMap, SqlParameterSetter sqlParameterSetter, MultiRowProcessorFactory multiRowProcessorFactory, TableMappingSql sql) {
        super(resultSetConverter, objectClass, columnToAccessorMap);
        this.sqlParameterSetter = sqlParameterSetter;
        this.sql = sql;
        MultiRowProcessor<?> processor = multiRowProcessorFactory.getMultiRowProcessor(this);
        this.multiRowProcessor = processor;
    }

    private Class<?> getSetterParamType(String column) {
        return this.setterParameterTypeMap.computeIfAbsent(column, k -> this.columnToAccessorMap.get(column).getSetterParameterType());
    }

    public TableMappingSql getSql() {
        return this.sql;
    }

    public Object[] getInsertParameters(T object) {
        return this.getParameters(object, this.sql.getNotAutoGeneratedColumns());
    }

    public Object[] getMergeParameters(T object) {
        return this.getParameters(object, this.sql.getNotAutoGeneratedColumns());
    }

    private Object[] getParametersWithoutAutoGeneratedColumns(T object) {
        return this.getParameters(object, this.sql.getNotAutoGeneratedColumns());
    }

    private Object[] getDeleteParameters(T object) {
        return this.getParameters(object, this.sql.getPrimaryKeys());
    }

    private Object[] getUpdateParameters(T object) {
        return this.getParameters(object, this.sql.getColumnsForUpdate());
    }

    public Object[] getParameters(Object object, List<String> columns) {
        if (object == null) {
            throw new SormException(StringUtils.format("Fail to get value from a instance of [{}] but it is null.", this.getObjectClass()));
        }
        Accessor[] accessors = this.accessorsMap.computeIfAbsent(columns, k -> (Accessor[])columns.stream().map(columnName -> this.getAccessor(object, (String)columnName)).toArray(Accessor[]::new));
        Object[] ret = new Object[accessors.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getValue(object, accessors[i]);
        }
        return ret;
    }

    private List<Object> setAutoGeneratedKeys(PreparedStatement stmt, T object) throws SQLException {
        try (ResultSet resultSet = stmt.getGeneratedKeys();){
            ResultSetMetaData metaData = resultSet.getMetaData();
            ArrayList<Object> ret = new ArrayList<Object>();
            while (resultSet.next()) {
                String columnName = metaData.getColumnName(1);
                Class<?> classType = this.getSetterParamType(columnName);
                Object value = this.resultSetConverter.getValueBySetterParameterType(resultSet, 1, classType);
                this.setValue(object, columnName, value);
                ret.add(value);
            }
            ArrayList<Object> arrayList = ret;
            return arrayList;
        }
    }

    @SafeVarargs
    public final void setPrameters(PreparedStatement stmt, T ... objects) throws SQLException, IOException {
        Object[] parameters = Arrays.stream(objects).flatMap(obj -> Arrays.stream(this.getParametersWithoutAutoGeneratedColumns(obj))).toArray(Object[]::new);
        this.sqlParameterSetter.setParameters(stmt, parameters);
    }

    private int executeUpdate(Connection connection, String sql, Object ... parameters) {
        Optional<LogPoint> dp = LogPointFactory.createLogPoint(SormLogger.Category.EXECUTE_UPDATE);
        dp.ifPresent(lp -> log.debug("[{}] [{}] with {} parameters", new Object[]{lp.getTag(), sql, parameters == null ? 0 : parameters.length}));
        int ret = AbstractOrmMapper.execPreparedStatementAndClose(this.sqlParameterSetter, connection, sql, parameters, stmt -> stmt.executeUpdate());
        dp.ifPresent(lp -> {
            log.trace("[{}] Parameters = {}", (Object)lp.getTag(), (Object)parameters);
            log.debug("{} Call executeUpdate for [{}] to [{}] Table at [{}]", new Object[]{lp.getTagAndElapsedTime(), this.getObjectClass().getSimpleName(), this.getTableName(), Try.getOrNull(() -> connection.getMetaData().getURL()), sql});
        });
        return ret;
    }

    public int update(Connection connection, T object) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.executeUpdate(connection, this.getSql().getUpdateSql(), this.getUpdateParameters(object));
    }

    public void throwExeptionIfPrimaryKeysIsNotExist() {
        if (!this.sql.hasPrimaryKey()) {
            throw new SormException("This opperation requiers primary keys but Table [" + this.getTableName() + "] doesn't have them.");
        }
    }

    public void throwExeptionIfAutoGeneratedColumnsExist() {
        if (this.sql.hasAutoGeneratedColumns()) {
            throw new SormException("This opperation requiers no autogenerated columns but Table [" + this.getTableName() + "] has them.");
        }
    }

    public int[] update(Connection connection, T ... objects) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.batch(connection, this.sql.getUpdateSql(), obj -> this.getUpdateParameters(obj), objects);
    }

    public int delete(Connection connection, T object) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.executeUpdate(connection, this.getSql().getDeleteSql(), this.getDeleteParameters(object));
    }

    public int[] delete(Connection connection, T ... objects) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.batch(connection, this.sql.getDeleteSql(), obj -> this.getDeleteParameters(obj), objects);
    }

    public int deleteAll(Connection connection) {
        return this.executeUpdate(connection, this.sql.getDeleteAllSql(), new Object[0]);
    }

    public int insert(Connection connection, T object) {
        return this.executeUpdate(connection, this.sql.getInsertSql(), this.getInsertParameters(object));
    }

    public int merge(Connection connection, T object) {
        this.throwExeptionIfAutoGeneratedColumnsExist();
        return this.executeUpdate(connection, this.sql.getMergeSql(), this.getMergeParameters(object));
    }

    public InsertResult<T> insertAndGet(Connection connection, T object) {
        InsertResultImpl<T> insertResultImpl;
        block8: {
            String insertSql = this.sql.getInsertSql();
            Optional<LogPoint> dp = LogPointFactory.createLogPoint(SormLogger.Category.EXECUTE_UPDATE);
            dp.ifPresent(lp -> log.debug("[{}] [{}]", (Object)lp.getTag(), (Object)insertSql));
            PreparedStatement stmt = !this.sql.hasAutoGeneratedColumns() ? connection.prepareStatement(insertSql) : connection.prepareStatement(insertSql, this.sql.getAutoGeneratedColumnsArray());
            try {
                this.sqlParameterSetter.setParameters(stmt, this.getInsertParameters(object));
                int rowsModified = stmt.executeUpdate();
                List<Object> keys = this.setAutoGeneratedKeys(stmt, object);
                dp.ifPresent(lp -> {
                    log.trace("[{}] Parameter = {}", (Object)lp.getTag(), object);
                    log.debug("{} Call executeUpdate for [{}] to [{}] Table at [{}]", new Object[]{lp.getTagAndElapsedTime(), this.getObjectClass().getSimpleName(), this.getTableName(), Try.getOrNull(() -> connection.getMetaData().getURL()), insertSql});
                });
                insertResultImpl = new InsertResultImpl<T>(new int[]{rowsModified}, object, keys);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            stmt.close();
        }
        return insertResultImpl;
    }

    @SafeVarargs
    public final int[] insert(Connection con, T ... objects) {
        return this.multiRowProcessor.multiRowInsert(con, objects);
    }

    @SafeVarargs
    public final InsertResult<T> insertAndGet(Connection con, T ... objects) {
        T[] objsWithoutLast = Arrays.asList(objects).subList(0, objects.length - 1).toArray(Object[]::new);
        T last = objects[objects.length - 1];
        int[] resultWithoutLast = this.insert(con, objsWithoutLast);
        InsertResult<T> insertResult = this.insertAndGet(con, last);
        int[] result = ArrayUtils.add(resultWithoutLast, insertResult.getRowsModified()[0]);
        return new InsertResultImpl<T>(result, insertResult.getObject(), insertResult.getAutoGeneratedKeys());
    }

    public int[] batch(Connection con, String sql, Function<T, Object[]> parameterCreator, T[] objects) {
        return this.multiRowProcessor.batch(con, sql, parameterCreator, objects);
    }

    public int[] merge(Connection con, T ... objects) {
        this.throwExeptionIfAutoGeneratedColumnsExist();
        int[] result = this.multiRowProcessor.multiRowMerge(con, objects);
        return result;
    }

    public String getFormattedString() {
        return "[" + TableMapping.class.getSimpleName() + "] TABLE [" + this.getTableName() + "] is mapped to [" + this.getObjectClass().getSimpleName() + "] class. PRIMARY KEY is " + this.sql.getPrimaryKeys() + System.lineSeparator() + super.getColumnToAccessorString() + System.lineSeparator() + "[" + this.multiRowProcessor.getClass().getSimpleName() + "] is used for processing multirow.";
    }

    public String getTableName() {
        return this.sql.getTableName();
    }
}

