/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nkjmlab.sorm4j.internal.util.SqlUtils;
import org.nkjmlab.sorm4j.sql.SqlStatement;

public final class SqlStatementImpl
implements SqlStatement {
    private final String sql;
    private final Object[] parameters;
    private static final char LIST_PLACEHOLDER_PREFIX = '<';
    private static final char LIST_PLACEHOLDER_SUFFIX = '>';
    private static final String LIST_PLACEHOLDER = "<?>";
    private static final char EMBEDDED_PLACEHOLDER_PREFIX = '$';
    private static final char EMBEDDED_PLACEHOLDER_SUFFIX = '$';
    private static final String EMBEDDED_PLACEHOLDER = "$?$";

    private SqlStatementImpl(String sql, Object ... parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public String toString() {
        return "sql=[" + this.sql + "]" + (String)(this.parameters == null || this.parameters.length == 0 ? "" : ", parameters=" + Arrays.toString(this.parameters));
    }

    @Override
    public final String getSql() {
        return this.sql;
    }

    @Override
    public final Object[] getParameters() {
        return this.parameters;
    }

    public static SqlStatement from(String sql, Object ... parameters) {
        SqlStatementImpl st = new SqlStatementImpl(sql, parameters);
        if (parameters.length == 0) {
            return st;
        }
        st = sql.contains(LIST_PLACEHOLDER) ? SqlStatementImpl.procListPlaceholder(sql, parameters) : st;
        st = sql.contains(EMBEDDED_PLACEHOLDER) ? SqlStatementImpl.procEmbeddedPlaceholder(st.getSql(), st.getParameters()) : st;
        return st;
    }

    private static SqlStatement procListPlaceholder(String sql, Object[] parameters) {
        List parameter;
        char[] arry = sql.toCharArray();
        ArrayList<Integer> listParametersIndexs = new ArrayList<Integer>();
        int parameterIndex = 0;
        for (int i = 0; i < arry.length; ++i) {
            char c = arry[i];
            if (c == '?' && i - 1 >= 0 && arry[i - 1] == '<' && i + 1 < arry.length && arry[i + 1] == '>') {
                listParametersIndexs.add(parameterIndex);
                ++parameterIndex;
                continue;
            }
            if (c != '?') continue;
            ++parameterIndex;
        }
        Object expanddedSql = sql;
        for (int i = 0; i < listParametersIndexs.size(); ++i) {
            int index = ((String)expanddedSql).indexOf(LIST_PLACEHOLDER);
            parameter = (List)parameters[(Integer)listParametersIndexs.get(i)];
            expanddedSql = ((String)expanddedSql).subSequence(0, index) + "?,".repeat(parameter.size()).substring(0, 2 * parameter.size() - 1) + ((String)expanddedSql).substring(index + 3, ((String)expanddedSql).length());
        }
        ArrayList<Object> afterEmbeddedParams = new ArrayList<Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (listParametersIndexs.contains(i)) {
                parameter = (List)parameters[i];
                parameter.forEach(p -> afterEmbeddedParams.add(p));
                continue;
            }
            afterEmbeddedParams.add(parameters[i]);
        }
        return new SqlStatementImpl((String)expanddedSql, afterEmbeddedParams.toArray());
    }

    private static SqlStatement procEmbeddedPlaceholder(String sql, Object[] parameters) {
        char[] arry = sql.toCharArray();
        ArrayList<Integer> embeddedParametersIndexs = new ArrayList<Integer>();
        int parameterIndex = 0;
        for (int i = 0; i < arry.length; ++i) {
            char c = arry[i];
            if (c == '?' && i - 1 >= 0 && arry[i - 1] == '$' && i + 1 < arry.length && arry[i + 1] == '$') {
                embeddedParametersIndexs.add(parameterIndex);
                ++parameterIndex;
                continue;
            }
            if (c != '?') continue;
            ++parameterIndex;
        }
        Object embeddedSql = sql;
        for (int i = 0; i < embeddedParametersIndexs.size(); ++i) {
            int index = ((String)embeddedSql).indexOf(EMBEDDED_PLACEHOLDER);
            embeddedSql = ((String)embeddedSql).subSequence(0, index) + SqlUtils.literal(parameters[(Integer)embeddedParametersIndexs.get(i)]) + ((String)embeddedSql).substring(index + 3, ((String)embeddedSql).length());
        }
        ArrayList<Object> afterEmbeddedParams = new ArrayList<Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (embeddedParametersIndexs.contains(i)) continue;
            afterEmbeddedParams.add(parameters[i]);
        }
        return new SqlStatementImpl((String)embeddedSql, afterEmbeddedParams.toArray());
    }
}

