/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.List;

public final class SqlUtils {
    private SqlUtils() {
    }

    public static String quote(String str) {
        return SqlUtils.wrapSingleQuote(SqlUtils.escapeSingleQuote(str));
    }

    private static String escapeSingleQuote(String str) {
        return str.contains("'") ? str.replaceAll("'", "''") : str;
    }

    private static String wrapSingleQuote(String str) {
        return "'" + str + "'";
    }

    public static String literal(Object element) {
        String str;
        if (element == null) {
            return "null";
        }
        if (element instanceof Number || element instanceof Boolean) {
            return element.toString();
        }
        if (element instanceof List) {
            return String.join((CharSequence)", ", (CharSequence[])((List)element).stream().map(e -> SqlUtils.literal(e)).toArray(String[]::new));
        }
        switch (str = element.toString()) {
            case "?": {
                return str;
            }
        }
        return SqlUtils.quote(str);
    }
}

