/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.logger;

import org.nkjmlab.sorm4j.extension.logger.AbstractSormLogger;
import org.nkjmlab.sorm4j.extension.logger.SormLogger;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jSormLogger
extends AbstractSormLogger
implements SormLogger {
    public static final boolean enableLogger = Slf4jSormLogger.isEnable();
    private final Logger logger;

    private static boolean isEnable() {
        return Try.getOrDefault(() -> {
            Class.forName("org.slf4j.Logger");
            return true;
        }, false);
    }

    private Slf4jSormLogger(Logger logger) {
        this.logger = logger;
    }

    public static SormLogger getLogger() {
        if (!enableLogger) {
            System.err.println("sorm4j: [org.slf4j.Logger] is not found at the classpath. If you want to use SLF4J, you should add SLF4J logger at the classpath.");
        }
        return new Slf4jSormLogger(LoggerFactory.getLogger(Slf4jSormLogger.class));
    }

    @Override
    public void trace(String format, Object ... params) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(format, params);
        }
    }

    @Override
    public void debug(String format, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(format, params);
        }
    }

    @Override
    public void info(String format, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(format, params);
        }
    }

    @Override
    public void warn(String format, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(format, params);
        }
    }

    @Override
    public void error(String format, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(format, params);
        }
    }
}

