/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.extension.ColumnNameWithMetaData;
import org.nkjmlab.sorm4j.sql.TableMetaData;

public class TableMetaDataImpl
implements TableMetaData {
    private final String tableName;
    private final List<String> columns;
    private final List<String> primaryKeys;
    private final List<String> autoGeneratedColumns;
    private final boolean hasPrimaryKey;
    private final boolean hasAutoGeneratedColumns;
    private final List<String> notAutoGeneratedColumns;
    private final List<String> columnsForUpdate;
    private final String[] autoGeneratedColumnsArray;
    private final List<String> notPrimaryKeys;
    private final String columnsWithAliasPrefix;
    private final List<ColumnNameWithMetaData> columnsWithMetaData;

    public TableMetaDataImpl(String tableName, String tableNameAliasPrefix, List<ColumnNameWithMetaData> columnsWithMetaData, List<String> primaryKeys, List<String> autoGeneratedColumns) {
        this.tableName = tableName;
        this.columnsWithMetaData = columnsWithMetaData;
        this.columns = Collections.unmodifiableList(columnsWithMetaData.stream().map(c -> c.getName()).collect(Collectors.toList()));
        this.primaryKeys = Collections.unmodifiableList(primaryKeys);
        this.autoGeneratedColumns = Collections.unmodifiableList(autoGeneratedColumns);
        this.notAutoGeneratedColumns = Collections.unmodifiableList(this.columns.stream().filter(col -> !autoGeneratedColumns.contains(col)).collect(Collectors.toList()));
        this.hasPrimaryKey = primaryKeys.size() != 0;
        this.hasAutoGeneratedColumns = autoGeneratedColumns.size() != 0;
        this.autoGeneratedColumnsArray = (String[])autoGeneratedColumns.toArray(String[]::new);
        this.notPrimaryKeys = this.columns.stream().filter(col -> !primaryKeys.contains(col)).collect(Collectors.toList());
        this.columnsForUpdate = Stream.concat(this.notPrimaryKeys.stream(), primaryKeys.stream()).collect(Collectors.toList());
        this.columnsWithAliasPrefix = String.join((CharSequence)", ", (CharSequence[])this.columns.stream().map(col -> tableName + "." + col + " as " + tableNameAliasPrefix + col).toArray(String[]::new));
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public List<String> getAutoGeneratedColumns() {
        return this.autoGeneratedColumns;
    }

    @Override
    public boolean hasPrimaryKey() {
        return this.hasPrimaryKey;
    }

    @Override
    public boolean hasAutoGeneratedColumns() {
        return this.hasAutoGeneratedColumns;
    }

    @Override
    public List<String> getNotAutoGeneratedColumns() {
        return this.notAutoGeneratedColumns;
    }

    @Override
    public List<String> getColumnsForUpdate() {
        return this.columnsForUpdate;
    }

    @Override
    public String[] getAutoGeneratedColumnsArray() {
        return this.autoGeneratedColumnsArray;
    }

    @Override
    public List<String> getNotPrimaryKeys() {
        return this.notPrimaryKeys;
    }

    @Override
    public String getColumnAliases() {
        return this.columnsWithAliasPrefix;
    }

    @Override
    public List<ColumnNameWithMetaData> getColumnsWithMetaData() {
        return this.columnsWithMetaData;
    }
}

