package org.nkjmlab.sorm4j.sql;

import java.util.List;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.annotation.OrmColumnAliasPrefix;
import org.nkjmlab.sorm4j.extension.ColumnNameWithMetaData;

@Experimental
public interface TableMetaData {

  String getTableName();

  List<String> getAutoGeneratedColumns();

  List<String> getColumns();

  List<String> getPrimaryKeys();

  List<String> getNotAutoGeneratedColumns();

  boolean hasPrimaryKey();

  boolean hasAutoGeneratedColumns();

  String[] getAutoGeneratedColumnsArray();

  List<String> getColumnsForUpdate();

  List<String> getNotPrimaryKeys();


  /**
   * <p>
   * Creates a string of column aliases.
   * <p>
   * For example, if the "customer" table has "id" and "name" columns, and
   * {@link OrmColumnAliasPrefix} is "c" returns
   * <code>"customer.id as cid, customer.name as cname"</code>.
   *
   * @return column aliases (e.g. <code>"customer.id as cid, customer.name as cname"</code>)
   */

  String getColumnAliases();

  List<ColumnNameWithMetaData> getColumnsWithMetaData();

}
