/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.logger;

import java.sql.Connection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.extension.logger.JulSormLogger;
import org.nkjmlab.sorm4j.extension.logger.Log4jSormLogger;
import org.nkjmlab.sorm4j.extension.logger.Slf4jSormLogger;
import org.nkjmlab.sorm4j.extension.logger.SormLogger;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;

public final class LoggerContext {
    private final Set<Category> onCategories;
    private final Supplier<SormLogger> loggerSupplier;
    @Experimental
    public volatile boolean forceLogging = false;
    private final Map<String, SormLogger> loggers = new ConcurrentHashMap<String, SormLogger>();

    public SormLogger getLogger() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        String className = stackTrace[1].getClassName();
        return this.loggers.computeIfAbsent(className, k -> this.loggerSupplier.get());
    }

    public LoggerContext(Supplier<SormLogger> loggerSupplier, Set<Category> onCategories) {
        this.loggerSupplier = loggerSupplier;
        this.onCategories = onCategories;
    }

    @Experimental
    public Optional<LogPoint> createLogPoint(Category category) {
        return this.isLogging(category) ? Optional.of(new LogPoint(category.name(), this.getLogger())) : Optional.empty();
    }

    private boolean isLogging(Category category) {
        return this.forceLogging || this.onCategories.contains((Object)category);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "LoggerContext [onCategories=" + this.onCategories + ", logger=" + this.getLogger() + "]";
    }

    public static enum Category {
        MAPPING,
        EXECUTE_QUERY,
        MULTI_ROW,
        EXECUTE_UPDATE,
        HANDLE_PREPAREDSTATEMENT;

    }

    @Experimental
    public static final class LogPoint {
        private final String name;
        private final SormLogger logger;
        private long startTime;

        private LogPoint(String name, SormLogger logger) {
            this.name = name;
            this.logger = logger;
        }

        public String getTag() {
            return this.name + ":" + this.hashCode() / 10000;
        }

        public void logBeforeSql(Connection connection, String sql, Object ... parameters) {
            this.logger.logBeforeSql(this.getTag(), connection, sql, parameters);
            this.startTime = System.nanoTime();
        }

        public void logBeforeSql(Connection connection, ParameterizedSql sql) {
            this.logger.logBeforeSql(this.getTag(), connection, sql);
            this.startTime = System.nanoTime();
        }

        public void logBeforeMultiRow(Connection con, Class<?> objectClass, int length, String tableName) {
            this.logger.logBeforeMultiRow(this.getTag(), con, objectClass, length, tableName);
            this.startTime = System.nanoTime();
        }

        public void logAfterQuery(Object ret) {
            this.logger.logAfterQuery(this.getTag(), this.getElapsedTime(), ret);
        }

        public void logAfterMultiRow(int[] result) {
            this.logger.logAfterMultiRow(this.name, this.getElapsedTime(), result);
        }

        private long getElapsedTime() {
            return System.nanoTime() - this.startTime;
        }

        public void logAfterUpdate(int ret) {
            this.logger.logAfterUpdate(this.name, this.getElapsedTime(), ret);
        }

        public SormLogger getLogger() {
            return this.logger;
        }

        public void logMapping(String mappingInfo) {
            this.logger.logMapping(this.getTag(), mappingInfo);
        }
    }

    public static class Builder {
        private Supplier<SormLogger> loggerSupplier;
        private final Set<Category> onCategories = new HashSet<Category>();

        private Builder() {
        }

        public void setLoggerSupplier(Supplier<SormLogger> loggerSupplier) {
            this.loggerSupplier = loggerSupplier;
        }

        private static Supplier<SormLogger> getDefaultLoggerSupplier() {
            return Log4jSormLogger.enableLogger ? Log4jSormLogger::getLogger : (Slf4jSormLogger.enableLogger ? Slf4jSormLogger::getLogger : JulSormLogger::getLogger);
        }

        public LoggerContext build() {
            this.loggerSupplier = this.loggerSupplier != null ? this.loggerSupplier : Builder.getDefaultLoggerSupplier();
            return new LoggerContext(this.loggerSupplier, this.onCategories);
        }

        public void on(Category ... categories) {
            Arrays.stream(categories).forEach(name -> this.onCategories.add((Category)((Object)name)));
        }

        public void off(Category ... categories) {
            Arrays.stream(categories).forEach(name -> this.onCategories.remove(name));
        }

        public void onAll() {
            this.on(Category.values());
        }

        public void offAll() {
            this.off(Category.values());
        }
    }
}

