/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.nkjmlab.sorm4j.ConsumerHandler;
import org.nkjmlab.sorm4j.FunctionHandler;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.ResultSetTraverser;
import org.nkjmlab.sorm4j.RowMapper;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormContext;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.logger.LoggerContext;
import org.nkjmlab.sorm4j.internal.mapping.ColumnsMapping;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;
import org.nkjmlab.sorm4j.internal.sql.result.InsertResultImpl;
import org.nkjmlab.sorm4j.internal.sql.result.LazyResultSetImpl;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.sql.BasicCommand;
import org.nkjmlab.sorm4j.sql.Command;
import org.nkjmlab.sorm4j.sql.NamedParameterCommand;
import org.nkjmlab.sorm4j.sql.OrderedParameterCommand;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;
import org.nkjmlab.sorm4j.sql.TableMetaData;
import org.nkjmlab.sorm4j.sql.result.InsertResult;
import org.nkjmlab.sorm4j.sql.result.LazyResultSet;
import org.nkjmlab.sorm4j.sql.result.Tuple2;
import org.nkjmlab.sorm4j.sql.result.Tuple3;
import org.nkjmlab.sorm4j.sql.result.Tuples;

public class OrmConnectionImpl
implements OrmConnection {
    private final SormContext sormContext;
    private final Connection connection;
    private final List<LazyResultSet<?>> lazyResultSets = new ArrayList();

    public OrmConnectionImpl(Connection connection, SormContext sormContext) {
        this.connection = connection;
        this.sormContext = sormContext;
    }

    @Override
    public void acceptPreparedStatementHandler(ParameterizedSql sql, ConsumerHandler<PreparedStatement> handler) {
        try (PreparedStatement stmt = this.connection.prepareStatement(sql.getSql());){
            this.getSqlParametersSetter().setParameters(this.sormContext.getOptions(), stmt, sql.getParameters());
            handler.accept(stmt);
            this.getLoggerConfig().createLogPoint(LoggerContext.Category.HANDLE_PREPAREDSTATEMENT).ifPresent(_lp -> _lp.logBeforeSql(this.connection, sql));
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    private LoggerContext getLoggerConfig() {
        return this.sormContext.getLoggerContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T applyPreparedStatementHandler(ParameterizedSql sql, FunctionHandler<PreparedStatement, T> handler) {
        try (PreparedStatement stmt = this.connection.prepareStatement(sql.getSql());){
            PreparedStatement ret;
            this.getSqlParametersSetter().setParameters(this.sormContext.getOptions(), stmt, sql.getParameters());
            this.getLoggerConfig().createLogPoint(LoggerContext.Category.HANDLE_PREPAREDSTATEMENT).ifPresent(_lp -> _lp.logBeforeSql(this.connection, sql));
            PreparedStatement t = ret = handler.apply(stmt);
            return (T)t;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public void begin() {
        this.begin(this.getTransactionIsolationLevel());
    }

    @Override
    public void begin(int isolationLevel) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(isolationLevel);
    }

    @Override
    public void close() {
        Try.runOrThrow(() -> {
            this.lazyResultSets.forEach(rs -> rs.close());
            this.lazyResultSets.clear();
            this.getJdbcConnection().close();
        }, Try::rethrow);
    }

    @Override
    public void commit() {
        Try.runOrThrow(() -> this.getJdbcConnection().commit(), Try::rethrow);
    }

    @Override
    public Command createCommand(ParameterizedSql sql) {
        return BasicCommand.from(this, sql.getSql()).addParameter(sql.getParameters());
    }

    @Override
    public BasicCommand createCommand(String sql) {
        return BasicCommand.from(this, sql);
    }

    @Override
    public NamedParameterCommand createCommand(String sql, Map<String, Object> parameters) {
        return NamedParameterCommand.from(this, sql).bindAll((Map)parameters);
    }

    @Override
    public OrderedParameterCommand createCommand(String sql, Object ... parameters) {
        return OrderedParameterCommand.from(this, sql).addParameter(parameters);
    }

    @Override
    public <T> int[] delete(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.delete((T)array));
    }

    @Override
    public <T> int delete(T object) {
        return this.getCastedTableMapping(object.getClass()).delete(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] delete(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.delete(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> int deleteAll(Class<T> objectClass) {
        return this.deleteAllOn(this.getTableName(objectClass));
    }

    @Override
    public int deleteAllOn(String tableName) {
        return this.executeUpdate("DELETE FROM " + tableName, new Object[0]);
    }

    @Override
    public <T> int[] deleteOn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.deleteOn(tableName, (T)array));
    }

    @Override
    public <T> int deleteOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).delete(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] deleteOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.delete(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    private final <T, R> R execSqlIfParameterExists(String tableName, T[] objects, Function<TableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        TableMapping<T> mapping = this.getCastedTableMapping(tableName, objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    private final <T, R> R execSqlIfParameterExists(T[] objects, Function<TableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        TableMapping<T> mapping = this.getCastedTableMapping(objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    @Override
    public <T> T executeQuery(ParameterizedSql sql, ResultSetTraverser<T> resultSetTraverser) {
        return OrmConnectionImpl.executeQueryAndRead(this.getLoggerConfig(), this.sormContext.getOptions(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql.getSql(), sql.getParameters(), resultSetTraverser);
    }

    @Override
    public <T> List<T> executeQuery(ParameterizedSql sql, RowMapper<T> rowMapper) {
        return this.executeQuery(sql, ResultSetTraverser.from(rowMapper));
    }

    @Override
    public int executeUpdate(ParameterizedSql sql) {
        return this.executeUpdate(sql.getSql(), sql.getParameters());
    }

    @Override
    public int executeUpdate(String sql, Object ... parameters) {
        int ret = OrmConnectionImpl.executeUpdateAndClose(this.getLoggerConfig(), this.sormContext.getOptions(), this.connection, this.getSqlParametersSetter(), sql, parameters);
        return ret;
    }

    @Override
    public <T> boolean exists(T object) {
        TableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        mapping.throwExeptionIfPrimaryKeysIsNotExist();
        String sql = mapping.getSql().getExistsSql();
        return this.readFirst(Integer.class, sql, mapping.getPrimaryKeyParameters(object)) != null;
    }

    private <T> TableMapping<T> getCastedTableMapping(Class<?> objectClass) {
        return this.sormContext.getCastedTableMapping(this.connection, objectClass);
    }

    private <T> TableMapping<T> getCastedTableMapping(String tableName, Class<?> objectClass) {
        return this.sormContext.getCastedTableMapping(this.connection, tableName, objectClass);
    }

    <T> ColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        return this.sormContext.getColumnsMapping(objectClass);
    }

    @Override
    public Connection getJdbcConnection() {
        return this.connection;
    }

    private int getOneSqlType(Class<?> objectClass, ResultSet resultSet) {
        return Try.getOrThrow(() -> {
            ResultSetMetaData metaData = resultSet.getMetaData();
            if (metaData.getColumnCount() != 1) {
                throw new SormException("ResultSet returned [" + metaData.getColumnCount() + "] columns but 1 column was expected to load data into an instance of [" + objectClass.getName() + "]");
            }
            return metaData.getColumnType(1);
        }, Try::rethrow);
    }

    private ResultSetConverter getResultSetConverter() {
        return this.sormContext.getResultSetConverter();
    }

    @Override
    public ResultSetTraverser<List<Map<String, Object>>> getResultSetToMapTraverser() {
        return resultSet -> this.traverseAndMapToMapList(resultSet);
    }

    @Override
    public <T> ResultSetTraverser<List<T>> getResultSetTraverser(Class<T> objectClass) {
        return resultSet -> this.traverseAndMapToList(objectClass, resultSet);
    }

    @Override
    public <T> RowMapper<T> getRowMapper(Class<T> objectClass) {
        return (resultSet, rowNum) -> this.mapRowToObject(objectClass, resultSet);
    }

    @Override
    public RowMapper<Map<String, Object>> getRowToMapMapper() {
        return (resultSet, rowNum) -> this.mapRowToMap(resultSet);
    }

    private SqlParametersSetter getSqlParametersSetter() {
        return this.sormContext.getSqlParametersSetter();
    }

    public <T> TableMapping<T> getTableMapping(Class<T> objectClass) {
        return this.sormContext.getTableMapping(this.connection, objectClass);
    }

    @Override
    public TableMetaData getTableMetaData(Class<?> objectClass) {
        return this.getTableMapping(objectClass).getTableMetaData();
    }

    @Override
    public TableMetaData getTableMetaData(Class<?> objectClass, String tableName) {
        return this.sormContext.getTableMapping(this.connection, tableName, objectClass).getTableMetaData();
    }

    @Override
    public String getTableName(Class<?> objectClass) {
        return this.sormContext.getTableName(this.connection, objectClass);
    }

    private int getTransactionIsolationLevel() {
        return this.sormContext.getTransactionIsolationLevel();
    }

    @Override
    public <T> int[] insert(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insert((T)array));
    }

    @Override
    public <T> int insert(T object) {
        return this.getCastedTableMapping(object.getClass()).insert(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] insert(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.insert(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> InsertResult<T> insertAndGet(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insertAndGet((T)array));
    }

    @Override
    public <T> InsertResult<T> insertAndGet(T object) {
        TableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        return mapping.insertAndGet(this.getJdbcConnection(), object);
    }

    @Override
    public <T> InsertResult<T> insertAndGet(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.insertAndGet(this.getJdbcConnection(), objects), () -> InsertResultImpl.emptyInsertResult());
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insertAndGetOn(tableName, (T)array));
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, T object) {
        TableMapping<T> mapping = this.getCastedTableMapping(tableName, object.getClass());
        return mapping.insertAndGet(this.getJdbcConnection(), object);
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.insertAndGet(this.getJdbcConnection(), objects), () -> InsertResultImpl.emptyInsertResult());
    }

    @Override
    public <T> int[] insertOn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insertOn(tableName, (T)array));
    }

    @Override
    public <T> int insertOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).insert(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] insertOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.insert(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    public <T> T loadFirst(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return this.mapRowToObject(objectClass, resultSet);
        }
        return null;
    }

    public Map<String, Object> loadFirstMap(ResultSet resultSet) throws SQLException {
        Map<String, Object> ret = null;
        if (resultSet.next()) {
            ret = this.mapRowToMap(resultSet);
        }
        return ret;
    }

    private final <T> List<T> loadNativeObjectList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        ArrayList<T> ret = new ArrayList<T>();
        int sqlType = this.getOneSqlType(objectClass, resultSet);
        while (resultSet.next()) {
            ret.add(this.getResultSetConverter().toSingleStandardObject(this.sormContext.getOptions(), resultSet, sqlType, objectClass));
        }
        return ret;
    }

    public <T> T loadOne(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        T ret = null;
        if (resultSet.next()) {
            ret = this.mapRowToObject(objectClass, resultSet);
        }
        if (resultSet.next()) {
            throw new SormException("Non-unique result returned");
        }
        return ret;
    }

    public Map<String, Object> loadOneMap(ResultSet resultSet) throws SQLException {
        Map<String, Object> ret = null;
        if (resultSet.next()) {
            ret = this.mapRowToMap(resultSet);
        }
        if (resultSet.next()) {
            throw new SormException("Non-unique result returned");
        }
        return ret;
    }

    public final <T> List<T> loadPojoList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        ColumnsMapping<T> mapping = this.getColumnsMapping(objectClass);
        return mapping.loadPojoList(resultSet);
    }

    private final <T> T loadSinglePojo(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        ColumnsMapping<T> mapping = this.getColumnsMapping(objectClass);
        return mapping.loadPojo(resultSet);
    }

    public Map<String, Object> mapRowToMap(ResultSet resultSet) {
        return Try.getOrThrow(() -> {
            ColumnsAndTypes ct = ColumnsAndTypes.createColumnsAndTypes(resultSet);
            return this.getResultSetConverter().toSingleMap(this.sormContext.getOptions(), resultSet, ct.getColumns(), ct.getColumnTypes());
        }, Try::rethrow);
    }

    public <T> T mapRowToObject(Class<T> objectClass, ResultSet resultSet) {
        return (T)Try.getOrThrow(() -> this.getResultSetConverter().isStandardClass(this.sormContext.getOptions(), objectClass) ? this.getResultSetConverter().toSingleStandardObject(this.sormContext.getOptions(), resultSet, this.getOneSqlType(objectClass, resultSet), objectClass) : this.loadSinglePojo(objectClass, resultSet), Try::rethrow);
    }

    @Override
    public <T> int[] merge(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.merge((T)array));
    }

    @Override
    public <T> int merge(T object) {
        return this.getCastedTableMapping(object.getClass()).merge(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] merge(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.merge(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> int[] mergeOn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.mergeOn(tableName, (T)array));
    }

    @Override
    public <T> int mergeOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).merge(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] mergeOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.merge(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public final <T> List<T> readAll(Class<T> objectClass) {
        return this.readList(objectClass, this.getCastedTableMapping(objectClass).getSql().getSelectAllSql(), new Object[0]);
    }

    @Override
    public <T> LazyResultSet<T> readAllLazy(Class<T> objectClass) {
        return this.readLazy(objectClass, this.getTableMapping(objectClass).getSql().getSelectAllSql(), new Object[0]);
    }

    @Override
    public <T> T readByPrimaryKey(Class<T> objectClass, Object ... primaryKeyValues) {
        TableMapping<T> mapping = this.getTableMapping(objectClass);
        mapping.throwExeptionIfPrimaryKeysIsNotExist();
        String sql = mapping.getSql().getSelectByPrimaryKeySql();
        return this.readFirst(objectClass, sql, primaryKeyValues);
    }

    @Override
    public <T> T readFirst(Class<T> objectClass, ParameterizedSql sql) {
        return this.readFirst(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> T readFirst(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)OrmConnectionImpl.executeQueryAndRead(this.getLoggerConfig(), this.sormContext.getOptions(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> this.loadFirst(objectClass, resultSet));
    }

    @Override
    public <T> LazyResultSet<T> readLazy(Class<T> objectClass, ParameterizedSql sql) {
        return this.readLazy(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> LazyResultSet<T> readLazy(Class<T> objectClass, String sql, Object ... parameters) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(sql);
            this.getSqlParametersSetter().setParameters(this.sormContext.getOptions(), stmt, parameters);
            this.getLoggerConfig().createLogPoint(LoggerContext.Category.EXECUTE_QUERY).ifPresent(_lp -> _lp.logBeforeSql(this.connection, sql, parameters));
            ResultSet resultSet = stmt.executeQuery();
            LazyResultSetImpl<T> ret = new LazyResultSetImpl<T>(this, objectClass, stmt, resultSet);
            this.lazyResultSets.add(ret);
            return ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public <T> List<T> readList(Class<T> objectClass, ParameterizedSql sql) {
        return this.readList(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> List<T> readList(Class<T> objectClass, String sql, Object ... parameters) {
        return OrmConnectionImpl.executeQueryAndRead(this.getLoggerConfig(), this.sormContext.getOptions(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> this.traverseAndMapToList(objectClass, resultSet));
    }

    @Override
    public Map<String, Object> readMapFirst(ParameterizedSql sql) {
        return this.readMapFirst(sql.getSql(), sql.getParameters());
    }

    @Override
    public Map<String, Object> readMapFirst(String sql, Object ... parameters) {
        return OrmConnectionImpl.executeQueryAndRead(this.getLoggerConfig(), this.sormContext.getOptions(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            ColumnsAndTypes ct = ColumnsAndTypes.createColumnsAndTypes(resultSet);
            if (resultSet.next()) {
                return this.getResultSetConverter().toSingleMap(this.sormContext.getOptions(), resultSet, ct.getColumns(), ct.getColumnTypes());
            }
            return null;
        });
    }

    @Override
    public LazyResultSet<Map<String, Object>> readMapLazy(ParameterizedSql sql) {
        return this.readMapLazy(sql.getSql(), sql.getParameters());
    }

    @Override
    public LazyResultSet<Map<String, Object>> readMapLazy(String sql, Object ... parameters) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(sql);
            this.getSqlParametersSetter().setParameters(this.sormContext.getOptions(), stmt, parameters);
            this.getLoggerConfig().createLogPoint(LoggerContext.Category.EXECUTE_QUERY).ifPresent(_lp -> _lp.logBeforeSql(this.connection, sql, parameters));
            ResultSet resultSet = stmt.executeQuery();
            LazyResultSetImpl<Map<String, Object>> ret = new LazyResultSetImpl<Map<String, Object>>(this, stmt, resultSet);
            return ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public List<Map<String, Object>> readMapList(ParameterizedSql sql) {
        return this.readMapList(sql.getSql(), sql.getParameters());
    }

    @Override
    public List<Map<String, Object>> readMapList(String sql, Object ... parameters) {
        return OrmConnectionImpl.executeQueryAndRead(this.getLoggerConfig(), this.sormContext.getOptions(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> this.traverseAndMapToMapList(resultSet));
    }

    @Override
    public Map<String, Object> readMapOne(ParameterizedSql sql) {
        return this.readMapOne(sql.getSql(), sql.getParameters());
    }

    @Override
    public Map<String, Object> readMapOne(String sql, Object ... parameters) {
        return OrmConnectionImpl.executeQueryAndRead(this.getLoggerConfig(), this.sormContext.getOptions(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            ColumnsAndTypes ct = ColumnsAndTypes.createColumnsAndTypes(resultSet);
            Map<String, Object> ret = null;
            if (resultSet.next()) {
                ret = this.getResultSetConverter().toSingleMap(this.sormContext.getOptions(), resultSet, ct.getColumns(), ct.getColumnTypes());
            }
            if (resultSet.next()) {
                throw new SormException("Non-unique result returned");
            }
            return ret;
        });
    }

    @Override
    public <T> T readOne(Class<T> objectClass, ParameterizedSql sql) {
        return this.readOne(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> T readOne(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)OrmConnectionImpl.executeQueryAndRead(this.getLoggerConfig(), this.sormContext.getOptions(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            Object ret = null;
            if (resultSet.next()) {
                ret = this.mapRowToObject(objectClass, resultSet);
            }
            if (resultSet.next()) {
                throw new SormException("Non-unique result returned");
            }
            return ret;
        });
    }

    @Override
    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> readTupleList(Class<T1> t1, Class<T2> t2, Class<T3> t3, ParameterizedSql sql) {
        return this.readTupleList(t1, t2, t3, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> readTupleList(Class<T1> t1, Class<T2> t2, Class<T3> t3, String sql, Object ... parameters) {
        List ret = OrmConnectionImpl.executeQueryAndRead(this.getLoggerConfig(), this.sormContext.getOptions(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            ArrayList ret1 = new ArrayList();
            while (resultSet.next()) {
                ret1.add(Tuples.of(this.loadSinglePojo(t1, resultSet), this.loadSinglePojo(t2, resultSet), this.loadSinglePojo(t3, resultSet)));
            }
            return ret1;
        });
        return ret;
    }

    @Override
    public <T1, T2> List<Tuple2<T1, T2>> readTupleList(Class<T1> t1, Class<T2> t2, ParameterizedSql sql) {
        return this.readTupleList(t1, t2, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T1, T2> List<Tuple2<T1, T2>> readTupleList(Class<T1> t1, Class<T2> t2, String sql, Object ... parameters) {
        List ret = OrmConnectionImpl.executeQueryAndRead(this.getLoggerConfig(), this.sormContext.getOptions(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            ArrayList ret1 = new ArrayList();
            while (resultSet.next()) {
                ret1.add(Tuples.of(this.loadSinglePojo(t1, resultSet), this.loadSinglePojo(t2, resultSet)));
            }
            return ret1;
        });
        return ret;
    }

    @Override
    public void rollback() {
        Try.runOrThrow(() -> this.getJdbcConnection().rollback(), Try::rethrow);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        Try.runOrThrow(() -> this.getJdbcConnection().setAutoCommit(autoCommit), Try::rethrow);
    }

    private void setTransactionIsolation(int isolationLevel) {
        Try.runOrThrow(() -> this.getJdbcConnection().setTransactionIsolation(isolationLevel), Try::rethrow);
    }

    public <T> List<T> traverseAndMapToList(Class<T> objectClass, ResultSet resultSet) {
        return Try.getOrThrow(() -> this.getResultSetConverter().isStandardClass(this.sormContext.getOptions(), objectClass) ? this.loadNativeObjectList(objectClass, resultSet) : this.loadPojoList(objectClass, resultSet), Try::rethrow);
    }

    public List<Map<String, Object>> traverseAndMapToMapList(ResultSet resultSet) {
        return Try.getOrThrow(() -> {
            ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
            ColumnsAndTypes ct = ColumnsAndTypes.createColumnsAndTypes(resultSet);
            while (resultSet.next()) {
                ret.add(this.getResultSetConverter().toSingleMap(this.sormContext.getOptions(), resultSet, ct.getColumns(), ct.getColumnTypes()));
            }
            return ret;
        }, Try::rethrow);
    }

    @Override
    public <T> int[] update(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.update((T)array));
    }

    @Override
    public <T> int update(T object) {
        return this.getCastedTableMapping(object.getClass()).update(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] update(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.update(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> int[] updateOn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.updateOn(tableName, (T)array));
    }

    @Override
    public <T> int updateOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).update(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] updateOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.update(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    private static <T, R> R applytoArray(List<T> objects, Function<T[], R> sqlFunc) {
        return sqlFunc.apply((T[][])objects.toArray(Object[]::new));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static <R> R executeQueryAndRead(LoggerContext loggerContext, SormOptions options, Connection connection, SqlParametersSetter sqlParametersSetter, String sql, Object[] parameters, ResultSetTraverser<R> resultSetTraverser) {
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            Object r;
            block14: {
                sqlParametersSetter.setParameters(options, stmt, parameters);
                Optional<LoggerContext.LogPoint> lp = loggerContext.createLogPoint(LoggerContext.Category.EXECUTE_QUERY);
                lp.ifPresent(_lp -> _lp.logBeforeSql(connection, sql, parameters));
                ResultSet resultSet = stmt.executeQuery();
                try {
                    Object ret = resultSetTraverser.traverseAndMap(resultSet);
                    lp.ifPresent(_lp -> _lp.logAfterQuery(ret));
                    r = ret;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    public static final int executeUpdateAndClose(LoggerContext loggerContext, SormOptions options, Connection connection, SqlParametersSetter sqlParametersSetter, String sql, Object[] parameters) {
        int n;
        block8: {
            Optional<LoggerContext.LogPoint> lp = loggerContext.createLogPoint(LoggerContext.Category.EXECUTE_UPDATE);
            lp.ifPresent(_lp -> _lp.logBeforeSql(connection, sql, parameters));
            PreparedStatement stmt = connection.prepareStatement(sql);
            try {
                sqlParametersSetter.setParameters(options, stmt, parameters);
                int ret = stmt.executeUpdate();
                lp.ifPresent(_lp -> _lp.logAfterUpdate(ret));
                n = ret;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            stmt.close();
        }
        return n;
    }

    private static class ColumnsAndTypes {
        private final List<String> columns;
        private final List<Integer> columnTypes;

        private ColumnsAndTypes(List<String> columns, List<Integer> columnTypes) {
            this.columns = columns;
            this.columnTypes = columnTypes;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<Integer> getColumnTypes() {
            return this.columnTypes;
        }

        static ColumnsAndTypes createColumnsAndTypes(ResultSet resultSet) throws SQLException {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int colNum = metaData.getColumnCount();
            ArrayList<String> columns = new ArrayList<String>(colNum);
            ArrayList<Integer> columnTypes = new ArrayList<Integer>(colNum);
            for (int i = 1; i <= colNum; ++i) {
                columns.add(metaData.getColumnLabel(i));
                columnTypes.add(metaData.getColumnType(i));
            }
            return new ColumnsAndTypes(columns, columnTypes);
        }
    }
}

