/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.internal.util.StringCache;

public final class ColumnToAccessorMap {
    private final Map<String, Accessor> columnToAccessorMap;
    private final Map<String, Accessor> aliasColumnToAccessorMap;
    private final String columnAliasPrefix;

    public ColumnToAccessorMap(Class<?> objectClass, Map<String, Accessor> columnToAccessorMap, String columnAliasPrefix, Map<String, Accessor> aliasColumnToAccessorMap) {
        this.columnToAccessorMap = columnToAccessorMap.entrySet().stream().collect(Collectors.toMap(e -> StringCache.toCanonicalCase((String)e.getKey()), e -> (Accessor)e.getValue()));
        this.columnAliasPrefix = columnAliasPrefix;
        this.aliasColumnToAccessorMap = aliasColumnToAccessorMap.entrySet().stream().collect(Collectors.toMap(e -> StringCache.toCanonicalCase((String)e.getKey()), e -> (Accessor)e.getValue()));
    }

    public ColumnToAccessorMap(Class<?> objectClass, Map<String, Accessor> columnToAccessorMap) {
        this(objectClass, columnToAccessorMap, "", Collections.emptyMap());
    }

    public Accessor get(String columnName) {
        String cn = StringCache.toCanonicalCase(columnName);
        Accessor ret = this.columnToAccessorMap.get(cn);
        return ret != null ? ret : this.aliasColumnToAccessorMap.get(cn);
    }

    public String toString() {
        String keySetString = this.columnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList()).toString();
        return "columns " + keySetString + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), this.columnToAccessorMap.keySet().stream().map(e -> "  Column " + e + " => " + this.columnToAccessorMap.get(e).getFormattedString()).collect(Collectors.toList())) + System.lineSeparator() + "  OrmColumnAliasPrefix is [" + this.columnAliasPrefix + "]" + (this.columnAliasPrefix.length() == 0 ? "" : System.lineSeparator()) + String.join((CharSequence)System.lineSeparator(), this.aliasColumnToAccessorMap.keySet().stream().map(e -> "  Column " + e + " => " + this.aliasColumnToAccessorMap.get(e).getFormattedString()).collect(Collectors.toList()));
    }

    public String getColumnAliasPrefix() {
        return this.columnAliasPrefix;
    }
}

