/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.TableSql;
import org.nkjmlab.sorm4j.extension.logger.LoggerContext;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.internal.mapping.Mapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.internal.sql.result.InsertResultImpl;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.sql.TableMetaData;
import org.nkjmlab.sorm4j.sql.result.InsertResult;

public final class TableMapping<T>
extends Mapping<T> {
    private final Map<List<String>, Accessor[]> accessorsMap = new ConcurrentHashMap<List<String>, Accessor[]>();
    private final Map<String, Class<?>> setterParameterTypeMap = new ConcurrentHashMap();
    private final SqlParametersSetter sqlParametersSetter;
    private final MultiRowProcessor<T> multiRowProcessor;
    private final TableMetaData tableMetaData;
    private final TableSql sql;
    private final LoggerContext loggerContext;

    public TableMapping(LoggerContext loggerContext, SormOptions options, ResultSetConverter resultSetConverter, SqlParametersSetter sqlParametersSetter, MultiRowProcessorFactory multiRowProcessorFactory, Class<T> objectClass, ColumnToAccessorMap columnToAccessorMap, TableMetaData tableMetaData, TableSql sql) {
        super(options, resultSetConverter, objectClass, columnToAccessorMap);
        this.loggerContext = loggerContext;
        this.tableMetaData = tableMetaData;
        this.sql = sql;
        this.sqlParametersSetter = sqlParametersSetter;
        MultiRowProcessor<?> processor = multiRowProcessorFactory.getMultiRowProcessor(this);
        this.multiRowProcessor = processor;
    }

    private Class<?> getSetterParamType(String column) {
        return this.setterParameterTypeMap.computeIfAbsent(column, k -> this.columnToAccessorMap.get(column).getSetterParameterType());
    }

    public TableSql getSql() {
        return this.sql;
    }

    public Object[] getPrimaryKeyParameters(T object) {
        return this.getParameters(object, this.tableMetaData.getPrimaryKeys());
    }

    public Object[] getInsertParameters(T object) {
        return this.getParameters(object, this.tableMetaData.getNotAutoGeneratedColumns());
    }

    public Object[] getMergeParameters(T object) {
        return this.getParameters(object, this.tableMetaData.getNotAutoGeneratedColumns());
    }

    private Object[] getParametersWithoutAutoGeneratedColumns(T object) {
        return this.getParameters(object, this.tableMetaData.getNotAutoGeneratedColumns());
    }

    private Object[] getDeleteParameters(T object) {
        return this.getParameters(object, this.tableMetaData.getPrimaryKeys());
    }

    private Object[] getUpdateParameters(T object) {
        return this.getParameters(object, this.tableMetaData.getColumnsForUpdate());
    }

    public Object[] getParameters(Object object, List<String> columns) {
        if (object == null) {
            throw new SormException(StringUtils.format("Fail to get value from a instance of [{}] but it is null.", this.getObjectClass()));
        }
        Accessor[] accessors = this.accessorsMap.computeIfAbsent(columns, k -> (Accessor[])columns.stream().map(columnName -> this.getAccessor(object, (String)columnName)).toArray(Accessor[]::new));
        Object[] ret = new Object[accessors.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getValue(object, accessors[i]);
        }
        return ret;
    }

    private List<Object> setAutoGeneratedKeys(PreparedStatement stmt, T object) throws SQLException {
        try (ResultSet resultSet = stmt.getGeneratedKeys();){
            ResultSetMetaData metaData = resultSet.getMetaData();
            ArrayList<Object> ret = new ArrayList<Object>();
            while (resultSet.next()) {
                String columnName = metaData.getColumnName(1);
                int columnType = metaData.getColumnType(1);
                Class<?> classType = this.getSetterParamType(columnName);
                Object value = this.resultSetConverter.convertColumnValueTo(this.options, resultSet, 1, columnType, classType);
                this.setValue(object, columnName, value);
                ret.add(value);
            }
            ArrayList<Object> arrayList = ret;
            return arrayList;
        }
    }

    @SafeVarargs
    public final void setPrametersOfMultiRow(PreparedStatement stmt, T ... objects) throws SQLException, IOException {
        Object[] parameters = Arrays.stream(objects).flatMap(obj -> Arrays.stream(this.getParametersWithoutAutoGeneratedColumns(obj))).toArray(Object[]::new);
        this.sqlParametersSetter.setParameters(this.options, stmt, parameters);
    }

    private int executeUpdate(Connection connection, String sql, Object ... parameters) {
        Optional<LoggerContext.LogPoint> lp = this.loggerContext.createLogPoint(LoggerContext.Category.EXECUTE_UPDATE);
        lp.ifPresent(_lp -> _lp.logBeforeSql(connection, sql, parameters));
        int ret = OrmConnectionImpl.executeUpdateAndClose(this.loggerContext, this.options, connection, this.sqlParametersSetter, sql, parameters);
        lp.ifPresent(_lp -> _lp.logAfterUpdate(ret));
        return ret;
    }

    public int update(Connection connection, T object) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.executeUpdate(connection, this.getSql().getUpdateSql(), this.getUpdateParameters(object));
    }

    public void throwExeptionIfPrimaryKeysIsNotExist() {
        if (!this.tableMetaData.hasPrimaryKey()) {
            throw new SormException("This opperation requiers primary keys but Table [" + this.tableMetaData.getTableName() + "] doesn't have them.");
        }
    }

    public void throwExeptionIfAutoGeneratedColumnsExist() {
        if (this.tableMetaData.hasAutoGeneratedColumns()) {
            throw new SormException("This opperation requiers no autogenerated columns but Table [" + this.tableMetaData.getTableName() + "] has them.");
        }
    }

    public int[] update(Connection connection, T ... objects) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.batch(connection, this.sql.getUpdateSql(), obj -> this.getUpdateParameters(obj), objects);
    }

    public int delete(Connection connection, T object) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.executeUpdate(connection, this.getSql().getDeleteSql(), this.getDeleteParameters(object));
    }

    public int[] delete(Connection connection, T ... objects) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.batch(connection, this.sql.getDeleteSql(), obj -> this.getDeleteParameters(obj), objects);
    }

    public int insert(Connection connection, T object) {
        return this.executeUpdate(connection, this.sql.getInsertSql(), this.getInsertParameters(object));
    }

    public int merge(Connection connection, T object) {
        this.throwExeptionIfAutoGeneratedColumnsExist();
        return this.executeUpdate(connection, this.sql.getMergeSql(), this.getMergeParameters(object));
    }

    public InsertResult<T> insertAndGet(Connection connection, T object) {
        InsertResultImpl<T> insertResultImpl;
        block8: {
            String insertSql = this.sql.getInsertSql();
            PreparedStatement stmt = !this.tableMetaData.hasAutoGeneratedColumns() ? connection.prepareStatement(insertSql) : connection.prepareStatement(insertSql, this.tableMetaData.getAutoGeneratedColumnsArray());
            try {
                Object[] parameters = this.getInsertParameters(object);
                this.sqlParametersSetter.setParameters(this.options, stmt, parameters);
                Optional<LoggerContext.LogPoint> lp = this.loggerContext.createLogPoint(LoggerContext.Category.EXECUTE_UPDATE);
                lp.ifPresent(_lp -> _lp.logBeforeSql(connection, insertSql, parameters));
                int rowsModified = stmt.executeUpdate();
                lp.ifPresent(_lp -> _lp.logAfterUpdate(rowsModified));
                List<Object> keys = this.setAutoGeneratedKeys(stmt, object);
                insertResultImpl = new InsertResultImpl<T>(new int[]{rowsModified}, object, keys);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            stmt.close();
        }
        return insertResultImpl;
    }

    @SafeVarargs
    public final int[] insert(Connection con, T ... objects) {
        return this.multiRowProcessor.multiRowInsert(con, objects);
    }

    @SafeVarargs
    public final InsertResult<T> insertAndGet(Connection con, T ... objects) {
        T[] objsWithoutLast = Arrays.asList(objects).subList(0, objects.length - 1).toArray(Object[]::new);
        T last = objects[objects.length - 1];
        int[] resultWithoutLast = this.insert(con, objsWithoutLast);
        InsertResult<T> insertResult = this.insertAndGet(con, last);
        int[] result = ArrayUtils.add(resultWithoutLast, insertResult.getRowsModified()[0]);
        return new InsertResultImpl<T>(result, insertResult.getObject(), insertResult.getAutoGeneratedKeys());
    }

    public int[] batch(Connection con, String sql, Function<T, Object[]> parameterCreator, T[] objects) {
        return this.multiRowProcessor.batch(this.options, con, sql, parameterCreator, objects);
    }

    public int[] merge(Connection con, T ... objects) {
        this.throwExeptionIfAutoGeneratedColumnsExist();
        int[] result = this.multiRowProcessor.multiRowMerge(con, objects);
        return result;
    }

    public String getFormattedString() {
        return "[" + TableMapping.class.getSimpleName() + "] Table [" + this.tableMetaData.getTableName() + "] is mapped to [" + this.getObjectClass().getName() + "] class. " + System.lineSeparator() + "PK=" + this.tableMetaData.getPrimaryKeys() + ",  " + this.tableMetaData.getColumnsWithMetaData() + System.lineSeparator() + super.getColumnToAccessorString() + System.lineSeparator() + "  with [" + this.multiRowProcessor.getClass().getSimpleName() + "]";
    }

    public TableMetaData getTableMetaData() {
        return this.tableMetaData;
    }
}

