/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.multirow;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

final class BatchHelper {
    private final int batchSize;
    private final PreparedStatement stmt;
    private int counter;
    private final List<int[]> result = new ArrayList<int[]>();

    public BatchHelper(int batchSize, PreparedStatement stmt) {
        this.batchSize = batchSize;
        this.stmt = stmt;
    }

    public void addBatchAndExecuteIfReachedThreshold() throws SQLException {
        this.addBatch();
        if ((this.counter + 1) % this.batchSize == 0) {
            this.executeBatch();
        }
    }

    private void addBatch() throws SQLException {
        this.stmt.addBatch();
        ++this.counter;
    }

    public int[] finish() throws SQLException {
        this.executeBatch();
        return this.result.stream().flatMapToInt(e -> IntStream.of(e)).toArray();
    }

    private void executeBatch() throws SQLException {
        if (this.counter == 0) {
            return;
        }
        int[] tmp = this.stmt.executeBatch();
        this.result.add(tmp);
        this.counter = 0;
    }
}

