/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.impl;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.extension.ColumnValueConverter;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.internal.util.Try;

public class DefaultResultSetConverter
implements ResultSetConverter {
    private static final Set<Class<?>> standardObjectClasses = Set.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, String.class, BigDecimal.class, Clob.class, Blob.class, Date.class, Time.class, Timestamp.class, LocalDate.class, LocalTime.class, LocalDateTime.class, OffsetTime.class, OffsetDateTime.class, java.util.Date.class, UUID.class, InputStream.class, Reader.class, URL.class, Inet4Address.class, Inet6Address.class, Object.class);
    private final List<ColumnValueConverter> converters;
    @Experimental
    private final LetterCaseOfKeyInMap letterCaseOfKeyInMap;

    @Override
    public boolean isStandardClass(SormOptions options, Class<?> objectClass) {
        return standardObjectClasses.contains(objectClass) || objectClass.isArray();
    }

    public DefaultResultSetConverter() {
        this(LetterCaseOfKeyInMap.LOWER_CASE, Collections.emptyList());
    }

    public DefaultResultSetConverter(LetterCaseOfKeyInMap letterCaseOfKeyInMap) {
        this(letterCaseOfKeyInMap, Collections.emptyList());
    }

    public DefaultResultSetConverter(LetterCaseOfKeyInMap letterCaseOfKeyInMap, List<ColumnValueConverter> converters) {
        this(letterCaseOfKeyInMap, (ColumnValueConverter[])converters.toArray(ColumnValueConverter[]::new));
    }

    public DefaultResultSetConverter(LetterCaseOfKeyInMap letterCaseOfKeyInMap, ColumnValueConverter ... converters) {
        this.converters = converters.length == 0 ? Collections.emptyList() : Arrays.asList(converters);
        this.letterCaseOfKeyInMap = letterCaseOfKeyInMap;
    }

    private String convertKey(String key) {
        switch (this.letterCaseOfKeyInMap) {
            case LOWER_CASE: {
                return StringCache.toLowerCase(key);
            }
            case UPPER_CASE: {
                return StringCache.toUpperCase(key);
            }
            case CANONICAL_CASE: {
                return StringCache.toCanonicalCase(key);
            }
        }
        return key;
    }

    @Override
    public Map<String, Object> toSingleMap(SormOptions options, ResultSet resultSet, List<String> columns, List<Integer> columnTypes) throws SQLException {
        int cSize = columns.size();
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>(cSize);
        for (int i = 1; i <= cSize; ++i) {
            ret.put(this.convertKey(columns.get(i - 1)), this.getColumnValueBySqlType(resultSet, i, columnTypes.get(i - 1)));
        }
        return ret;
    }

    @Override
    public <T> T toSingleStandardObject(SormOptions options, ResultSet resultSet, int sqlType, Class<T> objectClass) throws SQLException {
        return (T)this.convertColumnValueTo(options, resultSet, 1, sqlType, objectClass);
    }

    private static Class<?> componentType(String name) {
        switch (name) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        return Try.getOrElseThrow(() -> Class.forName(name), Try::rethrow);
    }

    @Override
    public Object convertColumnValueTo(SormOptions options, ResultSet resultSet, int column, int columnType, Class<?> toType) throws SQLException {
        String name;
        Optional<ColumnValueConverter> conv;
        if (this.converters.size() != 0 && (conv = this.converters.stream().filter(co -> co.isApplicable(options, resultSet, column, columnType, toType)).findFirst()).isPresent()) {
            return conv.get().convertTo(options, resultSet, column, columnType, toType);
        }
        if (toType.isEnum()) {
            String v = resultSet.getString(column);
            return Arrays.stream(toType.getEnumConstants()).filter(o -> o.toString().equals(v)).findAny().orElse(null);
        }
        if (toType.isArray()) {
            switch (name = toType.getComponentType().getName()) {
                case "byte": 
                case "java.lang.Byte": {
                    return resultSet.getBytes(column);
                }
                case "char": 
                case "java.lang.Character": {
                    String str = resultSet.getString(column);
                    return str == null ? null : str.toCharArray();
                }
            }
            java.sql.Array arry = resultSet.getArray(column);
            Object srcArry = arry.getArray();
            int length = Array.getLength(srcArry);
            Object destArray = Array.newInstance(DefaultResultSetConverter.componentType(name), length);
            for (int i = 0; i < length; ++i) {
                Object v = Array.get(srcArry, i);
                Array.set(destArray, i, v);
            }
            return destArray;
        }
        switch (name = toType.getName()) {
            case "boolean": {
                return resultSet.getBoolean(column);
            }
            case "java.lang.Boolean": {
                boolean ret = resultSet.getBoolean(column);
                return !ret && resultSet.wasNull() ? null : Boolean.valueOf(ret);
            }
            case "byte": {
                return resultSet.getByte(column);
            }
            case "java.lang.Byte": {
                byte ret = resultSet.getByte(column);
                return ret == 0 && resultSet.wasNull() ? null : Byte.valueOf(ret);
            }
            case "short": {
                return resultSet.getShort(column);
            }
            case "java.lang.Short": {
                short ret = resultSet.getShort(column);
                return ret == 0 && resultSet.wasNull() ? null : Short.valueOf(ret);
            }
            case "int": {
                return resultSet.getInt(column);
            }
            case "java.lang.Integer": {
                int ret = resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Integer.valueOf(ret);
            }
            case "long": {
                return resultSet.getLong(column);
            }
            case "java.lang.Long": {
                long ret = resultSet.getLong(column);
                return ret == 0L && resultSet.wasNull() ? null : Long.valueOf(ret);
            }
            case "float": {
                return Float.valueOf(resultSet.getFloat(column));
            }
            case "java.lang.Float": {
                float ret = resultSet.getFloat(column);
                return ret == 0.0f && resultSet.wasNull() ? null : Float.valueOf(ret);
            }
            case "double": {
                return resultSet.getDouble(column);
            }
            case "java.lang.Double": {
                double ret = resultSet.getDouble(column);
                return ret == 0.0 && resultSet.wasNull() ? null : Double.valueOf(ret);
            }
            case "java.math.BigDecimal": {
                return resultSet.getBigDecimal(column);
            }
            case "java.lang.String": {
                return resultSet.getString(column);
            }
            case "java.lang.Character": 
            case "char": {
                String str = resultSet.getString(column);
                return str == null || str.length() == 0 ? null : Character.valueOf(str.charAt(0));
            }
            case "java.sql.Date": {
                return resultSet.getDate(column);
            }
            case "java.sql.Time": {
                return resultSet.getTime(column);
            }
            case "java.sql.Timestamp": {
                return resultSet.getTimestamp(column);
            }
            case "java.io.InputStream": {
                return resultSet.getBinaryStream(column);
            }
            case "java.io.Reader": {
                return resultSet.getCharacterStream(column);
            }
            case "java.sql.Clob": {
                return resultSet.getClob(column);
            }
            case "java.sql.Blob": {
                return resultSet.getBlob(column);
            }
            case "java.time.LocalTime": {
                return Optional.ofNullable(resultSet.getTime(column)).map(t -> t.toLocalTime()).orElse(null);
            }
            case "java.time.LocalDate": {
                return Optional.ofNullable(resultSet.getDate(column)).map(t -> t.toLocalDate()).orElse(null);
            }
            case "java.time.LocalDateTime": {
                return Optional.ofNullable(resultSet.getTimestamp(column)).map(t -> t.toLocalDateTime()).orElse(null);
            }
            case "java.util.Date": {
                return Optional.ofNullable(resultSet.getTimestamp(column)).map(t -> new java.util.Date(t.getTime())).orElse(null);
            }
            case "java.util.UUID": {
                return Optional.ofNullable(resultSet.getString(column)).map(s -> UUID.fromString(s)).orElse(null);
            }
            case "java.time.OffsetTime": {
                return Optional.ofNullable(resultSet.getTimestamp(column)).map(t -> t.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime().toOffsetTime()).orElse(null);
            }
            case "java.time.OffsetDateTime": {
                return Optional.ofNullable(resultSet.getTimestamp(column)).map(t -> t.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime()).orElse(null);
            }
            case "java.net.URL": {
                return Optional.ofNullable(resultSet.getString(column)).map(s -> Try.getOrElseNull(() -> new URL((String)s))).orElse(null);
            }
            case "java.net.Inet4Address": {
                return Optional.ofNullable(resultSet.getString(column)).map(s -> Try.getOrElseNull(() -> Inet4Address.getByName(s))).orElse(null);
            }
            case "java.net.Inet6Address": {
                return Optional.ofNullable(resultSet.getString(column)).map(s -> Try.getOrElseNull(() -> Inet6Address.getByName(s))).orElse(null);
            }
            case "java.lang.Object": {
                return resultSet.getObject(column);
            }
        }
        return resultSet.getObject(column);
    }

    protected Object getColumnValueBySqlType(ResultSet resultSet, int column, int sqlType) throws SQLException {
        switch (sqlType) {
            case 2003: {
                return resultSet.getArray(column);
            }
            case -5: {
                long ret = resultSet.getLong(column);
                return ret == 0L && resultSet.wasNull() ? null : Long.valueOf(ret);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return resultSet.getBytes(column);
            }
            case -7: 
            case 16: {
                boolean ret = resultSet.getBoolean(column);
                return !ret && resultSet.wasNull() ? null : Boolean.valueOf(ret);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return resultSet.getString(column);
            }
            case 70: {
                return resultSet.getBinaryStream(column);
            }
            case 91: {
                return resultSet.getDate(column);
            }
            case 2: 
            case 3: {
                return resultSet.getBigDecimal(column);
            }
            case 7: 
            case 8: {
                double ret = resultSet.getDouble(column);
                return ret == 0.0 && resultSet.wasNull() ? null : Double.valueOf(ret);
            }
            case 6: {
                float ret = resultSet.getFloat(column);
                return ret == 0.0f && resultSet.wasNull() ? null : Float.valueOf(ret);
            }
            case 4: {
                int ret = resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Integer.valueOf(ret);
            }
            case 0: {
                return null;
            }
            case 2006: {
                return resultSet.getRef(column);
            }
            case -8: {
                return resultSet.getRowId(column);
            }
            case 5: {
                short ret = (short)resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Short.valueOf(ret);
            }
            case 92: {
                return resultSet.getTime(column);
            }
            case 93: {
                return resultSet.getTimestamp(column);
            }
            case -6: {
                byte ret = resultSet.getByte(column);
                return ret == 0 && resultSet.wasNull() ? null : Byte.valueOf(ret);
            }
            case 1111: 
            case 2000: {
                return resultSet.getObject(column);
            }
        }
        return resultSet.getObject(column);
    }

    public static enum LetterCaseOfKeyInMap {
        LOWER_CASE,
        UPPER_CASE,
        CANONICAL_CASE,
        NO_CONVERSION;

    }
}

