/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.OrmTable;
import org.nkjmlab.sorm4j.extension.TableName;
import org.nkjmlab.sorm4j.extension.TableNameMapper;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.internal.util.StringCache;

public class DefaultTableNameMapper
implements TableNameMapper {
    @Override
    public TableName getTableName(String tableName, DatabaseMetaData metaData) {
        List<String> candidates = List.of(tableName);
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(ParameterizedStringUtils.newString("[{}] does not match any existing table in the database. Use [{}] annotation correctly. Table Name candidates are {}", tableName, OrmTable.class.getName(), candidates)));
    }

    @Override
    public TableName getTableName(Class<?> objectClass, DatabaseMetaData metaData) {
        List<String> candidates = this.guessTableNameCandidates(objectClass);
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(ParameterizedStringUtils.newString("[{}] does not match any existing table in the database. Use [{}] annotation correctly. Table Name candidates are {}", objectClass.getName(), OrmTable.class.getName(), candidates)));
    }

    protected List<String> guessTableNameCandidates(Class<?> objectClass) {
        List<String> annotatedTableName = Optional.ofNullable(objectClass.getAnnotation(OrmTable.class)).map(a -> List.of(a.value())).orElse(Collections.emptyList());
        if (annotatedTableName.size() != 0) {
            return annotatedTableName;
        }
        String className = objectClass.getSimpleName();
        String cannonicalClassName = StringCache.toCanonicalCase(className);
        if (cannonicalClassName.endsWith("Y")) {
            return List.of(cannonicalClassName, cannonicalClassName + "S", cannonicalClassName.substring(0, cannonicalClassName.length() - 1) + "IES");
        }
        return List.of(cannonicalClassName, cannonicalClassName + "S");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Optional<TableName> convertToExactTableName(DatabaseMetaData metaData, List<String> tableNameCandidates) {
        try (ResultSet resultSet = metaData.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});){
            while (resultSet.next()) {
                String tableNameOnDb = resultSet.getString(3);
                if (!this.isMatch(tableNameCandidates, tableNameOnDb)) continue;
                Optional<TableName> optional = Optional.of(new TableName(tableNameOnDb));
                return optional;
            }
            Optional<TableName> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    protected boolean isMatch(List<String> candidates, String exactTableName) {
        return StringCache.containsAsCanonical(candidates, exactTableName);
    }
}

