package org.nkjmlab.sorm4j.common;

import java.sql.Connection;
import java.util.List;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.annotation.OrmColumnAliasPrefix;
import org.nkjmlab.sorm4j.extension.ColumnNameWithMetaData;

/**
 * Except for {@link #getColumnAliases()} and {@link #getColumnAliasPrefix()}, this object is
 * created from metadata. {@link Connection#getMetaData}
 *
 * @author nkjm
 *
 */
@Experimental
public interface TableMetaData {

  /**
   * Gets auto generated columns list.
   *
   * @return
   */
  List<String> getAutoGeneratedColumns();

  /**
   * Gets auto generated columns array.
   *
   * @return
   */
  String[] getAutoGeneratedColumnsArray();

  /**
   * <p>
   * Creates a string of column aliases.
   *
   * <p>
   * For example, if the "customer" table has "id" and "name" columns, and
   * {@link OrmColumnAliasPrefix} is "c" returns
   * <code>"customer.id as cid, customer.name as cname"</code>.
   *
   * @return column aliases (e.g. <code>"customer.id as cid, customer.name as cname"</code>)
   */

  String getColumnAliases();

  /**
   * Gets column alias prefix.
   *
   * @return
   */
  String getColumnAliasPrefix();

  List<String> getColumns();

  List<String> getColumnsForUpdate();

  List<ColumnNameWithMetaData> getColumnsWithMetaData();

  List<String> getNotAutoGeneratedColumns();

  List<String> getNotPrimaryKeys();

  List<String> getPrimaryKeys();

  String getTableName();

  boolean hasAutoGeneratedColumns();

  boolean hasPrimaryKey();

}
