/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j;

import java.sql.Connection;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.nkjmlab.sorm4j.Orm;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmTransaction;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.basic.ConsumerHandler;
import org.nkjmlab.sorm4j.basic.FunctionHandler;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.MultiRowProcessorType;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormContext;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.TableNameMapper;
import org.nkjmlab.sorm4j.extension.logger.LoggerContext;
import org.nkjmlab.sorm4j.extension.logger.SormLogger;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.SormImpl;
import org.nkjmlab.sorm4j.internal.util.DriverManagerDataSource;

public interface Sorm
extends Orm {
    public static Sorm create(DataSource dataSource) {
        return SormImpl.create(dataSource, DefaultContext.CONTEXT);
    }

    public static Sorm create(String jdbcUrl, String user, String password) {
        return Sorm.create(Sorm.createDataSource(jdbcUrl, user, password));
    }

    public static Sorm create(String jdbcUrl) {
        return Sorm.create(Sorm.createDataSource(jdbcUrl, null, null));
    }

    public static void setDefaultContext(Function<SormContext.Builder, SormContext> contextGenerator) {
        DefaultContext.CONTEXT = contextGenerator.apply(SormContext.builder());
    }

    public static DataSource createDataSource(String jdbcUrl, String username, String password) {
        return new DriverManagerDataSource(jdbcUrl, username, password);
    }

    public static OrmConnection toOrmConnection(Connection connection) {
        return Sorm.toOrmConnection(connection, DefaultContext.CONTEXT);
    }

    public static OrmConnection toOrmConnection(Connection connection, SormContext sormContext) {
        return new OrmConnectionImpl(connection, sormContext);
    }

    public void accept(ConsumerHandler<OrmConnection> var1);

    @Experimental
    public void acceptWithLogging(ConsumerHandler<OrmConnection> var1);

    @Experimental
    public <R> R applyWithLogging(FunctionHandler<OrmConnection, R> var1);

    public void acceptJdbcConnectionHandler(ConsumerHandler<Connection> var1);

    public void acceptTransactionHandler(ConsumerHandler<OrmTransaction> var1);

    public <R> R apply(FunctionHandler<OrmConnection, R> var1);

    public <R> R applyJdbcConnectionHandler(FunctionHandler<Connection, R> var1);

    public <R> R applyTransactionHandler(FunctionHandler<OrmTransaction, R> var1);

    @Experimental
    public String getContextString();

    public DataSource getDataSource();

    public Connection getJdbcConnection();

    public OrmConnection openConnection();

    public OrmTransaction openTransaction();

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataSource dataSource) {
        return new Builder(dataSource);
    }

    public static Builder builder(String jdbcUrl, String user, String password) {
        return new Builder(Sorm.createDataSource(jdbcUrl, user, password));
    }

    @Experimental
    public static class Builder {
        private DataSource dataSource;
        private SormContext.Builder contextBuilder = SormContext.builder();

        private Builder() {
        }

        public Builder(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Sorm build() {
            return new SormImpl(this.dataSource, this.contextBuilder.build());
        }

        public Builder setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder setDataSource(String jdbcUrl, String username, String password) {
            this.dataSource = Sorm.createDataSource(jdbcUrl, username, password);
            return this;
        }

        public Builder setColumnFieldMapper(ColumnFieldMapper fieldNameMapper) {
            this.contextBuilder.setColumnFieldMapper(fieldNameMapper);
            return this;
        }

        public Builder setTableNameMapper(TableNameMapper tableNameMapper) {
            this.contextBuilder.setTableNameMapper(tableNameMapper);
            return this;
        }

        public Builder setResultSetConverter(ResultSetConverter resultSetConverter) {
            this.contextBuilder.setResultSetConverter(resultSetConverter);
            return this;
        }

        public Builder setSqlParametersSetter(SqlParametersSetter sqlParametersSetter) {
            this.contextBuilder.setSqlParametersSetter(sqlParametersSetter);
            return this;
        }

        public Builder setMultiRowProcessorType(MultiRowProcessorType multiRowProcessorType) {
            this.contextBuilder.setMultiRowProcessorType(multiRowProcessorType);
            return this;
        }

        public Builder setBatchSize(int size) {
            this.contextBuilder.setBatchSize(size);
            return this;
        }

        public Builder setMultiRowSize(int size) {
            this.contextBuilder.setMultiRowSize(size);
            return this;
        }

        public Builder setBatchSizeWithMultiRow(int size) {
            this.contextBuilder.setBatchSizeWithMultiRow(size);
            return this;
        }

        public Builder setTransactionIsolationLevel(int level) {
            this.contextBuilder.setTransactionIsolationLevel(level);
            return this;
        }

        public Builder setOption(String name, Object value) {
            this.contextBuilder.setOption(name, value);
            return this;
        }

        public Builder setLoggerOnAll() {
            this.contextBuilder.setLoggerOnAll();
            return this;
        }

        public Builder setLoggerOffAll() {
            this.contextBuilder.setLoggerOffAll();
            return this;
        }

        public Builder setLoggerOn(LoggerContext.Category ... categories) {
            this.contextBuilder.setLoggerOn(categories);
            return this;
        }

        public Builder setLoggerOff(LoggerContext.Category ... categories) {
            this.contextBuilder.setLoggerOff(categories);
            return this;
        }

        public Builder setLoggerSupplier(Supplier<SormLogger> loggerSupplier) {
            this.contextBuilder.setLoggerSupplier(loggerSupplier);
            return this;
        }
    }

    public static class DefaultContext {
        static volatile SormContext CONTEXT = SormContext.builder().build();
    }
}

