/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.common.TableMetaData;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.ColumnNameWithMetaData;
import org.nkjmlab.sorm4j.extension.MultiRowProcessorType;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.TableName;
import org.nkjmlab.sorm4j.extension.TableNameMapper;
import org.nkjmlab.sorm4j.extension.TableSql;
import org.nkjmlab.sorm4j.extension.TableSqlFactory;
import org.nkjmlab.sorm4j.extension.impl.DefaultColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.impl.DefaultResultSetConverter;
import org.nkjmlab.sorm4j.extension.impl.DefaultSqlParametersSetter;
import org.nkjmlab.sorm4j.extension.impl.DefaultTableNameMapper;
import org.nkjmlab.sorm4j.extension.impl.DefaultTableSqlFactory;
import org.nkjmlab.sorm4j.extension.logger.LoggerContext;
import org.nkjmlab.sorm4j.extension.logger.SormLogger;
import org.nkjmlab.sorm4j.internal.SormOptionsImpl;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.internal.mapping.ColumnsMapping;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;
import org.nkjmlab.sorm4j.internal.mapping.TableMetaDataImpl;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.internal.util.Try;

@Experimental
public final class SormContext {
    private final ConcurrentMap<String, TableMapping<?>> tableMappings;
    private final ConcurrentMap<String, TableMetaData> tableMetaDataMap;
    private final ConcurrentMap<Class<?>, ColumnsMapping<?>> columnsMappings;
    private final ConcurrentMap<Class<?>, TableName> classNameToValidTableNameMap;
    private final ConcurrentMap<String, TableName> tableNameToValidTableNameMap;
    private final SormConfig sormConfig;

    private SormContext(SormConfig sormConfig) {
        this.sormConfig = sormConfig;
        this.tableMappings = new ConcurrentHashMap();
        this.tableMetaDataMap = new ConcurrentHashMap<String, TableMetaData>();
        this.columnsMappings = new ConcurrentHashMap();
        this.classNameToValidTableNameMap = new ConcurrentHashMap();
        this.tableNameToValidTableNameMap = new ConcurrentHashMap<String, TableName>();
    }

    public TableMetaData getTableMetaData(Connection connection, String tableName) {
        return this.getTableMetaData(connection, this.toTableName(connection, tableName));
    }

    private TableMetaData getTableMetaData(Connection connection, TableName tableName) {
        TableMetaData ret = this.tableMetaDataMap.computeIfAbsent(tableName.getName(), Try.createFunctionWithThrow(_key -> {
            TableMetaData m = this.createTableMetaData(Object.class, tableName.getName(), connection.getMetaData());
            return m;
        }, Try::rethrow));
        return ret;
    }

    public <T> TableMapping<T> getTableMapping(Connection connection, Class<T> objectClass) {
        TableName tableName = this.toTableName(connection, objectClass);
        return this.getTableMapping(connection, tableName, objectClass);
    }

    public <T> TableMapping<T> getTableMapping(Connection connection, String tableName, Class<T> objectClass) {
        return this.getTableMapping(connection, this.toTableName(connection, tableName), objectClass);
    }

    <T> TableMapping<T> getTableMapping(Connection connection, TableName tableName, Class<T> objectClass) {
        String key = tableName.getName() + "-" + objectClass.getName();
        TableMapping ret = this.tableMappings.computeIfAbsent(key, Try.createFunctionWithThrow(_key -> {
            TableMapping m = this.createTableMapping(objectClass, tableName.getName(), connection);
            this.sormConfig.getLoggerContext().createLogPoint(LoggerContext.Category.MAPPING).ifPresent(lp -> lp.logMapping(m.getFormattedString()));
            return m;
        }, Try::rethrow));
        return ret;
    }

    public <T> ColumnsMapping<T> createColumnsMapping(Class<T> objectClass) {
        Map<String, Accessor> accessors = this.sormConfig.getColumnFieldMapper().createAccessors(objectClass);
        String aliasPrefix = this.sormConfig.getColumnFieldMapper().getColumnAliasPrefix(objectClass);
        Map<String, Accessor> aliasAccessors = this.sormConfig.getColumnFieldMapper().createAliasAccessors(aliasPrefix, accessors);
        ColumnToAccessorMap columnToAccessorMap = new ColumnToAccessorMap(objectClass, accessors, aliasPrefix, aliasAccessors);
        return new ColumnsMapping<T>(this.sormConfig.getOptions(), this.sormConfig.getResultSetConverter(), objectClass, columnToAccessorMap);
    }

    public <T> TableMapping<T> createTableMapping(Class<T> objectClass, String tableName, Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        TableMetaData tableMetaData = this.createTableMetaData(objectClass, tableName, metaData);
        List<String> columns = tableMetaData.getColumns();
        TableSql sql = this.sormConfig.getTableSqlFactory().create(tableMetaData, objectClass, connection);
        Map<String, Accessor> accessors = this.sormConfig.getColumnFieldMapper().createAccessors(objectClass, columns);
        Set<String> keySetWithoutAlias = accessors.keySet();
        if (!StringCache.equalsAsCanonical(columns, keySetWithoutAlias)) {
            throw new SormException(ParameterizedStringUtils.newString("{} does not match any field. Table [{}] contains Columns {} but [{}] contains Fields {}.", columns.stream().filter(e -> !keySetWithoutAlias.contains(StringCache.toCanonicalCase(e))).sorted().collect(Collectors.toList()), tableName, tableMetaData.getColumns().stream().map(c -> c.toString()).sorted().collect(Collectors.toList()), objectClass.getName(), keySetWithoutAlias.stream().sorted().collect(Collectors.toList())));
        }
        Map<String, Accessor> aliasAccessors = this.sormConfig.getColumnFieldMapper().createAliasAccessors(tableMetaData.getColumnAliasPrefix(), accessors);
        ColumnToAccessorMap columnToAccessorMap = new ColumnToAccessorMap(objectClass, accessors, tableMetaData.getColumnAliasPrefix(), aliasAccessors);
        return new TableMapping<T>(this.sormConfig.getLoggerContext(), this.sormConfig.getOptions(), this.sormConfig.getResultSetConverter(), this.sormConfig.getSqlParametersSetter(), this.sormConfig.getMultiRowProcessorFactory(), objectClass, columnToAccessorMap, tableMetaData, sql);
    }

    private <T> TableMetaData createTableMetaData(Class<T> objectClass, String tableName, DatabaseMetaData metaData) throws SQLException {
        List<ColumnNameWithMetaData> columns = this.sormConfig.getColumnFieldMapper().getColumns(metaData, tableName);
        List<String> primaryKeys = this.sormConfig.getColumnFieldMapper().getPrimaryKeys(metaData, tableName).stream().map(c -> c.getName()).collect(Collectors.toList());
        List<String> autoGeneratedColumns = this.sormConfig.getColumnFieldMapper().getAutoGeneratedColumns(metaData, tableName).stream().map(c -> c.getName()).collect(Collectors.toList());
        String columnAliasPrefix = this.sormConfig.getColumnFieldMapper().getColumnAliasPrefix(objectClass);
        return new TableMetaDataImpl(tableName, columnAliasPrefix, columns, primaryKeys, autoGeneratedColumns);
    }

    public <T> TableMapping<T> getCastedTableMapping(Connection connection, Class<?> objectClass) {
        return this.getTableMapping(connection, objectClass);
    }

    public <T> TableMapping<T> getCastedTableMapping(Connection connection, String tableName, Class<?> objectClass) {
        return this.getTableMapping(connection, tableName, objectClass);
    }

    public <T> ColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        ColumnsMapping ret = this.columnsMappings.computeIfAbsent(objectClass, _k -> {
            ColumnsMapping m = this.createColumnsMapping(objectClass);
            this.sormConfig.getLoggerContext().createLogPoint(LoggerContext.Category.MAPPING).ifPresent(lp -> lp.logMapping(m.getFormattedString()));
            return m;
        });
        return ret;
    }

    private TableName toTableName(Connection connection, Class<?> objectClass) {
        return this.classNameToValidTableNameMap.computeIfAbsent(objectClass, Try.createFunctionWithThrow(k -> this.sormConfig.getTableNameMapper().getTableName(objectClass, connection.getMetaData()), Try::rethrow));
    }

    public String getTableName(Connection connection, Class<?> objectClass) {
        return this.toTableName(connection, objectClass).getName();
    }

    private TableName toTableName(Connection connection, String tableName) {
        return this.tableNameToValidTableNameMap.computeIfAbsent(tableName, Try.createFunctionWithThrow(k -> this.sormConfig.getTableNameMapper().getTableName(tableName, connection.getMetaData()), Try::rethrow));
    }

    public LoggerContext getLoggerContext() {
        return this.sormConfig.getLoggerContext();
    }

    public int getTransactionIsolationLevel() {
        return this.sormConfig.getTransactionIsolationLevel();
    }

    public SormOptions getOptions() {
        return this.sormConfig.getOptions();
    }

    public ResultSetConverter getResultSetConverter() {
        return this.sormConfig.getResultSetConverter();
    }

    public SqlParametersSetter getSqlParametersSetter() {
        return this.sormConfig.getSqlParametersSetter();
    }

    public String toString() {
        return "SormContext [tableMappings=" + this.tableMappings + ", columnsMappings=" + this.columnsMappings + ", classNameToValidTableNameMap=" + this.classNameToValidTableNameMap + ", tableNameToValidTableNameMap=" + this.tableNameToValidTableNameMap + ", sormConfig=" + this.sormConfig + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class SormConfig {
        private final TableNameMapper tableNameMapper;
        private final ColumnFieldMapper columnFieldMapper;
        private final MultiRowProcessorFactory multiRowProcessorFactory;
        private final ResultSetConverter resultSetConverter;
        private final SqlParametersSetter sqlParametersSetter;
        private final SormOptions options;
        private final int transactionIsolationLevel;
        private final LoggerContext loggerContext;
        private final TableSqlFactory tableSqlFactory;

        public SormConfig(LoggerContext loggerContext, Map<String, Object> options, ColumnFieldMapper columnFieldMapper, TableNameMapper tableNameMapper, ResultSetConverter resultSetConverter, SqlParametersSetter sqlParametersSetter, TableSqlFactory tableSqlFactory, MultiRowProcessorType multiRowProcessorType, int batchSize, int multiRowSize, int batchSizeWithMultiRow, int transactionIsolationLevel) {
            this.loggerContext = loggerContext;
            this.options = new SormOptionsImpl(options);
            this.transactionIsolationLevel = transactionIsolationLevel;
            this.tableNameMapper = tableNameMapper;
            this.columnFieldMapper = columnFieldMapper;
            this.multiRowProcessorFactory = MultiRowProcessorFactory.createMultiRowProcessorFactory(loggerContext, this.options, sqlParametersSetter, multiRowProcessorType, batchSize, multiRowSize, batchSizeWithMultiRow);
            this.resultSetConverter = resultSetConverter;
            this.sqlParametersSetter = sqlParametersSetter;
            this.tableSqlFactory = tableSqlFactory;
        }

        public int getTransactionIsolationLevel() {
            return this.transactionIsolationLevel;
        }

        public ResultSetConverter getResultSetConverter() {
            return this.resultSetConverter;
        }

        public SqlParametersSetter getSqlParametersSetter() {
            return this.sqlParametersSetter;
        }

        public SormOptions getOptions() {
            return this.options;
        }

        public LoggerContext getLoggerContext() {
            return this.loggerContext;
        }

        public String toString() {
            return "SormConfig [tableNameMapper=" + this.tableNameMapper + ", columnFieldMapper=" + this.columnFieldMapper + ", multiRowProcessorFactory=" + this.multiRowProcessorFactory + ", resultSetConverter=" + this.resultSetConverter + ", sqlParametersSetter=" + this.sqlParametersSetter + ", options=" + this.options + ", transactionIsolationLevel=" + this.transactionIsolationLevel + ", loggerContext=" + this.loggerContext + "]";
        }

        public ColumnFieldMapper getColumnFieldMapper() {
            return this.columnFieldMapper;
        }

        public TableNameMapper getTableNameMapper() {
            return this.tableNameMapper;
        }

        public TableSqlFactory getTableSqlFactory() {
            return this.tableSqlFactory;
        }

        public MultiRowProcessorFactory getMultiRowProcessorFactory() {
            return this.multiRowProcessorFactory;
        }
    }

    @Experimental
    public static class Builder {
        private static final MultiRowProcessorType DEFAULT_MULTI_ROW_PROCESSOR = MultiRowProcessorType.MULTI_ROW;
        private static final SqlParametersSetter DEFAULT_SQL_PARAMETER_SETTER = new DefaultSqlParametersSetter();
        private static final ResultSetConverter DEFAULT_RESULT_SET_CONVERTER = new DefaultResultSetConverter();
        private static final TableNameMapper DEFAULT_TABLE_NAME_MAPPER = new DefaultTableNameMapper();
        private static final TableSqlFactory DEFAULT_TABLE_SQL_FACTORY = new DefaultTableSqlFactory();
        private static final int DEFAULT_TRANSACTION_ISOLATION_LEVEL = 2;
        private TableNameMapper tableNameMapper = DEFAULT_TABLE_NAME_MAPPER;
        private ResultSetConverter resultSetConverter = DEFAULT_RESULT_SET_CONVERTER;
        private SqlParametersSetter sqlParametersSetter = DEFAULT_SQL_PARAMETER_SETTER;
        private MultiRowProcessorType multiRowProcessorType = DEFAULT_MULTI_ROW_PROCESSOR;
        private TableSqlFactory tableSqlFactory = DEFAULT_TABLE_SQL_FACTORY;
        private ColumnFieldMapper columnFieldMapper;
        private int batchSize = 32;
        private int multiRowSize = 32;
        private int batchSizeWithMultiRow = 5;
        private int transactionIsolationLevel = 2;
        private Map<String, Object> options = new HashMap<String, Object>();
        private LoggerContext.Builder loggerConfigBuilder = LoggerContext.builder();

        private Builder() {
        }

        public SormContext build() {
            LoggerContext loggerContext = this.loggerConfigBuilder.build();
            this.columnFieldMapper = this.columnFieldMapper != null ? this.columnFieldMapper : new DefaultColumnFieldMapper(loggerContext);
            return new SormContext(new SormConfig(loggerContext, this.options, this.columnFieldMapper, this.tableNameMapper, this.resultSetConverter, this.sqlParametersSetter, this.tableSqlFactory, this.multiRowProcessorType, this.batchSize, this.multiRowSize, this.batchSizeWithMultiRow, this.transactionIsolationLevel));
        }

        public Builder setColumnFieldMapper(ColumnFieldMapper fieldNameMapper) {
            this.columnFieldMapper = fieldNameMapper;
            return this;
        }

        public Builder setTableNameMapper(TableNameMapper tableNameMapper) {
            this.tableNameMapper = tableNameMapper;
            return this;
        }

        public Builder setResultSetConverter(ResultSetConverter resultSetConverter) {
            this.resultSetConverter = resultSetConverter;
            return this;
        }

        public Builder setSqlParametersSetter(SqlParametersSetter sqlParametersSetter) {
            this.sqlParametersSetter = sqlParametersSetter;
            return this;
        }

        public Builder setTableSqlFactory(TableSqlFactory tableSqlFactory) {
            this.tableSqlFactory = tableSqlFactory;
            return this;
        }

        public Builder setMultiRowProcessorType(MultiRowProcessorType multiRowProcessorType) {
            this.multiRowProcessorType = multiRowProcessorType;
            return this;
        }

        public Builder setBatchSize(int size) {
            this.batchSize = size;
            return this;
        }

        public Builder setMultiRowSize(int size) {
            this.multiRowSize = size;
            return this;
        }

        public Builder setBatchSizeWithMultiRow(int size) {
            this.batchSizeWithMultiRow = size;
            return this;
        }

        public Builder setTransactionIsolationLevel(int level) {
            this.transactionIsolationLevel = level;
            return this;
        }

        public Builder setOption(String name, Object value) {
            this.options.put(name, value);
            return this;
        }

        public Builder setLoggerOnAll() {
            this.loggerConfigBuilder.onAll();
            return this;
        }

        public Builder setLoggerOffAll() {
            this.loggerConfigBuilder.offAll();
            return this;
        }

        public Builder setLoggerOn(LoggerContext.Category ... categories) {
            this.loggerConfigBuilder.on(categories);
            return this;
        }

        public Builder setLoggerOff(LoggerContext.Category ... categories) {
            this.loggerConfigBuilder.off(categories);
            return this;
        }

        public Builder setLoggerSupplier(Supplier<SormLogger> loggerSupplier) {
            this.loggerConfigBuilder.setLoggerSupplier(loggerSupplier);
            return this;
        }
    }
}

