/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.impl;

import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.common.TableMetaData;
import org.nkjmlab.sorm4j.extension.TableSql;
import org.nkjmlab.sorm4j.extension.TableSqlFactory;

public class DefaultTableSqlFactory
implements TableSqlFactory {
    @Override
    public TableSql create(TableMetaData tableMetaData, Class<?> objectClass, Connection connection) {
        String tableName = tableMetaData.getTableName();
        List<String> columns = tableMetaData.getColumns();
        List<String> primaryKeys = tableMetaData.getPrimaryKeys();
        List<String> notAutoGeneratedColumns = tableMetaData.getNotAutoGeneratedColumns();
        String insertSqlPrefix = "insert into " + tableName + " (" + DefaultTableSqlFactory.toColumList(notAutoGeneratedColumns) + ") values";
        String mergeSqlPrefix = "merge into " + tableName + " (" + DefaultTableSqlFactory.toColumList(notAutoGeneratedColumns) + ") values";
        String insertOrMergePlaceholders = " (" + DefaultTableSqlFactory.generatePlaceholders(notAutoGeneratedColumns.size()) + ") ";
        String insertSql = insertSqlPrefix + insertOrMergePlaceholders;
        String mergeSql = mergeSqlPrefix + insertOrMergePlaceholders;
        String selectAllSql = "select " + DefaultTableSqlFactory.toColumList(columns) + " from " + tableName;
        String selectByPrimaryKeySql = selectAllSql + " " + DefaultTableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        String existsSql = "select 1 from " + tableName + DefaultTableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys) + " limit 1";
        String updateSql = "update " + tableName + DefaultTableSqlFactory.createUpdateSetClause(tableMetaData.getNotPrimaryKeys()) + DefaultTableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        String deleteSql = "delete from " + tableName + DefaultTableSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        return new TableSql(insertOrMergePlaceholders, selectByPrimaryKeySql, selectAllSql, insertSql, updateSql, deleteSql, mergeSql, existsSql, insertSqlPrefix, mergeSqlPrefix);
    }

    private static String toColumList(List<String> columns) {
        return String.join((CharSequence)",", columns);
    }

    private static String createUpdateSetClause(List<String> notPrimaryKeys) {
        return " set " + String.join((CharSequence)",", notPrimaryKeys.stream().map(npk -> npk + "=?").collect(Collectors.toList()));
    }

    private static String createWhereClauseIdentifyByPrimaryKeys(List<String> primaryKeys) {
        return " where " + String.join((CharSequence)" and ", primaryKeys.stream().map(pk -> pk + "=?").collect(Collectors.toList()));
    }

    private static String generatePlaceholders(int num) {
        return String.join((CharSequence)",", Stream.generate(() -> "?").limit(num).collect(Collectors.toList()));
    }
}

