/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Try {
    public static <T, S> BiConsumer<T, S> createBiConsumer(ThrowableBiConsumer<T, S> onTry, Consumer<Exception> exceptionConsumer) {
        return (t, s) -> {
            try {
                onTry.accept(t, s);
            }
            catch (Exception e) {
                exceptionConsumer.accept(e);
            }
        };
    }

    public static <T, S, X extends RuntimeException> BiConsumer<T, S> createBiConsumerWithThrow(ThrowableBiConsumer<T, S> onTry, Function<Exception, ? extends X> exeptionThrower) throws X {
        return Try.createBiConsumer(onTry, e -> {
            throw (RuntimeException)exeptionThrower.apply((Exception)e);
        });
    }

    public static <T, R> Consumer<T> createConsumer(ThrowableConsumer<T> onTry, Consumer<Exception> exceptionConsumer) {
        return x -> {
            try {
                onTry.accept(x);
            }
            catch (Exception e) {
                exceptionConsumer.accept(e);
            }
        };
    }

    public static <T, X extends RuntimeException> Consumer<T> createConsumerWithThrow(ThrowableConsumer<T> onTry, Function<Exception, ? extends X> exeptionThrower) throws X {
        return Try.createConsumer(onTry, e -> {
            throw (RuntimeException)exeptionThrower.apply((Exception)e);
        });
    }

    public static <T, R> Function<T, R> createFunction(ThrowableFunction<T, R> onTry, Function<Exception, R> exceptionHandler) {
        return x -> {
            try {
                return onTry.apply(x);
            }
            catch (Exception e) {
                return exceptionHandler.apply(e);
            }
        };
    }

    public static <T, R, X extends RuntimeException> Function<T, R> createFunctionWithThrow(ThrowableFunction<T, R> onTry, Function<Exception, ? extends X> exceptionThrower) throws X {
        return Try.createFunction(onTry, e -> {
            throw (RuntimeException)exceptionThrower.apply((Exception)e);
        });
    }

    public static Runnable createRunnable(ThrowableRunnable onTry, Consumer<Exception> exceptionConsumer) {
        return () -> {
            try {
                onTry.run();
            }
            catch (Exception e) {
                exceptionConsumer.accept(e);
            }
        };
    }

    public static <X extends RuntimeException> Runnable createRunnableWithThrow(ThrowableRunnable onTry, Function<Exception, ? extends X> exceptionThrower) throws X {
        return Try.createRunnable(onTry, e -> {
            throw (RuntimeException)exceptionThrower.apply((Exception)e);
        });
    }

    public static <T> Supplier<T> createSupplier(ThrowableSupplier<T> onTry, Function<Exception, T> exceptionHandler) {
        return () -> {
            try {
                return onTry.get();
            }
            catch (Exception e) {
                return exceptionHandler.apply(e);
            }
        };
    }

    public static <T, X extends RuntimeException> Supplier<T> createSupplierWithThrow(ThrowableSupplier<T> onTry, Function<Exception, ? extends X> exceptionThrower) throws X {
        return Try.createSupplier(onTry, e -> {
            throw (RuntimeException)exceptionThrower.apply((Exception)e);
        });
    }

    public static <T> T getOrElse(ThrowableSupplier<T> onTry, T other) {
        return (T)Try.createSupplier(onTry, e -> other).get();
    }

    public static <T, X extends RuntimeException> T getOrElseGet(ThrowableSupplier<T> onTry, Function<Exception, T> ohterSupplier) {
        return (T)Try.createSupplier(onTry, e -> ohterSupplier.apply((Exception)e)).get();
    }

    public static <T, X extends RuntimeException> T getOrElseThrow(ThrowableSupplier<T> onTry, Function<Exception, ? extends X> exceptionSupplier) throws X {
        return (T)Try.createSupplier(onTry, e -> {
            throw (RuntimeException)exceptionSupplier.apply((Exception)e);
        }).get();
    }

    public static <T> T getOrElseNull(ThrowableSupplier<T> onTry) {
        return (T)Try.createSupplier(onTry, e -> null).get();
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static void runOrElseDo(ThrowableRunnable onTry, Consumer<Exception> exceptionHandler) {
        Try.createRunnable(onTry, exceptionHandler).run();
    }

    public static <T, X extends RuntimeException> void runOrElseThrow(ThrowableRunnable onTry, Function<Exception, ? extends X> exceptionThrower) throws X {
        Try.createRunnable(onTry, e -> {
            throw (RuntimeException)exceptionThrower.apply((Exception)e);
        }).run();
    }

    private Try() {
    }

    @FunctionalInterface
    public static interface ThrowableSupplier<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowableRunnable {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowableConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowableBiConsumer<T, S> {
        public void accept(T var1, S var2) throws Exception;
    }
}

