/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql;

import java.util.Map;
import java.util.TreeMap;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.sql.ParameterizedSqlImpl;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.sql.NamedParameterSql;
import org.nkjmlab.sorm4j.sql.OrderedParameterSql;

public interface ParameterizedSql {
    public String getSql();

    public Object[] getParameters();

    @Experimental
    public String getBindedSql();

    public static ParameterizedSql of(String sql) {
        return ParameterizedSqlImpl.of(sql, new Object[0]);
    }

    public static ParameterizedSql of(String sql, Object ... parameters) {
        return ParameterizedSqlImpl.of(sql, parameters);
    }

    public static ParameterizedSql parse(String sql, Object ... parameters) {
        return OrderedParameterSql.parse(sql, parameters);
    }

    public static ParameterizedSql parse(String sql, Map<String, Object> parameters) {
        return NamedParameterSql.parse(sql, parameters);
    }

    @Experimental
    public static String embedParameter(String sql, Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return sql;
        }
        return ParameterizedStringUtils.newString(sql, "{?}", parameters.length, index -> parameters[index] == null ? null : parameters[index].toString());
    }

    @Experimental
    public static String embedParameter(String sql, Map<String, Object> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return sql;
        }
        TreeMap orderdParams = new TreeMap();
        parameters.keySet().stream().forEach(key -> {
            int pos = sql.indexOf("{:" + key + "}");
            if (pos == -1) {
                return;
            }
            orderdParams.put(pos, parameters.get(key));
        });
        String _sql = sql.replaceAll("\\{:.*?\\}", "{?}");
        Object[] _parameters = orderdParams.values().toArray();
        return ParameterizedStringUtils.newString(_sql, "{?}", _parameters.length, index -> _parameters[index] == null ? null : _parameters[index].toString());
    }
}

