/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j;

import java.sql.Connection;
import javax.sql.DataSource;
import org.nkjmlab.sorm4j.Orm;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmTransaction;
import org.nkjmlab.sorm4j.SormContext;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.common.ConsumerHandler;
import org.nkjmlab.sorm4j.common.FunctionHandler;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.SormContextImpl;
import org.nkjmlab.sorm4j.internal.SormImpl;
import org.nkjmlab.sorm4j.internal.util.DriverManagerDataSource;

public interface Sorm
extends Orm {
    public static Sorm create(DataSource dataSource) {
        return Sorm.create(dataSource, SormContext.DEFAULT_CONTEXT);
    }

    public static Sorm create(DataSource dataSource, SormContext context) {
        return SormImpl.create(dataSource, context);
    }

    public static Sorm create(String jdbcUrl, String user, String password) {
        return Sorm.create(Sorm.createDataSource(jdbcUrl, user, password));
    }

    public static DataSource createDataSource(String jdbcUrl, String username, String password) {
        return new DriverManagerDataSource(jdbcUrl, username, password);
    }

    public static OrmConnection toOrmConnection(Connection connection) {
        return Sorm.toOrmConnection(connection, SormContext.DEFAULT_CONTEXT);
    }

    public static OrmConnection toOrmConnection(Connection connection, SormContext sormContext) {
        return new OrmConnectionImpl(connection, (SormContextImpl)SormContextImpl.class.cast(sormContext));
    }

    public void accept(ConsumerHandler<OrmConnection> var1);

    public void acceptTransactionHandler(ConsumerHandler<OrmTransaction> var1);

    public <R> R apply(FunctionHandler<OrmConnection, R> var1);

    public <R> R applyTransactionHandler(FunctionHandler<OrmTransaction, R> var1);

    @Experimental
    public SormContext getContext();

    public DataSource getDataSource();

    public Connection getJdbcConnection();

    public OrmConnection openConnection();

    public OrmTransaction openTransaction();
}

