/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.common.FunctionHandler;
import org.nkjmlab.sorm4j.internal.SormContextImpl;
import org.nkjmlab.sorm4j.internal.mapping.SqlParametersToTableMapping;
import org.nkjmlab.sorm4j.internal.mapping.SqlResultToColumnsMapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.sql.result.InsertResultImpl;
import org.nkjmlab.sorm4j.internal.sql.result.ResultSetStreamImpl;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.mapping.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.mapping.ColumnValueToMapEntryConverter;
import org.nkjmlab.sorm4j.mapping.ResultSetTraverser;
import org.nkjmlab.sorm4j.mapping.RowMapper;
import org.nkjmlab.sorm4j.mapping.SqlParametersSetter;
import org.nkjmlab.sorm4j.result.InsertResult;
import org.nkjmlab.sorm4j.result.ResultSetStream;
import org.nkjmlab.sorm4j.result.TableMetaData;
import org.nkjmlab.sorm4j.result.Tuple;
import org.nkjmlab.sorm4j.result.Tuple2;
import org.nkjmlab.sorm4j.result.Tuple3;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;
import org.nkjmlab.sorm4j.util.command.BasicCommand;
import org.nkjmlab.sorm4j.util.command.Command;
import org.nkjmlab.sorm4j.util.command.NamedParameterCommand;
import org.nkjmlab.sorm4j.util.command.OrderedParameterCommand;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;
import org.nkjmlab.sorm4j.util.sql.SqlKeyword;

public class OrmConnectionImpl
implements OrmConnection {
    private static final Supplier<int[]> EMPTY_INT_SUPPLIER = () -> new int[0];
    private final SormContextImpl sormContext;
    private final Connection connection;
    private final List<ResultSetStream<?>> resultSetStreams = new ArrayList();

    public OrmConnectionImpl(Connection connection, SormContextImpl sormContext) {
        this.connection = connection;
        this.sormContext = sormContext;
    }

    private LoggerContext getLoggerConfig() {
        return this.sormContext.getLoggerContext();
    }

    @Override
    public void begin() {
        this.begin(this.getTransactionIsolationLevel());
    }

    @Override
    public void begin(int isolationLevel) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(isolationLevel);
    }

    @Override
    public void close() {
        Try.runOrElseThrow(() -> {
            this.resultSetStreams.forEach(rs -> rs.close());
            this.resultSetStreams.clear();
            this.getJdbcConnection().close();
        }, Try::rethrow);
    }

    @Override
    public void commit() {
        Try.runOrElseThrow(() -> this.getJdbcConnection().commit(), Try::rethrow);
    }

    @Override
    public Command createCommand(ParameterizedSql sql) {
        return BasicCommand.from(this, sql.getSql()).addParameter(sql.getParameters());
    }

    @Override
    public BasicCommand createCommand(String sql) {
        return BasicCommand.from(this, sql);
    }

    @Override
    public NamedParameterCommand createCommand(String sql, Map<String, Object> parameters) {
        return NamedParameterCommand.from(this, sql).bindAll((Map)parameters);
    }

    @Override
    public OrderedParameterCommand createCommand(String sql, Object ... parameters) {
        return OrderedParameterCommand.from(this, sql).addParameter(parameters);
    }

    @Override
    public <T> int[] delete(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.delete((T)array));
    }

    @Override
    public <T> int delete(T object) {
        return this.getCastedTableMapping(object.getClass()).delete(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] delete(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.delete(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    @Override
    public <T> int deleteAll(Class<T> objectClass) {
        return this.deleteAllOn(this.getTableName(objectClass));
    }

    @Override
    public int deleteAllOn(String tableName) {
        return this.executeUpdate("DELETE FROM " + tableName, new Object[0]);
    }

    @Override
    public <T> int[] deleteOn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.deleteOn(tableName, (T)array));
    }

    @Override
    public <T> int deleteOn(String tableName, T object) {
        return this.getCastedParameterContainerAndTableMapping(tableName, object.getClass()).delete(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] deleteOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.delete(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    private final <T, R> R execSqlIfParameterExists(String tableName, T[] objects, Function<SqlParametersToTableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        SqlParametersToTableMapping<T> mapping = this.getCastedParameterContainerAndTableMapping(tableName, objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    private final <T, R> R execSqlIfParameterExists(T[] objects, Function<SqlParametersToTableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    @Override
    public <T> T executeQuery(FunctionHandler<Connection, PreparedStatement> statementSupplier, ResultSetTraverser<T> traverser) {
        return OrmConnectionImpl.executeQueryAndClose(this.connection, traverser, statementSupplier);
    }

    @Override
    public <T> List<T> executeQuery(FunctionHandler<Connection, PreparedStatement> statementSupplier, RowMapper<T> rowMapper) {
        return OrmConnectionImpl.executeQueryAndClose(this.connection, ResultSetTraverser.from(rowMapper), statementSupplier);
    }

    @Override
    public <T> T executeQuery(ParameterizedSql sql, ResultSetTraverser<T> resultSetTraverser) {
        return OrmConnectionImpl.executeQueryAndClose(this.getLoggerConfig(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql.getSql(), sql.getParameters(), resultSetTraverser);
    }

    @Override
    public <T> List<T> executeQuery(ParameterizedSql sql, RowMapper<T> rowMapper) {
        return this.executeQuery(sql, ResultSetTraverser.from(rowMapper));
    }

    @Override
    public int executeUpdate(ParameterizedSql sql) {
        return this.executeUpdate(sql.getSql(), sql.getParameters());
    }

    @Override
    public int executeUpdate(String sql, Object ... parameters) {
        int ret = OrmConnectionImpl.executeUpdateAndClose(this.getLoggerConfig(), this.connection, this.getSqlParametersSetter(), sql, parameters);
        return ret;
    }

    @Override
    public <T> boolean exists(T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        mapping.throwExeptionIfPrimaryKeyIsNotExist();
        return this.existsHelper(mapping, object);
    }

    private <T> boolean existsHelper(SqlParametersToTableMapping<T> mapping, T object) {
        mapping.throwExeptionIfPrimaryKeyIsNotExist();
        String sql = mapping.getSql().getExistsSql();
        return this.readFirst(Integer.class, sql, mapping.getPrimaryKeyParameters(object)) != null;
    }

    @Override
    public <T> boolean exists(String tableName, T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedParameterContainerAndTableMapping(tableName, object.getClass());
        mapping.throwExeptionIfPrimaryKeyIsNotExist();
        return this.existsHelper(mapping, object);
    }

    private <T> SqlParametersToTableMapping<T> getCastedTableMapping(Class<?> objectClass) {
        return this.sormContext.getCastedTableMapping(this.connection, objectClass);
    }

    private <T> SqlParametersToTableMapping<T> getCastedParameterContainerAndTableMapping(String tableName, Class<?> objectClass) {
        return this.sormContext.getCastedTableMapping(this.connection, tableName, objectClass);
    }

    <T> SqlResultToColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        return this.sormContext.getColumnsMapping(objectClass);
    }

    @Override
    public Connection getJdbcConnection() {
        return this.connection;
    }

    private static int getOneSqlType(Class<?> objectClass, ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        if (metaData.getColumnCount() != 1) {
            throw new SormException("ResultSet returned [" + metaData.getColumnCount() + "] columns but 1 column was expected to load data into an instance of [" + objectClass.getName() + "]");
        }
        return metaData.getColumnType(1);
    }

    private ColumnValueToJavaObjectConverters getColumnValueToJavaObjectConverter() {
        return this.sormContext.getColumnValueToJavaObjectConverter();
    }

    private ColumnValueToMapEntryConverter getColumnValueToMapEntryConverter() {
        return this.sormContext.getColumnValueToMapEntryConverter();
    }

    @Override
    public ResultSetTraverser<List<Map<String, Object>>> getResultSetToMapTraverser() {
        return resultSet -> this.traverseAndMapToMapList(resultSet);
    }

    @Override
    public <T> ResultSetTraverser<List<T>> getResultSetTraverser(Class<T> objectClass) {
        return resultSet -> this.traverseAndMapToList(objectClass, resultSet);
    }

    @Override
    public <T> RowMapper<T> getRowMapper(Class<T> objectClass) {
        return (resultSet, rowNum) -> this.mapRowToObject(objectClass, resultSet);
    }

    @Override
    public RowMapper<Map<String, Object>> getRowToMapMapper() {
        return (resultSet, rowNum) -> this.mapRowToMap(resultSet);
    }

    private SqlParametersSetter getSqlParametersSetter() {
        return this.sormContext.getSqlParametersSetter();
    }

    public <T> SqlParametersToTableMapping<T> getTableMapping(Class<T> objectClass) {
        return this.sormContext.getTableMapping(this.connection, objectClass);
    }

    @Override
    public TableMetaData getTableMetaData(Class<?> objectClass) {
        return this.getTableMapping(objectClass).getTableMetaData();
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        return this.sormContext.getTableMetaData(this.connection, tableName);
    }

    @Override
    public String getTableName(Class<?> objectClass) {
        return this.sormContext.getTableName(this.connection, objectClass);
    }

    private int getTransactionIsolationLevel() {
        return this.sormContext.getTransactionIsolationLevel();
    }

    @Override
    public <T> int[] insert(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insert((T)array));
    }

    @Override
    public <T> int insert(T object) {
        return this.getCastedTableMapping(object.getClass()).insert(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] insert(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.insert(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    @Override
    public int insertMapOn(String tableName, Map<String, Object> object) {
        ArrayList<String> cols = new ArrayList<String>(object.keySet());
        return this.executeUpdate(this.createInsertSql(tableName, cols), cols.stream().map(col -> object.get(col)).toArray());
    }

    private String createInsertSql(String tableName, List<String> cols) {
        String ps = String.join((CharSequence)",", Stream.generate(() -> "?").limit(cols.size()).collect(Collectors.toList()));
        String sql = "insert into " + tableName + " (" + String.join((CharSequence)",", cols) + ") VALUES (" + ps + ")";
        return sql;
    }

    @Override
    public int[] insertMapOn(String tableName, Map<String, Object> ... objects) {
        return this.insertMapOn(tableName, Arrays.asList(objects));
    }

    @Override
    public int[] insertMapOn(String tableName, List<Map<String, Object>> objects) {
        boolean origAutoCommit = MultiRowProcessor.getAutoCommit(this.connection);
        try {
            this.connection.setAutoCommit(false);
            int[] ret = objects.stream().mapToInt(o -> this.insertMapOn(tableName, (Map<String, Object>)o)).toArray();
            this.connection.setAutoCommit(true);
            int[] nArray = ret;
            return nArray;
        }
        catch (Exception e) {
            MultiRowProcessor.rollbackIfRequired(this.connection, origAutoCommit);
            throw Try.rethrow(e);
        }
        finally {
            MultiRowProcessor.commitIfRequired(this.connection, origAutoCommit);
            this.setAutoCommit(origAutoCommit);
        }
    }

    @Override
    public <T> InsertResult<T> insertAndGet(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insertAndGet((T)array));
    }

    @Override
    public <T> InsertResult<T> insertAndGet(T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        return mapping.insertAndGet(this.getJdbcConnection(), object);
    }

    @Override
    public <T> InsertResult<T> insertAndGet(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.insertAndGet(this.getJdbcConnection(), objects), () -> InsertResultImpl.emptyInsertResult());
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insertAndGetOn(tableName, (T)array));
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, T object) {
        SqlParametersToTableMapping<T> mapping = this.getCastedParameterContainerAndTableMapping(tableName, object.getClass());
        return mapping.insertAndGet(this.getJdbcConnection(), object);
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.insertAndGet(this.getJdbcConnection(), objects), () -> InsertResultImpl.emptyInsertResult());
    }

    @Override
    public <T> int[] insertOn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.insertOn(tableName, (T)array));
    }

    @Override
    public <T> int insertOn(String tableName, T object) {
        return this.getCastedParameterContainerAndTableMapping(tableName, object.getClass()).insert(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] insertOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.insert(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    public <T> T loadFirst(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return resultSet.next() ? (T)this.mapRowToObject(objectClass, resultSet) : null;
    }

    public Map<String, Object> loadFirstMap(ResultSet resultSet) throws SQLException {
        return resultSet.next() ? this.mapRowToMap(resultSet) : Collections.emptyMap();
    }

    private final <T> List<T> loadSupportedReturnedTypeList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        ArrayList<T> ret = new ArrayList<T>();
        int sqlType = OrmConnectionImpl.getOneSqlType(objectClass, resultSet);
        while (resultSet.next()) {
            ret.add(this.toSupportedReturnedTypeObject(resultSet, sqlType, objectClass));
        }
        return ret;
    }

    public <T> T loadOne(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        T ret = null;
        if (resultSet.next()) {
            ret = this.mapRowToObject(objectClass, resultSet);
        }
        if (resultSet.next()) {
            throw new SormException("Non-unique result returned");
        }
        return ret;
    }

    public Map<String, Object> loadOneMap(ResultSet resultSet) throws SQLException {
        Map<String, Object> ret = null;
        if (resultSet.next()) {
            ret = this.mapRowToMap(resultSet);
        }
        if (resultSet.next()) {
            throw new SormException("Non-unique result returned");
        }
        return ret;
    }

    public final <T> List<T> loadResultContainerObjectList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return this.getColumnsMapping(objectClass).traverseAndMap(resultSet);
    }

    private final <T> T loadResultContainerObject(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return this.getColumnsMapping(objectClass).loadResultContainerObject(resultSet);
    }

    public Map<String, Object> mapRowToMap(ResultSet resultSet) throws SQLException {
        ColumnsAndTypes ct = ColumnsAndTypes.createColumnsAndTypes(resultSet);
        return this.toSingleMap(resultSet, ct.getColumns(), ct.getColumnTypes());
    }

    public <T> T mapRowToObject(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return this.getColumnValueToJavaObjectConverter().isSupportedReturnedType(objectClass) ? this.toSupportedReturnedTypeObject(resultSet, OrmConnectionImpl.getOneSqlType(objectClass, resultSet), objectClass) : this.loadResultContainerObject(objectClass, resultSet);
    }

    private Map<String, Object> toSingleMap(ResultSet resultSet, List<String> columns, List<Integer> columnTypes) throws SQLException {
        int cSize = columns.size();
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>(cSize);
        for (int i = 1; i <= cSize; ++i) {
            ret.put(this.getColumnValueToMapEntryConverter().convertToKey(columns.get(i - 1)), this.getColumnValueToMapEntryConverter().convertToValue(resultSet, i, columnTypes.get(i - 1)));
        }
        return ret;
    }

    private <T> T toSupportedReturnedTypeObject(ResultSet resultSet, int sqlType, Class<T> objectClass) throws SQLException {
        return this.getColumnValueToJavaObjectConverter().convertTo(resultSet, 1, sqlType, objectClass);
    }

    @Override
    public <T> int[] merge(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.merge((T)array));
    }

    @Override
    public <T> int merge(T object) {
        return this.getCastedTableMapping(object.getClass()).merge(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] merge(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.merge(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    @Override
    public <T> int[] mergeOn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.mergeOn(tableName, (T)array));
    }

    @Override
    public <T> int mergeOn(String tableName, T object) {
        return this.getCastedParameterContainerAndTableMapping(tableName, object.getClass()).merge(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] mergeOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.merge(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    @Override
    public final <T> List<T> readAll(Class<T> objectClass) {
        return this.readList(objectClass, this.getCastedTableMapping(objectClass).getSql().getSelectAllSql(), new Object[0]);
    }

    @Override
    public <T> ResultSetStream<T> readAllStream(Class<T> objectClass) {
        return this.readStream(objectClass, this.getTableMapping(objectClass).getSql().getSelectAllSql(), new Object[0]);
    }

    @Override
    public <T> T readByPrimaryKey(Class<T> objectClass, Object ... primaryKeyValues) {
        SqlParametersToTableMapping<T> mapping = this.getTableMapping(objectClass);
        mapping.throwExeptionIfPrimaryKeyIsNotExist();
        String sql = mapping.getSql().getSelectByPrimaryKeySql();
        return (T)OrmConnectionImpl.executeQueryAndClose(this.getLoggerConfig(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, primaryKeyValues, resultSet -> resultSet.next() ? this.getColumnsMapping(objectClass).loadResultContainerObjectByPrimaryKey(objectClass, resultSet) : null);
    }

    @Override
    public <T> T readFirst(Class<T> objectClass, ParameterizedSql sql) {
        return this.readFirst(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> T readFirst(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)OrmConnectionImpl.executeQueryAndClose(this.getLoggerConfig(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> this.loadFirst(objectClass, resultSet));
    }

    @Override
    public <T> ResultSetStream<T> readStream(Class<T> objectClass, ParameterizedSql sql) {
        return this.readStream(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> ResultSetStream<T> readStream(Class<T> objectClass, String sql, Object ... parameters) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(sql);
            this.getSqlParametersSetter().setParameters(stmt, parameters);
            this.getLoggerConfig().createLogPointBeforeSql(LoggerContext.Category.EXECUTE_QUERY, OrmConnectionImpl.class, this.connection, sql, parameters);
            ResultSet resultSet = stmt.executeQuery();
            ResultSetStreamImpl<T> ret = new ResultSetStreamImpl<T>(this, objectClass, stmt, resultSet);
            this.resultSetStreams.add(ret);
            return ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public <T> List<T> readList(Class<T> objectClass, ParameterizedSql sql) {
        return this.readList(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> List<T> readList(Class<T> objectClass, String sql, Object ... parameters) {
        return OrmConnectionImpl.executeQueryAndClose(this.getLoggerConfig(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> this.traverseAndMapToList(objectClass, resultSet));
    }

    @Override
    public Map<String, Object> readMapFirst(ParameterizedSql sql) {
        return this.readMapFirst(sql.getSql(), sql.getParameters());
    }

    @Override
    public Map<String, Object> readMapFirst(String sql, Object ... parameters) {
        return OrmConnectionImpl.executeQueryAndClose(this.getLoggerConfig(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            ColumnsAndTypes ct = ColumnsAndTypes.createColumnsAndTypes(resultSet);
            if (resultSet.next()) {
                return this.toSingleMap(resultSet, ct.getColumns(), ct.getColumnTypes());
            }
            return null;
        });
    }

    @Override
    public ResultSetStream<Map<String, Object>> readMapStream(ParameterizedSql sql) {
        return this.readMapStream(sql.getSql(), sql.getParameters());
    }

    @Override
    public ResultSetStream<Map<String, Object>> readMapStream(String sql, Object ... parameters) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(sql);
            this.getSqlParametersSetter().setParameters(stmt, parameters);
            this.getLoggerConfig().createLogPointBeforeSql(LoggerContext.Category.EXECUTE_QUERY, OrmConnectionImpl.class, this.connection, sql, parameters);
            ResultSet resultSet = stmt.executeQuery();
            ResultSetStreamImpl<Map<String, Object>> ret = new ResultSetStreamImpl<Map<String, Object>>(this, stmt, resultSet);
            return ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public List<Map<String, Object>> readMapList(ParameterizedSql sql) {
        return this.readMapList(sql.getSql(), sql.getParameters());
    }

    @Override
    public List<Map<String, Object>> readMapList(String sql, Object ... parameters) {
        return OrmConnectionImpl.executeQueryAndClose(this.getLoggerConfig(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> this.traverseAndMapToMapList(resultSet));
    }

    @Override
    public Map<String, Object> readMapOne(ParameterizedSql sql) {
        return this.readMapOne(sql.getSql(), sql.getParameters());
    }

    @Override
    public Map<String, Object> readMapOne(String sql, Object ... parameters) {
        return OrmConnectionImpl.executeQueryAndClose(this.getLoggerConfig(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            ColumnsAndTypes ct = ColumnsAndTypes.createColumnsAndTypes(resultSet);
            Map<String, Object> ret = null;
            if (resultSet.next()) {
                ret = this.toSingleMap(resultSet, ct.getColumns(), ct.getColumnTypes());
            }
            if (resultSet.next()) {
                throw new SormException("Non-unique result returned");
            }
            return ret;
        });
    }

    @Override
    public <T> T readOne(Class<T> objectClass, ParameterizedSql sql) {
        return this.readOne(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> T readOne(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)OrmConnectionImpl.executeQueryAndClose(this.getLoggerConfig(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            Object ret = null;
            if (resultSet.next()) {
                ret = this.mapRowToObject(objectClass, resultSet);
            }
            if (resultSet.next()) {
                throw new SormException("Non-unique result returned");
            }
            return ret;
        });
    }

    @Override
    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> readTupleList(Class<T1> t1, Class<T2> t2, Class<T3> t3, ParameterizedSql sql) {
        return this.readTupleList(t1, t2, t3, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> readTupleList(Class<T1> t1, Class<T2> t2, Class<T3> t3, String sql, Object ... parameters) {
        List ret = OrmConnectionImpl.executeQueryAndClose(this.getLoggerConfig(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            ArrayList ret1 = new ArrayList();
            while (resultSet.next()) {
                ret1.add(Tuple.of(this.loadResultContainerObject(t1, resultSet), this.loadResultContainerObject(t2, resultSet), this.loadResultContainerObject(t3, resultSet)));
            }
            return ret1;
        });
        return ret;
    }

    @Override
    public <T1, T2> List<Tuple2<T1, T2>> readTupleList(Class<T1> t1, Class<T2> t2, ParameterizedSql sql) {
        return this.readTupleList(t1, t2, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T1, T2> List<Tuple2<T1, T2>> readTupleList(Class<T1> t1, Class<T2> t2, String sql, Object ... parameters) {
        List ret = OrmConnectionImpl.executeQueryAndClose(this.getLoggerConfig(), this.getJdbcConnection(), this.getSqlParametersSetter(), sql, parameters, resultSet -> {
            ArrayList ret1 = new ArrayList();
            while (resultSet.next()) {
                ret1.add(Tuple.of(this.loadResultContainerObject(t1, resultSet), this.loadResultContainerObject(t2, resultSet)));
            }
            return ret1;
        });
        return ret;
    }

    @Override
    public <T1, T2> List<Tuple2<T1, T2>> join(Class<T1> t1, Class<T2> t2, String onCondition) {
        return this.readTupleList(t1, t2, this.joinHelper(SqlKeyword.JOIN, t1, t2, onCondition), new Object[0]);
    }

    @Override
    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> join(Class<T1> t1, Class<T2> t2, String t1T2OnCondition, Class<T3> t3, String t2T3OnCondition) {
        return this.readTupleList(t1, t2, t3, this.joinHelper(SqlKeyword.JOIN, t1, t2, t1T2OnCondition, t3, t2T3OnCondition), new Object[0]);
    }

    private <T1, T2, T3> String joinHelper(String joinType, Class<T1> t1, Class<T2> t2, String t1T2OnCondition) {
        TableMetaData t1m = this.getTableMapping(t1).getTableMetaData();
        TableMetaData t2m = this.getTableMapping(t2).getTableMetaData();
        String sql = SqlKeyword.SELECT + t1m.getColumnAliases() + ", " + t2m.getColumnAliases() + ", " + SqlKeyword.FROM + t1m.getTableName() + joinType + t2m.getTableName();
        return sql;
    }

    private <T1, T2, T3> String joinHelper(String joinType, Class<T1> t1, Class<T2> t2, String t1T2OnCondition, Class<T3> t3, String t2T3OnCondition) {
        TableMetaData t1m = this.getTableMapping(t1).getTableMetaData();
        TableMetaData t2m = this.getTableMapping(t2).getTableMetaData();
        TableMetaData t3m = this.getTableMapping(t3).getTableMetaData();
        String sql = SqlKeyword.SELECT + t1m.getColumnAliases() + ", " + t2m.getColumnAliases() + ", " + t3m.getColumnAliases() + SqlKeyword.FROM + t1m.getTableName() + joinType + t2m.getTableName() + SqlKeyword.ON + t1T2OnCondition + joinType + t3m.getTableName() + SqlKeyword.ON + t2T3OnCondition;
        return sql;
    }

    @Override
    public <T1, T2> List<Tuple2<T1, T2>> leftJoin(Class<T1> t1, Class<T2> t2, String onCondition) {
        return this.readTupleList(t1, t2, this.joinHelper(SqlKeyword.LEFT + SqlKeyword.JOIN, t1, t2, onCondition), new Object[0]);
    }

    @Override
    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> leftJoin(Class<T1> t1, Class<T2> t2, String t1T2OnCondition, Class<T3> t3, String t2T3OnCondition) {
        return this.readTupleList(t1, t2, t3, this.joinHelper(SqlKeyword.LEFT + SqlKeyword.JOIN, t1, t2, t1T2OnCondition, t3, t2T3OnCondition), new Object[0]);
    }

    @Override
    public void rollback() {
        Try.runOrElseThrow(() -> this.getJdbcConnection().rollback(), Try::rethrow);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        Try.runOrElseThrow(() -> this.getJdbcConnection().setAutoCommit(autoCommit), Try::rethrow);
    }

    private void setTransactionIsolation(int isolationLevel) {
        Try.runOrElseThrow(() -> this.getJdbcConnection().setTransactionIsolation(isolationLevel), Try::rethrow);
    }

    public <T> List<T> traverseAndMapToList(Class<T> objectClass, ResultSet resultSet) {
        try {
            return this.getColumnValueToJavaObjectConverter().isSupportedReturnedType(objectClass) ? this.loadSupportedReturnedTypeList(objectClass, resultSet) : this.loadResultContainerObjectList(objectClass, resultSet);
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    public List<Map<String, Object>> traverseAndMapToMapList(ResultSet resultSet) {
        try {
            ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
            ColumnsAndTypes ct = ColumnsAndTypes.createColumnsAndTypes(resultSet);
            while (resultSet.next()) {
                ret.add(this.toSingleMap(resultSet, ct.getColumns(), ct.getColumnTypes()));
            }
            return ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public <T> int[] update(List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.update((T)array));
    }

    @Override
    public <T> int update(T object) {
        return this.getCastedTableMapping(object.getClass()).update(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] update(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.update(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    @Override
    public <T> int[] updateOn(String tableName, List<T> objects) {
        return OrmConnectionImpl.applytoArray(objects, array -> this.updateOn(tableName, (T)array));
    }

    @Override
    public <T> int updateOn(String tableName, T object) {
        return this.getCastedParameterContainerAndTableMapping(tableName, object.getClass()).update(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] updateOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.update(this.getJdbcConnection(), objects), EMPTY_INT_SUPPLIER);
    }

    private static <T, R> R applytoArray(List<T> objects, Function<T[], R> sqlFunc) {
        return sqlFunc.apply((T[][])objects.toArray(Object[]::new));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static <R> R executeQueryAndClose(Connection connection, ResultSetTraverser<R> resultSetTraverser, FunctionHandler<Connection, PreparedStatement> statementSupplier) {
        try (PreparedStatement stmt = statementSupplier.apply(connection);){
            R r;
            block14: {
                ResultSet resultSet = stmt.executeQuery();
                try {
                    r = resultSetTraverser.traverseAndMap(resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <R> R executeQueryAndClose(LoggerContext loggerContext, Connection connection, SqlParametersSetter sqlParametersSetter, String sql, Object[] parameters, ResultSetTraverser<R> resultSetTraverser) {
        Optional<LoggerContext.LogPoint> lp = loggerContext.createLogPointBeforeSql(LoggerContext.Category.EXECUTE_QUERY, OrmConnectionImpl.class, connection, sql, parameters);
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            sqlParametersSetter.setParameters(stmt, parameters);
            ResultSet resultSet = stmt.executeQuery();
            R ret = resultSetTraverser.traverseAndMap(resultSet);
            lp.ifPresent(_lp -> _lp.logAfterQuery(ret));
            R r = ret;
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    public static final int executeUpdateAndClose(LoggerContext loggerContext, Connection connection, SqlParametersSetter sqlParametersSetter, String sql, Object[] parameters) {
        int n;
        block8: {
            Optional<LoggerContext.LogPoint> lp = loggerContext.createLogPointBeforeSql(LoggerContext.Category.EXECUTE_UPDATE, OrmConnectionImpl.class, connection, sql, parameters);
            PreparedStatement stmt = connection.prepareStatement(sql);
            try {
                sqlParametersSetter.setParameters(stmt, parameters);
                int ret = stmt.executeUpdate();
                lp.ifPresent(_lp -> _lp.logAfterUpdate(ret));
                n = ret;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            stmt.close();
        }
        return n;
    }

    private static class ColumnsAndTypes {
        private final List<String> columns;
        private final List<Integer> columnTypes;

        private ColumnsAndTypes(List<String> columns, List<Integer> columnTypes) {
            this.columns = columns;
            this.columnTypes = columnTypes;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<Integer> getColumnTypes() {
            return this.columnTypes;
        }

        static ColumnsAndTypes createColumnsAndTypes(ResultSet resultSet) throws SQLException {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int colNum = metaData.getColumnCount();
            ArrayList<String> columns = new ArrayList<String>(colNum);
            ArrayList<Integer> columnTypes = new ArrayList<Integer>(colNum);
            for (int i = 1; i <= colNum; ++i) {
                columns.add(metaData.getColumnLabel(i));
                columnTypes.add(metaData.getColumnType(i));
            }
            return new ColumnsAndTypes(columns, columnTypes);
        }
    }
}

