/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SormContext;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.internal.mapping.SqlParametersToTableMapping;
import org.nkjmlab.sorm4j.internal.mapping.SqlResultToColumnsMapping;
import org.nkjmlab.sorm4j.internal.mapping.TableMetaDataImpl;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.mapping.ColumnToFieldAccessorMapper;
import org.nkjmlab.sorm4j.mapping.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.mapping.ColumnValueToMapEntryConverter;
import org.nkjmlab.sorm4j.mapping.DefaultTableMetaDataParser;
import org.nkjmlab.sorm4j.mapping.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.mapping.SqlParametersSetter;
import org.nkjmlab.sorm4j.mapping.TableMetaDataParser;
import org.nkjmlab.sorm4j.mapping.TableName;
import org.nkjmlab.sorm4j.mapping.TableNameMapper;
import org.nkjmlab.sorm4j.mapping.TableSql;
import org.nkjmlab.sorm4j.mapping.TableSqlFactory;
import org.nkjmlab.sorm4j.result.ColumnNameWithMetaData;
import org.nkjmlab.sorm4j.result.TableMetaData;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;

public final class SormContextImpl
implements SormContext {
    private final ConcurrentMap<String, SqlParametersToTableMapping<?>> tableMappings;
    private final ConcurrentMap<String, TableMetaData> tableMetaDataMap;
    private final ConcurrentMap<Class<?>, SqlResultToColumnsMapping<?>> columnsMappings;
    private final ConcurrentMap<Class<?>, TableName> classNameToValidTableNameMap;
    private final ConcurrentMap<String, TableName> tableNameToValidTableNameMap;
    private final SormConfig sormConfig;

    private SormContextImpl(SormConfig sormConfig) {
        this.sormConfig = sormConfig;
        this.tableMappings = new ConcurrentHashMap();
        this.tableMetaDataMap = new ConcurrentHashMap<String, TableMetaData>();
        this.columnsMappings = new ConcurrentHashMap();
        this.classNameToValidTableNameMap = new ConcurrentHashMap();
        this.tableNameToValidTableNameMap = new ConcurrentHashMap<String, TableName>();
    }

    public SormContextImpl(LoggerContext loggerContext, ColumnToFieldAccessorMapper columnFieldMapper, TableNameMapper tableNameMapper, ColumnValueToJavaObjectConverters columnValueToJavaObjectConverter, ColumnValueToMapEntryConverter columnValueToMapEntryConverter, SqlParametersSetter sqlParametersSetter, TableSqlFactory tableSqlFactory, MultiRowProcessorFactory multiRowProcessorFactory, int transactionIsolationLevel) {
        this(new SormConfig(loggerContext, columnFieldMapper, tableNameMapper, columnValueToJavaObjectConverter, columnValueToMapEntryConverter, sqlParametersSetter, tableSqlFactory, multiRowProcessorFactory, transactionIsolationLevel));
    }

    TableMetaData getTableMetaData(Connection connection, String tableName) {
        return this.getTableMetaData(connection, this.toTableName(connection, tableName));
    }

    private TableMetaData getTableMetaData(Connection connection, TableName tableName) {
        TableMetaData ret = this.tableMetaDataMap.computeIfAbsent(tableName.getName(), Try.createFunctionWithThrow(_key -> {
            TableMetaData m = this.createTableMetaData(Object.class, tableName.getName(), connection.getMetaData());
            return m;
        }, Try::rethrow));
        return ret;
    }

    <T> SqlParametersToTableMapping<T> getTableMapping(Connection connection, Class<T> objectClass) {
        return this.getTableMapping(connection, this.toTableName(connection, objectClass), objectClass);
    }

    <T> SqlParametersToTableMapping<T> getTableMapping(Connection connection, String tableName, Class<T> objectClass) {
        return this.getTableMapping(connection, this.toTableName(connection, tableName), objectClass);
    }

    <T> SqlParametersToTableMapping<T> getTableMapping(Connection connection, TableName tableName, Class<T> objectClass) {
        String key = tableName.getName() + "-" + objectClass.getName();
        SqlParametersToTableMapping ret = this.tableMappings.computeIfAbsent(key, _k -> {
            try {
                SqlParametersToTableMapping m = this.createTableMapping(objectClass, tableName.getName(), connection);
                this.sormConfig.getLoggerContext().createLogPoint(LoggerContext.Category.MAPPING, SormContext.class).ifPresent(lp -> lp.logMapping(m.getFormattedString()));
                return m;
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
        return ret;
    }

    <T> SqlResultToColumnsMapping<T> createColumnsMapping(Class<T> objectClass) {
        String columnAliasPrefix = TableMetaDataImpl.getColumnAliasPrefix(objectClass).orElse(objectClass.getSimpleName() + "CLAZZ");
        ColumnToAccessorMapping columnToAccessorMap = this.sormConfig.getColumnToFieldAccessorMapper().createMapping(objectClass, columnAliasPrefix);
        return new SqlResultToColumnsMapping<T>(this.sormConfig.getColumnValueToJavaObjectConverter(), objectClass, columnToAccessorMap);
    }

    <T> SqlParametersToTableMapping<T> createTableMapping(Class<T> objectClass, String tableName, Connection connection) throws SQLException {
        TableMetaData tableMetaData = this.createTableMetaData(objectClass, tableName, connection.getMetaData());
        String columnAliasPrefix = TableMetaDataImpl.getColumnAliasPrefix(objectClass).orElse(objectClass.getSimpleName() + "CLAZZ");
        ColumnToAccessorMapping columnToAccessorMap = this.sormConfig.getColumnToFieldAccessorMapper().createMapping(objectClass, columnAliasPrefix);
        this.validate(objectClass, tableMetaData, columnToAccessorMap.getAccessors().keySet());
        TableSql sql = this.sormConfig.getTableSqlFactory().create(tableMetaData, objectClass, connection);
        return new SqlParametersToTableMapping<T>(this.sormConfig.getLoggerContext(), this.sormConfig.getColumnValueToJavaObjectConverter(), this.sormConfig.getSqlParametersSetter(), this.sormConfig.getMultiRowProcessorFactory(), objectClass, columnToAccessorMap, tableMetaData, sql);
    }

    private void validate(Class<?> objectClass, TableMetaData tableMetaData, Set<String> keySetWithoutAlias) {
        List notMatchColumns = tableMetaData.getColumns().stream().filter(e -> !keySetWithoutAlias.contains(StringCache.toCanonicalCase(e))).sorted().collect(Collectors.toList());
        if (!notMatchColumns.isEmpty()) {
            throw new SormException(ParameterizedStringUtils.newString("{} does not match any field. Table [{}] contains Columns {} but [{}] contains field accessors {}.", notMatchColumns, tableMetaData.getTableName(), tableMetaData.getColumns().stream().map(c -> c.toString()).sorted().collect(Collectors.toList()), objectClass.getName(), keySetWithoutAlias.stream().sorted().collect(Collectors.toList())));
        }
    }

    private <T> TableMetaData createTableMetaData(Class<T> objectClass, String tableName, DatabaseMetaData metaData) throws SQLException {
        List<ColumnNameWithMetaData> columns = this.sormConfig.getTableMetaDataReader().getColumns(metaData, tableName);
        List<String> primaryKeys = this.sormConfig.getTableMetaDataReader().getPrimaryKeys(metaData, tableName).stream().map(c -> c.getName()).collect(Collectors.toList());
        List<String> autoGeneratedColumns = this.sormConfig.getTableMetaDataReader().getAutoGeneratedColumns(metaData, tableName).stream().map(c -> c.getName()).collect(Collectors.toList());
        String columnAliasPrefix = TableMetaDataImpl.getColumnAliasPrefix(objectClass).orElse(tableName + "TABLE");
        return new TableMetaDataImpl(tableName, columnAliasPrefix, columns, primaryKeys, autoGeneratedColumns);
    }

    <T> SqlParametersToTableMapping<T> getCastedTableMapping(Connection connection, Class<?> objectClass) {
        return this.getTableMapping(connection, objectClass);
    }

    <T> SqlParametersToTableMapping<T> getCastedTableMapping(Connection connection, String tableName, Class<?> objectClass) {
        return this.getTableMapping(connection, tableName, objectClass);
    }

    <T> SqlResultToColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        SqlResultToColumnsMapping ret = this.columnsMappings.computeIfAbsent(objectClass, _k -> {
            SqlResultToColumnsMapping m = this.createColumnsMapping(objectClass);
            this.sormConfig.getLoggerContext().createLogPoint(LoggerContext.Category.MAPPING, SormContext.class).ifPresent(lp -> lp.logMapping(m.getFormattedString()));
            return m;
        });
        return ret;
    }

    private TableName toTableName(Connection connection, Class<?> objectClass) {
        return this.classNameToValidTableNameMap.computeIfAbsent(objectClass, k -> {
            try {
                return this.sormConfig.getTableNameMapper().getTableName(objectClass, connection.getMetaData());
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
    }

    String getTableName(Connection connection, Class<?> objectClass) {
        return this.toTableName(connection, objectClass).getName();
    }

    private TableName toTableName(Connection connection, String tableName) {
        return this.tableNameToValidTableNameMap.computeIfAbsent(tableName, k -> {
            try {
                return this.sormConfig.getTableNameMapper().getTableName(tableName, connection.getMetaData());
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
    }

    @Override
    public LoggerContext getLoggerContext() {
        return this.sormConfig.getLoggerContext();
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.sormConfig.getTransactionIsolationLevel();
    }

    ColumnValueToJavaObjectConverters getColumnValueToJavaObjectConverter() {
        return this.sormConfig.getColumnValueToJavaObjectConverter();
    }

    ColumnValueToMapEntryConverter getColumnValueToMapEntryConverter() {
        return this.sormConfig.getColumnValueToMapEntryConverter();
    }

    SqlParametersSetter getSqlParametersSetter() {
        return this.sormConfig.getSqlParametersSetter();
    }

    public String toString() {
        return "SormContext [tableMappings=" + this.tableMappings + ", columnsMappings=" + this.columnsMappings + ", classNameToValidTableNameMap=" + this.classNameToValidTableNameMap + ", tableNameToValidTableNameMap=" + this.tableNameToValidTableNameMap + ", sormConfig=" + this.sormConfig + "]";
    }

    static final class SormConfig {
        private final TableNameMapper tableNameMapper;
        private final ColumnToFieldAccessorMapper columnFieldMapper;
        private final MultiRowProcessorFactory multiRowProcessorFactory;
        private final ColumnValueToJavaObjectConverters columnValueToJavaObjectConverter;
        private final ColumnValueToMapEntryConverter columnValueToMapEntryConverter;
        private final SqlParametersSetter sqlParametersSetter;
        private final int transactionIsolationLevel;
        private final LoggerContext loggerContext;
        private final TableSqlFactory tableSqlFactory;
        private final TableMetaDataParser tableMetaDataReader = new DefaultTableMetaDataParser();

        SormConfig(LoggerContext loggerContext, ColumnToFieldAccessorMapper columnFieldMapper, TableNameMapper tableNameMapper, ColumnValueToJavaObjectConverters columnValueToJavaObjectConverter, ColumnValueToMapEntryConverter columnValueToMapEntryConverter, SqlParametersSetter sqlParametersSetter, TableSqlFactory tableSqlFactory, MultiRowProcessorFactory multiRowProcessorFactory, int transactionIsolationLevel) {
            this.loggerContext = loggerContext;
            this.transactionIsolationLevel = transactionIsolationLevel;
            this.tableNameMapper = tableNameMapper;
            this.columnFieldMapper = columnFieldMapper;
            this.multiRowProcessorFactory = multiRowProcessorFactory;
            this.columnValueToJavaObjectConverter = columnValueToJavaObjectConverter;
            this.columnValueToMapEntryConverter = columnValueToMapEntryConverter;
            this.sqlParametersSetter = sqlParametersSetter;
            this.tableSqlFactory = tableSqlFactory;
        }

        TableMetaDataParser getTableMetaDataReader() {
            return this.tableMetaDataReader;
        }

        int getTransactionIsolationLevel() {
            return this.transactionIsolationLevel;
        }

        ColumnValueToJavaObjectConverters getColumnValueToJavaObjectConverter() {
            return this.columnValueToJavaObjectConverter;
        }

        ColumnValueToMapEntryConverter getColumnValueToMapEntryConverter() {
            return this.columnValueToMapEntryConverter;
        }

        SqlParametersSetter getSqlParametersSetter() {
            return this.sqlParametersSetter;
        }

        LoggerContext getLoggerContext() {
            return this.loggerContext;
        }

        ColumnToFieldAccessorMapper getColumnToFieldAccessorMapper() {
            return this.columnFieldMapper;
        }

        TableNameMapper getTableNameMapper() {
            return this.tableNameMapper;
        }

        TableSqlFactory getTableSqlFactory() {
            return this.tableSqlFactory;
        }

        MultiRowProcessorFactory getMultiRowProcessorFactory() {
            return this.multiRowProcessorFactory;
        }

        public String toString() {
            return "SormConfig [tableNameMapper=" + this.tableNameMapper + ", columnFieldMapper=" + this.columnFieldMapper + ", multiRowProcessorFactory=" + this.multiRowProcessorFactory + ", columnValueToJavaObjectConverter=" + this.columnValueToJavaObjectConverter + ", columnValueToMapEntryConverter=" + this.columnValueToMapEntryConverter + ", sqlParametersSetter=" + this.sqlParametersSetter + ", transactionIsolationLevel=" + this.transactionIsolationLevel + ", loggerContext=" + this.loggerContext + ", tableSqlFactory=" + this.tableSqlFactory + "]";
        }
    }
}

