/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmTransaction;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.SormContext;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.common.ConsumerHandler;
import org.nkjmlab.sorm4j.common.FunctionHandler;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.OrmTransactionImpl;
import org.nkjmlab.sorm4j.internal.SormContextImpl;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.mapping.ResultSetTraverser;
import org.nkjmlab.sorm4j.mapping.RowMapper;
import org.nkjmlab.sorm4j.result.InsertResult;
import org.nkjmlab.sorm4j.result.TableMetaData;
import org.nkjmlab.sorm4j.result.Tuple2;
import org.nkjmlab.sorm4j.result.Tuple3;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;
import org.nkjmlab.sorm4j.util.command.BasicCommand;
import org.nkjmlab.sorm4j.util.command.Command;
import org.nkjmlab.sorm4j.util.command.NamedParameterCommand;
import org.nkjmlab.sorm4j.util.command.OrderedParameterCommand;

public final class SormImpl
implements Sorm {
    private final DataSource dataSource;
    private final SormContextImpl sormContext;

    @Experimental
    public static Sorm create(DataSource dataSource, SormContext context) {
        return new SormImpl(dataSource, (SormContextImpl)context);
    }

    public SormImpl(DataSource connectionSource, SormContextImpl context) {
        this.sormContext = context;
        this.dataSource = connectionSource;
    }

    @Override
    public OrmTransaction openTransaction() {
        return new OrmTransactionImpl(this.getJdbcConnection(), this.sormContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R apply(FunctionHandler<OrmConnection, R> handler) {
        try (OrmConnection conn = this.openConnection();){
            R r = handler.apply(conn);
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R applyTransactionHandler(FunctionHandler<OrmTransaction, R> handler) {
        try (OrmTransaction transaction = this.openTransaction();){
            R ret = handler.apply(transaction);
            transaction.commit();
            R r = ret;
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public SormContext getContext() {
        return this.sormContext;
    }

    @Override
    public OrmConnection openConnection() {
        return new OrmConnectionImpl(this.getJdbcConnection(), this.sormContext);
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Connection getJdbcConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public void accept(ConsumerHandler<OrmConnection> handler) {
        try (OrmConnection conn = this.openConnection();){
            handler.accept(conn);
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public void acceptTransactionHandler(ConsumerHandler<OrmTransaction> handler) {
        try (OrmTransaction transaction = this.openTransaction();){
            handler.accept(transaction);
            transaction.commit();
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    public String toString() {
        return "Sorm [dataSource=" + this.dataSource + ", sormConfig=" + this.sormContext + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R applyAndClose(FunctionHandler<OrmConnection, R> handler) {
        try (OrmConnection conn = this.openConnection();){
            R r = handler.apply(conn);
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public <T> List<T> readAll(Class<T> objectClass) {
        return this.applyAndClose(conn -> conn.readAll(objectClass));
    }

    @Override
    public <T> T readByPrimaryKey(Class<T> objectClass, Object ... primaryKeyValues) {
        return (T)this.applyAndClose(conn -> conn.readByPrimaryKey(objectClass, primaryKeyValues));
    }

    @Override
    public <T> T readFirst(Class<T> objectClass, ParameterizedSql sql) {
        return (T)this.applyAndClose(conn -> conn.readFirst(objectClass, sql));
    }

    @Override
    public <T> T readFirst(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)this.applyAndClose(conn -> conn.readFirst(objectClass, sql, parameters));
    }

    @Override
    public <T> List<T> readList(Class<T> objectClass, ParameterizedSql sql) {
        return this.applyAndClose(conn -> conn.readList(objectClass, sql));
    }

    @Override
    public <T> List<T> readList(Class<T> objectClass, String sql, Object ... parameters) {
        return this.applyAndClose(conn -> conn.readList(objectClass, sql, parameters));
    }

    @Override
    public <T> T readOne(Class<T> objectClass, ParameterizedSql sql) {
        return (T)this.applyAndClose(conn -> conn.readOne(objectClass, sql));
    }

    @Override
    public <T> T readOne(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)this.applyAndClose(conn -> conn.readOne(objectClass, sql, parameters));
    }

    @Override
    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> readTupleList(Class<T1> t1, Class<T2> t2, Class<T3> t3, ParameterizedSql sql) {
        return this.applyAndClose(conn -> conn.readTupleList(t1, t2, t3, sql));
    }

    @Override
    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> readTupleList(Class<T1> t1, Class<T2> t2, Class<T3> t3, String sql, Object ... parameters) {
        return this.applyAndClose(conn -> conn.readTupleList(t1, t2, t3, sql, parameters));
    }

    @Override
    public <T1, T2> List<Tuple2<T1, T2>> readTupleList(Class<T1> t1, Class<T2> t2, ParameterizedSql sql) {
        return this.applyAndClose(conn -> conn.readTupleList(t1, t2, sql));
    }

    @Override
    public <T1, T2> List<Tuple2<T1, T2>> readTupleList(Class<T1> t1, Class<T2> t2, String sql, Object ... parameters) {
        return this.applyAndClose(conn -> conn.readTupleList(t1, t2, sql, parameters));
    }

    @Override
    public <T1, T2> List<Tuple2<T1, T2>> join(Class<T1> t1, Class<T2> t2, String onCondition) {
        return this.applyAndClose(conn -> conn.join(t1, t2, onCondition));
    }

    @Override
    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> join(Class<T1> t1, Class<T2> t2, String t1t2OnCondition, Class<T3> t3, String t2t3OnCondition) {
        return this.applyAndClose(conn -> conn.join(t1, t2, t1t2OnCondition, t3, t2t3OnCondition));
    }

    @Override
    public <T1, T2> List<Tuple2<T1, T2>> leftJoin(Class<T1> t1, Class<T2> t2, String onCondition) {
        return this.applyAndClose(conn -> conn.join(t1, t2, onCondition));
    }

    @Override
    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> leftJoin(Class<T1> t1, Class<T2> t2, String t1t2OnCondition, Class<T3> t3, String t2t3OnCondition) {
        return this.applyAndClose(conn -> conn.leftJoin(t1, t2, t1t2OnCondition, t3, t2t3OnCondition));
    }

    @Override
    public <T> RowMapper<T> getRowMapper(Class<T> objectClass) {
        return this.applyAndClose(conn -> conn.getRowMapper(objectClass));
    }

    @Override
    public <T> ResultSetTraverser<List<T>> getResultSetTraverser(Class<T> objectClass) {
        return this.applyAndClose(conn -> conn.getResultSetTraverser(objectClass));
    }

    @Override
    public <T> boolean exists(T object) {
        return this.applyAndClose(conn -> conn.exists(object));
    }

    @Override
    public <T> boolean exists(String tableName, T object) {
        return this.applyAndClose(conn -> conn.exists(tableName, object));
    }

    @Override
    public <T> int[] delete(List<T> objects) {
        return this.applyAndClose(conn -> conn.delete(objects));
    }

    @Override
    public <T> int delete(T object) {
        return this.applyAndClose(conn -> conn.delete(object));
    }

    @Override
    public <T> int[] delete(T ... objects) {
        return this.applyAndClose(conn -> conn.delete(objects));
    }

    @Override
    public <T> int[] deleteOn(String tableName, List<T> objects) {
        return this.applyAndClose(conn -> conn.deleteOn(tableName, objects));
    }

    @Override
    public <T> int deleteOn(String tableName, T object) {
        return this.applyAndClose(conn -> conn.deleteOn(tableName, object));
    }

    @Override
    public <T> int[] deleteOn(String tableName, T ... objects) {
        return this.applyAndClose(conn -> conn.deleteOn(tableName, objects));
    }

    @Override
    public <T> int deleteAll(Class<T> objectClass) {
        return this.applyAndClose(conn -> conn.deleteAll(objectClass));
    }

    @Override
    public int deleteAllOn(String tableName) {
        return this.applyAndClose(conn -> conn.deleteAllOn(tableName));
    }

    @Override
    public <T> int[] insert(List<T> objects) {
        return this.applyAndClose(conn -> conn.insert(objects));
    }

    @Override
    public <T> int insert(T object) {
        return this.applyAndClose(conn -> conn.insert(object));
    }

    @Override
    public int insertMapOn(String tableName, Map<String, Object> object) {
        return this.applyAndClose(conn -> conn.insertMapOn(tableName, object));
    }

    @Override
    public int[] insertMapOn(String tableName, Map<String, Object> ... objects) {
        return this.applyAndClose(conn -> conn.insertMapOn(tableName, objects));
    }

    @Override
    public int[] insertMapOn(String tableName, List<Map<String, Object>> objects) {
        return this.applyAndClose(conn -> conn.insertMapOn(tableName, objects));
    }

    @Override
    public <T> int[] insert(T ... objects) {
        return this.applyAndClose(conn -> conn.insert(objects));
    }

    @Override
    public <T> InsertResult<T> insertAndGet(List<T> objects) {
        return this.applyAndClose(conn -> conn.insertAndGet(objects));
    }

    @Override
    public <T> InsertResult<T> insertAndGet(T object) {
        return this.applyAndClose(conn -> conn.insertAndGet(object));
    }

    @Override
    public <T> InsertResult<T> insertAndGet(T ... objects) {
        return this.applyAndClose(conn -> conn.insertAndGet(objects));
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, List<T> objects) {
        return this.applyAndClose(conn -> conn.insertAndGetOn(tableName, objects));
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, T object) {
        return this.applyAndClose(conn -> conn.insertAndGetOn(tableName, object));
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, T ... objects) {
        return this.applyAndClose(conn -> conn.insertAndGetOn(tableName, objects));
    }

    @Override
    public <T> int[] insertOn(String tableName, List<T> objects) {
        return this.applyAndClose(conn -> conn.insertOn(tableName, objects));
    }

    @Override
    public <T> int insertOn(String tableName, T object) {
        return this.applyAndClose(conn -> conn.insertOn(tableName, object));
    }

    @Override
    public <T> int[] insertOn(String tableName, T ... objects) {
        return this.applyAndClose(conn -> conn.insertOn(tableName, objects));
    }

    @Override
    public <T> int[] merge(List<T> objects) {
        return this.applyAndClose(conn -> conn.merge(objects));
    }

    @Override
    public <T> int merge(T object) {
        return this.applyAndClose(conn -> conn.merge(object));
    }

    @Override
    public <T> int[] merge(T ... objects) {
        return this.applyAndClose(conn -> conn.merge(objects));
    }

    @Override
    public <T> int[] mergeOn(String tableName, List<T> objects) {
        return this.applyAndClose(conn -> conn.mergeOn(tableName, objects));
    }

    @Override
    public <T> int mergeOn(String tableName, T object) {
        return this.applyAndClose(conn -> conn.mergeOn(tableName, object));
    }

    @Override
    public <T> int[] mergeOn(String tableName, T ... objects) {
        return this.applyAndClose(conn -> conn.mergeOn(tableName, objects));
    }

    @Override
    public <T> int[] update(List<T> objects) {
        return this.applyAndClose(conn -> conn.update(objects));
    }

    @Override
    public <T> int update(T object) {
        return this.applyAndClose(conn -> conn.update(object));
    }

    @Override
    public <T> int[] update(T ... objects) {
        return this.applyAndClose(conn -> conn.update(objects));
    }

    @Override
    public <T> int[] updateOn(String tableName, List<T> objects) {
        return this.applyAndClose(conn -> conn.updateOn(tableName, objects));
    }

    @Override
    public <T> int updateOn(String tableName, T object) {
        return this.applyAndClose(conn -> conn.updateOn(tableName, object));
    }

    @Override
    public <T> int[] updateOn(String tableName, T ... objects) {
        return this.applyAndClose(conn -> conn.updateOn(tableName, objects));
    }

    @Override
    public String getTableName(Class<?> objectClass) {
        return this.applyAndClose(conn -> conn.getTableName(objectClass));
    }

    @Override
    public TableMetaData getTableMetaData(Class<?> objectClass) {
        return this.applyAndClose(conn -> conn.getTableMetaData(objectClass));
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        return this.applyAndClose(conn -> conn.getTableMetaData(tableName));
    }

    @Override
    public RowMapper<Map<String, Object>> getRowToMapMapper() {
        return this.applyAndClose(conn -> conn.getRowToMapMapper());
    }

    @Override
    public ResultSetTraverser<List<Map<String, Object>>> getResultSetToMapTraverser() {
        return this.applyAndClose(conn -> conn.getResultSetToMapTraverser());
    }

    @Override
    public Map<String, Object> readMapFirst(ParameterizedSql sql) {
        return this.applyAndClose(conn -> conn.readMapFirst(sql));
    }

    @Override
    public Map<String, Object> readMapFirst(String sql, Object ... parameters) {
        return this.applyAndClose(conn -> conn.readMapFirst(sql, parameters));
    }

    @Override
    public List<Map<String, Object>> readMapList(ParameterizedSql sql) {
        return this.applyAndClose(conn -> conn.readMapList(sql));
    }

    @Override
    public List<Map<String, Object>> readMapList(String sql, Object ... parameters) {
        return this.applyAndClose(conn -> conn.readMapList(sql, parameters));
    }

    @Override
    public Map<String, Object> readMapOne(ParameterizedSql sql) {
        return this.applyAndClose(conn -> conn.readMapOne(sql));
    }

    @Override
    public Map<String, Object> readMapOne(String sql, Object ... parameters) {
        return this.applyAndClose(conn -> conn.readMapOne(sql, parameters));
    }

    @Override
    public <T> T executeQuery(FunctionHandler<Connection, PreparedStatement> statementSupplier, ResultSetTraverser<T> traverser) {
        return (T)this.applyAndClose(conn -> conn.executeQuery(statementSupplier, traverser));
    }

    @Override
    public <T> List<T> executeQuery(FunctionHandler<Connection, PreparedStatement> statementSupplier, RowMapper<T> rowMapper) {
        return this.applyAndClose(conn -> conn.executeQuery(statementSupplier, rowMapper));
    }

    @Override
    public <T> T executeQuery(ParameterizedSql sql, ResultSetTraverser<T> traverser) {
        return (T)this.applyAndClose(conn -> conn.executeQuery(sql, traverser));
    }

    @Override
    public <T> List<T> executeQuery(ParameterizedSql sql, RowMapper<T> mapper) {
        return this.applyAndClose(conn -> conn.executeQuery(sql, mapper));
    }

    @Override
    public int executeUpdate(String sql, Object ... parameters) {
        return this.applyAndClose(conn -> conn.executeUpdate(sql, parameters));
    }

    @Override
    public int executeUpdate(ParameterizedSql sql) {
        return this.applyAndClose(conn -> conn.executeUpdate(sql));
    }

    @Override
    public Command createCommand(ParameterizedSql sql) {
        return this.applyAndClose(conn -> conn.createCommand(sql));
    }

    @Override
    public BasicCommand createCommand(String sql) {
        return this.applyAndClose(conn -> conn.createCommand(sql));
    }

    @Override
    public OrderedParameterCommand createCommand(String sql, Object ... parameters) {
        return this.applyAndClose(conn -> conn.createCommand(sql, parameters));
    }

    @Override
    public NamedParameterCommand createCommand(String sql, Map<String, Object> parameters) {
        return this.applyAndClose(conn -> conn.createCommand(sql, parameters));
    }
}

